/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.villager;

import javax.annotation.Nonnull;
import jeresources.collection.TradeList;
import jeresources.jei.villager.VillagerWrapper;
import jeresources.reference.Resources;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;

public class VillagerCategory
extends BlankRecipeCategory {
    protected static final int X_FIRST_ITEM = 95;
    protected static final int X_ITEM_DISTANCE = 18;
    protected static final int X_ITEM_RESULT = 150;
    protected static final int Y_ITEM_DISTANCE = 22;

    @Nonnull
    public String getUid() {
        return "jeresources.villager";
    }

    @Nonnull
    public String getTitle() {
        return TranslationHelper.translateToLocal("jer.villager.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.VILLAGER;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        if (recipeWrapper instanceof VillagerWrapper) {
            int i;
            VillagerWrapper wrapper = (VillagerWrapper)recipeWrapper;
            IFocus focus = recipeLayout.getItemStacks().getFocus();
            wrapper.setFocus((IFocus<ItemStack>)focus);
            int y = 22 * (6 - wrapper.getPossibleLevels((IFocus<ItemStack>)focus).size()) / 2;
            for (i = 0; i < wrapper.getPossibleLevels((IFocus<ItemStack>)focus).size(); ++i) {
                recipeLayout.getItemStacks().init(3 * i, true, 95, y + i * 22);
                recipeLayout.getItemStacks().init(3 * i + 1, true, 113, y + i * 22);
                recipeLayout.getItemStacks().init(3 * i + 2, false, 150, y + i * 22);
            }
            i = 0;
            for (int level : wrapper.getPossibleLevels((IFocus<ItemStack>)focus)) {
                TradeList tradeList = wrapper.getTrades(level).getFocusedList((IFocus<ItemStack>)focus);
                recipeLayout.getItemStacks().set(3 * i, tradeList.getFirstBuyStacks());
                recipeLayout.getItemStacks().set(3 * i + 1, tradeList.getSecondBuyStacks());
                recipeLayout.getItemStacks().set(3 * i + 2, tradeList.getSellStacks());
                ++i;
            }
        }
    }
}

