/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.villager;

import java.util.List;
import javax.annotation.Nonnull;
import jeresources.collection.TradeList;
import jeresources.entry.VillagerEntry;
import jeresources.reference.Resources;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class VillagerWrapper
extends BlankRecipeWrapper {
    private final VillagerEntry entry;
    private IFocus<ItemStack> focus;

    public VillagerWrapper(VillagerEntry entry) {
        this.entry = entry;
    }

    @Nonnull
    public List getInputs() {
        return this.entry.getInputs();
    }

    @Nonnull
    public List getOutputs() {
        return this.entry.getOutputs();
    }

    public TradeList getTrades(int level) {
        return this.entry.getVillagerTrades(level);
    }

    public int getMaxLevel() {
        return this.entry.getMaxLevel();
    }

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        return this.entry.getPossibleLevels(focus);
    }

    public void setFocus(IFocus<ItemStack> focus) {
        this.focus = focus;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int i;
        RenderHelper.scissor(minecraft, recipeWidth, recipeHeight, 7.2f, 57.8f, 59.0f, 79.0f);
        RenderHelper.renderEntity(37, 118, 36.0f, 38 - mouseX, 80 - mouseY, (EntityLivingBase)new EntityVillager((World)minecraft.field_71441_e, this.entry.getProfession()));
        RenderHelper.stopScissor();
        int y = 22 * (6 - this.getPossibleLevels(this.focus).size()) / 2;
        for (i = 0; i < this.getPossibleLevels(this.focus).size(); ++i) {
            RenderHelper.drawTexture(130, y + i * 22, 0, 120, 20, 20, Resources.Gui.Jei.VILLAGER.getResource());
        }
        i = 0;
        for (int level : this.getPossibleLevels(this.focus)) {
            Font.normal.print("lv. " + level, 72, y + i++ * 22 + 6);
        }
        Font.normal.print(TranslationHelper.translateToLocal(this.entry.getDisplayName()), 10, 25);
    }
}

