/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import javax.annotation.Nonnull;
import jeresources.jei.worldgen.WorldGenWrapper;
import jeresources.reference.Resources;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;

public class WorldGenCategory
extends BlankRecipeCategory {
    protected static final int X_ITEM = 5;
    protected static final int Y_ITEM = 21;
    protected static final int X_DROP_ITEM = 5;
    protected static final int Y_DROP_ITEM = 66;
    private static final int DROP_ITEM_COUNT = 8;

    @Nonnull
    public String getUid() {
        return "jeresources.worldgen";
    }

    @Nonnull
    public String getTitle() {
        return TranslationHelper.translateToLocal("jer.worldgen.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.WORLD_GEN;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        RenderHelper.drawLine(29.0, 52.0, 157.0, 52.0, -7829368);
        RenderHelper.drawLine(29.0, 52.0, 29.0, 12.0, -7829368);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        recipeLayout.getItemStacks().init(0, false, 5, 21);
        for (int i = 0; i < 8; ++i) {
            recipeLayout.getItemStacks().init(i + 1, false, 5 + i * 18, 66);
        }
        if (recipeWrapper instanceof WorldGenWrapper) {
            WorldGenWrapper worldGenWrapper = (WorldGenWrapper)recipeWrapper;
            recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)worldGenWrapper);
            recipeLayout.getItemStacks().set(0, worldGenWrapper.getBlock());
            for (int i = 0; i < Math.min(8, worldGenWrapper.getDrops().size()); ++i) {
                recipeLayout.getItemStacks().set(i + 1, worldGenWrapper.getDrops().get(i));
            }
        }
    }
}

