/*
 * Decompiled with CFR 0.152.
 */
package jeresources.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import jeresources.util.MapKeys;
import net.minecraft.item.ItemStack;

public class PlantRegistry {
    private Map<String, PlantEntry> registry = new LinkedHashMap<String, PlantEntry>();
    private static PlantRegistry instance;

    public static PlantRegistry getInstance() {
        if (instance == null) {
            instance = new PlantRegistry();
            return instance;
        }
        return instance;
    }

    public PlantRegistry() {
        this.registerPlant(PlantEntry.registerGrass());
    }

    public boolean registerPlant(PlantEntry entry) {
        String key = MapKeys.getKey(entry.getPlantItemStack());
        if (this.contains(key)) {
            return false;
        }
        this.registry.put(key, entry);
        return true;
    }

    private boolean contains(String key) {
        return this.registry.containsKey(key);
    }

    public List<PlantEntry> getAllPlants() {
        return new ArrayList<PlantEntry>(this.registry.values());
    }

    public void addDrops(ItemStack itemStack, PlantDrop[] drops) {
        String key = MapKeys.getKey(itemStack);
        if (this.contains(key)) {
            for (PlantDrop drop : drops) {
                this.registry.get(key).add(drop);
            }
        }
    }
}

