/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jeresources.api.drop.LootDrop;
import jeresources.util.ReflectionHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.HorseType;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootTableHelper {
    private static LootTableManager manager;

    public static List<LootPool> getPools(LootTable table) {
        return (List)ReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String[])new String[]{"pools", "field_186466_c"});
    }

    public static List<LootEntry> getEntries(LootPool pool) {
        return (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String[])new String[]{"lootEntries", "field_186453_a"});
    }

    public static List<LootCondition> getConditions(LootPool pool) {
        return (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String[])new String[]{"poolConditions", "field_186454_b"});
    }

    public static Item getItem(LootEntryItem lootEntry) {
        return (Item)ReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lootEntry, (String[])new String[]{"item", "field_186368_a"});
    }

    public static LootFunction[] getFunctions(LootEntryItem lootEntry) {
        return (LootFunction[])ReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lootEntry, (String[])new String[]{"functions", "field_186369_b"});
    }

    public static List<LootDrop> toDrops(LootTable table) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        LootTableHelper.getPools(table).forEach(pool -> {
            float totalWeight = LootTableHelper.getEntries(pool).stream().mapToInt(entry -> entry.func_186361_a(0.0f)).sum();
            List<LootCondition> poolConditions = LootTableHelper.getConditions(pool);
            LootTableHelper.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryItem).map(entry -> (LootEntryItem)entry).map(entry -> new LootDrop(LootTableHelper.getItem(entry), (float)entry.func_186361_a(0.0f) / totalWeight, entry.field_186366_e, LootTableHelper.getFunctions(entry))).map(drop -> drop.addLootConditions(poolConditions)).forEach(drops::add);
            LootTableHelper.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryTable).map(entry -> (LootEntryTable)entry).map(entry -> LootTableHelper.toDrops(manager.func_186521_a(entry.field_186371_a))).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static List<LootDrop> toDrops(World world, ResourceLocation lootTable) {
        return LootTableHelper.toDrops(LootTableHelper.getManager(world).func_186521_a(lootTable));
    }

    public static List<ResourceLocation> getAllChestLootTablesResourceLocations() {
        ArrayList<ResourceLocation> chestTables = new ArrayList<ResourceLocation>();
        chestTables.add(LootTableList.field_186421_c);
        chestTables.add(LootTableList.field_186422_d);
        chestTables.add(LootTableList.field_186423_e);
        chestTables.add(LootTableList.field_186424_f);
        chestTables.add(LootTableList.field_186425_g);
        chestTables.add(LootTableList.field_186426_h);
        chestTables.add(LootTableList.field_186427_i);
        chestTables.add(LootTableList.field_186428_j);
        chestTables.add(LootTableList.field_186429_k);
        chestTables.add(LootTableList.field_186430_l);
        chestTables.add(LootTableList.field_186431_m);
        return chestTables;
    }

    public static Map<ResourceLocation, EntityLivingBase> getAllMobLootTables(World world) {
        HashMap<ResourceLocation, EntityLivingBase> mobTables = new HashMap<ResourceLocation, EntityLivingBase>();
        mobTables.put(LootTableList.field_186432_n, (EntityLivingBase)new EntityWitch(world));
        mobTables.put(LootTableList.field_186433_o, (EntityLivingBase)new EntityBlaze(world));
        mobTables.put(LootTableList.field_186434_p, (EntityLivingBase)new EntityCreeper(world));
        mobTables.put(LootTableList.field_186435_q, (EntityLivingBase)new EntitySpider(world));
        mobTables.put(LootTableList.field_186436_r, (EntityLivingBase)new EntityCaveSpider(world));
        mobTables.put(LootTableList.field_186437_s, (EntityLivingBase)new EntityGiantZombie(world));
        mobTables.put(LootTableList.field_186438_t, (EntityLivingBase)new EntitySilverfish(world));
        mobTables.put(LootTableList.field_186439_u, (EntityLivingBase)new EntityEnderman(world));
        mobTables.put(LootTableList.field_186440_v, (EntityLivingBase)new EntityGuardian(world));
        EntityGuardian elder = new EntityGuardian(world);
        elder.func_175465_cm();
        mobTables.put(LootTableList.field_186441_w, (EntityLivingBase)elder);
        mobTables.put(LootTableList.field_186442_x, (EntityLivingBase)new EntityShulker(world));
        mobTables.put(LootTableList.field_186443_y, (EntityLivingBase)new EntityIronGolem(world));
        mobTables.put(LootTableList.field_186444_z, (EntityLivingBase)new EntitySnowman(world));
        mobTables.put(LootTableList.field_186393_A, (EntityLivingBase)new EntityRabbit(world));
        mobTables.put(LootTableList.field_186394_B, (EntityLivingBase)new EntityChicken(world));
        mobTables.put(LootTableList.field_186395_C, (EntityLivingBase)new EntityPig(world));
        mobTables.put(LootTableList.field_186396_D, (EntityLivingBase)new EntityHorse(world));
        mobTables.put(LootTableList.field_186397_E, (EntityLivingBase)new EntityHorse(world){
            {
                this.func_184778_a(HorseType.ZOMBIE);
            }
        });
        mobTables.put(LootTableList.field_186398_F, (EntityLivingBase)new EntityHorse(world){
            {
                this.func_184778_a(HorseType.SKELETON);
            }
        });
        mobTables.put(LootTableList.field_186399_G, (EntityLivingBase)new EntityCow(world));
        mobTables.put(LootTableList.field_186400_H, (EntityLivingBase)new EntityMooshroom(world));
        mobTables.put(LootTableList.field_186401_I, (EntityLivingBase)new EntityWolf(world));
        mobTables.put(LootTableList.field_186402_J, (EntityLivingBase)new EntityOcelot(world));
        EntitySheep whiteSheep = new EntitySheep(world);
        whiteSheep.func_175512_b(EnumDyeColor.WHITE);
        mobTables.put(LootTableList.field_186404_L, (EntityLivingBase)whiteSheep);
        EntitySheep orangeSheep = new EntitySheep(world);
        orangeSheep.func_175512_b(EnumDyeColor.ORANGE);
        mobTables.put(LootTableList.field_186405_M, (EntityLivingBase)orangeSheep);
        EntitySheep magentaSheep = new EntitySheep(world);
        magentaSheep.func_175512_b(EnumDyeColor.MAGENTA);
        mobTables.put(LootTableList.field_186406_N, (EntityLivingBase)magentaSheep);
        EntitySheep lightBlueSheep = new EntitySheep(world);
        lightBlueSheep.func_175512_b(EnumDyeColor.LIGHT_BLUE);
        mobTables.put(LootTableList.field_186407_O, (EntityLivingBase)lightBlueSheep);
        EntitySheep yellowSheep = new EntitySheep(world);
        yellowSheep.func_175512_b(EnumDyeColor.YELLOW);
        mobTables.put(LootTableList.field_186408_P, (EntityLivingBase)yellowSheep);
        EntitySheep limeSheep = new EntitySheep(world);
        limeSheep.func_175512_b(EnumDyeColor.LIME);
        mobTables.put(LootTableList.field_186409_Q, (EntityLivingBase)limeSheep);
        EntitySheep pinkSheep = new EntitySheep(world);
        pinkSheep.func_175512_b(EnumDyeColor.PINK);
        mobTables.put(LootTableList.field_186410_R, (EntityLivingBase)pinkSheep);
        EntitySheep graySheep = new EntitySheep(world);
        graySheep.func_175512_b(EnumDyeColor.GRAY);
        mobTables.put(LootTableList.field_186411_S, (EntityLivingBase)graySheep);
        EntitySheep silverSheep = new EntitySheep(world);
        silverSheep.func_175512_b(EnumDyeColor.SILVER);
        mobTables.put(LootTableList.field_186412_T, (EntityLivingBase)silverSheep);
        EntitySheep cyanSheep = new EntitySheep(world);
        cyanSheep.func_175512_b(EnumDyeColor.CYAN);
        mobTables.put(LootTableList.field_186413_U, (EntityLivingBase)cyanSheep);
        EntitySheep purpleSheep = new EntitySheep(world);
        purpleSheep.func_175512_b(EnumDyeColor.PURPLE);
        mobTables.put(LootTableList.field_186414_V, (EntityLivingBase)purpleSheep);
        EntitySheep blueSheep = new EntitySheep(world);
        blueSheep.func_175512_b(EnumDyeColor.BLUE);
        mobTables.put(LootTableList.field_186415_W, (EntityLivingBase)blueSheep);
        EntitySheep brownSheep = new EntitySheep(world);
        brownSheep.func_175512_b(EnumDyeColor.BROWN);
        mobTables.put(LootTableList.field_186416_X, (EntityLivingBase)brownSheep);
        EntitySheep greenSheep = new EntitySheep(world);
        greenSheep.func_175512_b(EnumDyeColor.GREEN);
        mobTables.put(LootTableList.field_186417_Y, (EntityLivingBase)greenSheep);
        EntitySheep redSheep = new EntitySheep(world);
        redSheep.func_175512_b(EnumDyeColor.RED);
        mobTables.put(LootTableList.field_186418_Z, (EntityLivingBase)redSheep);
        EntitySheep blackSheep = new EntitySheep(world);
        blackSheep.func_175512_b(EnumDyeColor.BLACK);
        mobTables.put(LootTableList.field_186376_aa, (EntityLivingBase)blackSheep);
        mobTables.put(LootTableList.field_186377_ab, (EntityLivingBase)new EntityBat(world));
        mobTables.put(LootTableList.field_186378_ac, (EntityLivingBase)new EntitySlime(world));
        mobTables.put(LootTableList.field_186379_ad, (EntityLivingBase)new EntityMagmaCube(world));
        mobTables.put(LootTableList.field_186380_ae, (EntityLivingBase)new EntityGhast(world));
        mobTables.put(LootTableList.field_186381_af, (EntityLivingBase)new EntitySquid(world));
        mobTables.put(LootTableList.field_186382_ag, (EntityLivingBase)new EntityEndermite(world));
        mobTables.put(LootTableList.field_186383_ah, (EntityLivingBase)new EntityZombie(world));
        mobTables.put(LootTableList.field_186384_ai, (EntityLivingBase)new EntityPigZombie(world));
        mobTables.put(LootTableList.field_186385_aj, (EntityLivingBase)new EntitySkeleton(world));
        EntitySkeleton wither = new EntitySkeleton(world);
        wither.func_189768_a(SkeletonType.WITHER);
        mobTables.put(LootTableList.field_186386_ak, (EntityLivingBase)wither);
        return mobTables;
    }

    public static LootTableManager getManager(World world) {
        if (world.func_184146_ak() == null) {
            if (manager == null) {
                manager = new LootTableManager(new File(new File(world.func_72860_G().func_75765_b(), "data"), "loot_tables"));
            }
            return manager;
        }
        return world.func_184146_ak();
    }
}

