# Быстрый старт

Также это руководство можно назвать "как сделать компьютер". Для запуска вашего первого [компьютера](computer.md) вам нужно его корректно собрать. В OpenComputers доступно большое количество компьютеров, но мы начнем с самого простого: обычного компьютера.

**Примечание**: это пошаговая инструкция, которая позволит вам понять базовые принципы мода. Если вы никогда не собирали компьютер в реальной жизни или вы совсем не знаете этот мод, мы рекомендуем вам прочитать эту страницу.

Сперва, вам понадобится [системный блок](../block/case1.md). Этот блок будет содержать все компоненты вашего компьютера и именно с него начинается создание компьютера.

![Системный блок уровня 2.](oredict:oc:case2)

Например, вам потребуется выбрать, [видеокарту](../item/graphicsCard1.md) какого уровня вы будете использовать, а может вам требуется [сетевая](../item/lanCard.md) или [редстоун](../item/redstoneCard1.md) карта или вы играете в креативе, тогда вам может понадобиться [отладочная карта](../item/debugCard.md).

Когда вы откроете интерфейс [системного блока](../block/case1.md) вы увидите несколько слотов. Количество слотов и уровень компонентов, которые могут быть установлены (показано римскими цифрами в слоте) зависит от уровня системного блока.
![Интерфейс системного блока уровня 2.](opencomputers:doc/img/configuration_case1.png)
Пустые [системные блоки](../block/case1.md) бесполезны. Вы можете попытаться включить [компьютер](computer.md), но вы получите только сообщение о ошибке в чат, а также звуковой сигнал. Сообщение о ошибке указывает, что компьютерам нужна энергия для работы. Подключите ваш [компьютер](computer.md) к источнику энергии, напрямую или через [конвертер энергии](../block/powerConverter.md).

При повторной попытке запуска, вы получите сообщение, о необходимости установки [процессора](../item/cpu1.md). Они бывают разных уровней, эта тенденция используется во всем OpenComputers. Чем выше уровень [процессора](../item/cpu1.md), тем больше компонентов он сможет использовать, а также, тем быстрее он работает. Выберите уровень и поместите процессор в [системный блок](../block/case1.md).

После чего вы должны вставить [планки памяти](../item/ram1.md). Звуковой сигнал будет другим: 1 длинный и 1 короткий. Чем выше уровень [планок памяти](../item/ram1.md), тем больше памяти доступно программам на вашем [компьютере](computer.md). Для запуска [OpenOS](openOS.md), требуется как минимум две [планки памяти](../item/ram1.md) уровня 1.

Так уже гораздо лучше. Теперь ваш [системный блок](../block/case1.md) выглядит примерно так:
![Частично собранный компьютер.](opencomputers:doc/img/configuration_case2.png)
И вот, попытка включения не выдает никаких сообщений! Но увы, он не запускается. При этом компьютер выдаст двойной звуковой сигнал. Это означает, что попытка запуска [компьютера](computer.md) не удалась. Другими словами: технически он работает! И тут нам на помощь приходит замечательный инструмент: [анализатор](../item/analyzer.md). Данный инструмент позволяет получать информацию о блоках OpenComputers, а также о некоторых блоках из другим модов. Для использования [анализатора](../item/analyzer.md) на [компьютере](computer.md) кликните по нему (с зажатой клавишей Shift).

Вы получите сообщение, почему [компьютер](computer.md) не запускается:
`no bios found; install configured EEPROM`

Самое главное здесь, это *настроенный*. Создать [EEPROM](../item/eeprom.md) очень просто. Для настройки, вы можете использовать [компьютер](computer.md), что немного сложно в данный момент, поэтому используйте его для крафта "Lua BIOS" [EEPROM](../item/eeprom.md). Обычно это [EEPROM](../item/eeprom.md) и [manual](../item/manual.md) расположенные рядом в верстаке. Поместите настроенный [EEPROM](../item/eeprom.md) в ваш [компьютер](computer.md) и.....

Ничего. Совсем ничего. Но мы умеем использовать [анализатор](../item/analyzer.md), это очень удобно! В результате получаем другое сообщение:
`no bootable medium found; file not found`

Ну что ж. BIOS работает и это хорошо. Но компьютер не может запустить операционную систему, тут нам потребуется [дискеты](../item/floppy.md) или [жесткий диск](../item/hdd1.md). Lua BIOS ожидает наличия в файловой системе файла `init.lua`, с которого начинается загрузка операционной системы. Вы, наверное догадались, что нам нужна дискета с операционной системой. Соедините пустую [дискету](../item/floppy.md) и [руководство](../item/manual.md) для создания дискеты с [OpenOS](openOS.md).

Даже, если использовать [системный блок](../block/case2.md) уровня 2 (как на скриншотах выше), вы не сможете вставить дискету. Если вы будете использовать [системный блок](../block/case3.md) уровня 3 или креативный, вы сможете легко вставить дискету в [системный блок](../block/case1.md). Значит, нам потребуется [дисковод](../block/diskDrive.md) рядом с системным блоком (или подключенный с помощью [кабеля](../block/cable.md)). Как только вставите дискету, вы знаете, что делать. Включите компьютер.

Он ожил! Ну или должен был. Если этого не произошло, значит что-то пошло не так и нам снова поможет [анализатор](../item/analyzer.md). Если предположить, что компьютер заработал, то вы проделали огромную работу. Самая сложная часть позади. Теперь осталось напечатать что-либо и вывести результат.

Чтобы [компьютер](computer.md) мог выводить информацию, вы должны установить [монитор](../block/screen1.md) и [видеокарту](../item/graphicsCard1.md).
![Нет, это не плоский экран.](oredict:oc:screen2)

Установите [монитор](../block/screen1.md) рядом с [системным блоком](../block/case1.md) или подключите его с помощью [кабеля](../block/cable.md). После чего установите [видеокарту](../item/graphicsCard1.md), которую вы выбрали в [системный блок](../block/case1.md). Вы должны увидеть мигающий курсор на [мониторе](../block/screen1.md). Теперь, установите [клавиатуру](../block/keyboard.md) перед [монитором](../block/screen1.md) или на одну из его сторон, чтобы получить возможность вводить текст с [клавиатуры](../block/keyboard.md).

На этом все. Теперь ваш [компьютер](computer.md) запущен, работает и ожидает команд. Попробуйте что-нибудь напечатать! Введите `lua` и нажмите Enter, после чего вы получите приветственное сообщение интерпретатора Lua. Здесь вы можете выполнять простые команды Lua. Для более подробной информации, прочтите страницу о [Lua](lua.md).

![Оно живое!](opencomputers:doc/img/configuration_done.png)

Получите удовольствие, от создания сложных [компьютеров](computer.md), совместно  [серверами](../item/server1.md) и сборкой [роботов](../block/robot.md), [дронов](../item/drone.md), [микроконтроллеров](../block/microcontroller.md) и [планшетов](../item/tablet.md) в [сборщике роботов](../block/assembler.md).

Хорошего кода вам!
