/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityCluster;
import vswe.stevesfactory.blocks.TileEntityClusterElement;

public abstract class BlockCableDirectionAdvanced
extends BlockContainer {
    public static final IProperty FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final IProperty ADVANCED = PropertyBool.func_177716_a((String)"advanced");

    public BlockCableDirectionAdvanced() {
        super(Material.field_151573_f);
        this.func_149647_a(ModBlocks.creativeTab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(1.2f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ADVANCED, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ADVANCED, (Comparable)Boolean.valueOf(this.isAdvanced(meta))).func_177226_a(FACING, (Comparable)this.getSide(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.addAdvancedMeta(((EnumFacing)state.func_177229_b(FACING)).func_176745_a(), (Boolean)state.func_177229_b(ADVANCED) != false ? 8 : 0);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack item) {
        int meta = this.addAdvancedMeta(BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)entity).func_176745_a(), item.func_77952_i());
        TileEntityClusterElement element = (TileEntityClusterElement)((Object)TileEntityCluster.getTileEntity(this.getTeClass(), (IBlockAccess)world, pos));
        if (element != null) {
            element.setMetaData(meta);
        }
    }

    protected abstract Class<? extends TileEntityClusterElement> getTeClass();

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    public boolean isAdvanced(int meta) {
        return (meta & 8) != 0;
    }

    public int getSideMeta(int meta) {
        return meta & 7;
    }

    public EnumFacing getSide(int meta) {
        return EnumFacing.func_82600_a((int)this.getSideMeta(meta));
    }

    private int addAdvancedMeta(int meta, int advancedMeta) {
        return meta | advancedMeta & 8;
    }

    private int getAdvancedMeta(int meta) {
        return this.addAdvancedMeta(0, meta);
    }

    public int func_180651_a(IBlockState state) {
        return this.getAdvancedMeta(state.func_177230_c().func_176201_c(state));
    }
}

