/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.blocks.BlockCableBreaker;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.IPacketBlock;
import vswe.stevesfactory.network.PacketHandler;

public class TileEntityBreaker
extends TileEntityClusterElement
implements IInventory,
IPacketBlock {
    private static final String FAKE_PLAYER_NAME = "[SFM_PLAYER]";
    private static final UUID FAKE_PLAYER_ID = null;
    private List<ItemStack> inventory;
    private List<ItemStack> inventoryCache;
    private boolean broken;
    private EnumFacing placeDirection;
    private boolean blocked;
    private static final int[] ROTATION_SIDE_MAPPING = new int[]{0, 0, 0, 2, 3, 1};
    private static final String NBT_DIRECTION = "Direction";
    private boolean missingPlaceDirection;
    private static final int UPDATE_BUFFER_DISTANCE = 5;
    private boolean hasUpdatedData;

    private List<ItemStack> getInventory() {
        if (this.inventory == null) {
            int z;
            int y;
            EnumFacing direction = EnumFacing.func_82600_a((int)(this.func_145832_p() % EnumFacing.values().length));
            int x = this.func_174877_v().func_177958_n() + direction.func_82601_c();
            BlockPos pos = new BlockPos(x, y = this.func_174877_v().func_177956_o() + direction.func_96559_d(), z = this.func_174877_v().func_177952_p() + direction.func_82599_e());
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (this.canBreakBlock(state, state.func_177230_c(), pos)) {
                this.inventory = state.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, pos, state, 0);
            }
            if (this.inventory == null) {
                this.inventory = new ArrayList<ItemStack>();
            }
            this.inventoryCache = new ArrayList<ItemStack>();
            for (ItemStack itemStack : this.inventory) {
                this.inventoryCache.add(itemStack.func_77946_l());
            }
        }
        return this.inventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ItemStack> placeItem(ItemStack itemstack) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (itemstack != null && itemstack.func_77973_b() != null && itemstack.field_77994_a > 0) {
            EnumFacing side = EnumFacing.func_82600_a((int)(this.func_145832_p() % EnumFacing.values().length));
            EnumFacing direction = this.placeDirection.func_176734_d();
            float hitX = 0.5f + (float)direction.func_82601_c() * 0.5f;
            float hitY = 0.5f + (float)direction.func_96559_d() * 0.5f;
            float hitZ = 0.5f + (float)direction.func_82599_e() * 0.5f;
            FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(FAKE_PLAYER_ID, FAKE_PLAYER_NAME));
            int rotationSide = ROTATION_SIDE_MAPPING[direction.ordinal()];
            player.field_70127_C = player.field_70177_z = (float)(rotationSide * 90);
            player.field_70125_A = direction == EnumFacing.UP ? 90.0f : (direction == EnumFacing.DOWN ? -90.0f : 0.0f);
            player.field_70126_B = player.field_70125_A;
            player.field_70169_q = player.field_70165_t = (double)(this.func_174877_v().func_177958_n() + side.func_82601_c()) + 0.5 + (double)direction.func_82601_c() * 0.4;
            player.field_70167_r = player.field_70163_u = (double)(this.func_174877_v().func_177956_o() + side.func_96559_d()) + 0.5 + (double)direction.func_96559_d() * 0.4;
            player.field_70166_s = player.field_70161_v = (double)(this.func_174877_v().func_177952_p() + side.func_82599_e()) + 0.5 + (double)direction.func_82599_e() * 0.4;
            player.eyeHeight = 0.0f;
            player.field_71134_c.setBlockReachDistance(1.0);
            this.blocked = true;
            try {
                player.field_71071_by.func_174888_l();
                player.field_71071_by.field_70461_c = 0;
                player.field_71071_by.func_70299_a(0, itemstack);
                ActionResult result = itemstack.func_77957_a(this.field_145850_b, (EntityPlayer)player, EnumHand.MAIN_HAND);
                if (result.func_188397_a().equals((Object)EnumActionResult.PASS) && ItemStack.func_77989_b((ItemStack)((ItemStack)result.func_188398_b()), (ItemStack)itemstack)) {
                    int x = this.func_174877_v().func_177958_n() + side.func_82601_c() - direction.func_82601_c();
                    int y = this.func_174877_v().func_177956_o() + side.func_96559_d() - direction.func_96559_d();
                    int z = this.func_174877_v().func_177952_p() + side.func_82599_e() - direction.func_82599_e();
                    player.field_71134_c.func_187251_a((EntityPlayer)player, this.field_145850_b, itemstack, EnumHand.MAIN_HAND, new BlockPos(x, y, z), direction, hitX, hitY, hitZ);
                } else {
                    player.field_71071_by.func_70299_a(0, (ItemStack)result.func_188398_b());
                }
            }
            catch (Exception exception) {
            }
            finally {
                for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                    if (itemStack == null || itemStack.field_77994_a <= 0) continue;
                    items.add(itemStack);
                }
                this.blocked = false;
            }
        }
        return items;
    }

    @Override
    public void func_73660_a() {
        if (this.missingPlaceDirection) {
            this.setPlaceDirection(EnumFacing.func_82600_a((int)this.func_145832_p()));
            this.missingPlaceDirection = false;
        }
        if (this.field_145850_b.field_72995_K) {
            this.keepClientDataUpdated();
        }
        if (this.inventory != null) {
            EnumFacing direction = EnumFacing.func_82600_a((int)(this.func_145832_p() % EnumFacing.values().length));
            for (ItemStack itemStack : this.getInventoryForDrop()) {
                List<ItemStack> items = this.placeItem(itemStack);
                if (items == null || items.isEmpty()) continue;
                for (ItemStack item : items) {
                    double x = (double)this.func_174877_v().func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.75;
                    double y = (double)this.func_174877_v().func_177956_o() + 0.5 + (double)direction.func_96559_d() * 0.75;
                    double z = (double)this.func_174877_v().func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.75;
                    if (direction.func_96559_d() == 0) {
                        y -= 0.1;
                    }
                    EntityItem entityitem = new EntityItem(this.field_145850_b, x, y, z, item);
                    entityitem.field_70159_w = (double)direction.func_82601_c() * 0.1;
                    entityitem.field_70181_x = (double)direction.func_96559_d() * 0.1;
                    entityitem.field_70179_y = (double)direction.func_82599_e() * 0.1;
                    entityitem.func_174867_a(40);
                    this.field_145850_b.func_72838_d((Entity)entityitem);
                }
            }
        }
        this.inventory = null;
        this.inventoryCache = null;
        this.broken = false;
    }

    private List<ItemStack> getInventoryForDrop() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.inventory) {
            if (itemStack == null) continue;
            ItemStack newStack = itemStack.func_77946_l();
            if (!this.broken) {
                for (int i = 0; i < this.inventoryCache.size(); ++i) {
                    ItemStack copyStack = this.inventoryCache.get(i);
                    if (copyStack == null || !newStack.func_77969_a(copyStack) || !ItemStack.func_77970_a((ItemStack)newStack, (ItemStack)copyStack)) continue;
                    int max = Math.min(copyStack.field_77994_a, newStack.field_77994_a);
                    copyStack.field_77994_a -= max;
                    if (copyStack.field_77994_a == 0) {
                        this.inventoryCache.set(0, null);
                    }
                    newStack.field_77994_a -= max;
                    if (newStack.field_77994_a != 0) continue;
                    newStack = null;
                    break;
                }
            }
            if (newStack == null) continue;
            ret.add(newStack);
        }
        return ret;
    }

    public int func_70302_i_() {
        return this.getInventory().size() + 1;
    }

    public ItemStack func_70301_a(int id) {
        if (id < this.getInventory().size()) {
            return this.getInventory().get(id);
        }
        return null;
    }

    public ItemStack func_70298_a(int id, int count) {
        ItemStack item = this.func_70301_a(id);
        if (item != null) {
            if (item.field_77994_a <= count) {
                this.getInventory().set(id, null);
                return item;
            }
            ItemStack ret = item.func_77979_a(count);
            if (item.field_77994_a == 0) {
                this.getInventory().set(id, null);
            }
            return ret;
        }
        return null;
    }

    public void func_70299_a(int id, ItemStack itemstack) {
        if (id < this.getInventory().size()) {
            this.getInventory().set(id, itemstack);
        } else {
            this.getInventory().add(itemstack);
            this.inventoryCache.add(null);
        }
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public String func_70005_c_() {
        return ModBlocks.blockCableBreaker.func_149732_F();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(ModBlocks.blockCableBreaker.func_149732_F());
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.inventory != null && !this.broken) {
            boolean match = true;
            for (int i = 0; i < this.inventory.size(); ++i) {
                ItemStack itemStack = this.inventory.get(i);
                ItemStack itemStackCopy = this.inventoryCache.get(i);
                if (itemStackCopy == null || itemStack != null && Item.func_150891_b((Item)itemStack.func_77973_b()) == Item.func_150891_b((Item)itemStackCopy.func_77973_b()) && itemStack.func_77952_i() == itemStackCopy.func_77952_i() && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemStackCopy) && itemStack.field_77994_a >= itemStackCopy.field_77994_a) continue;
                match = false;
                break;
            }
            if (!match) {
                Block block;
                int z;
                int y;
                EnumFacing direction = EnumFacing.func_82600_a((int)(this.func_145832_p() % EnumFacing.values().length));
                int x = this.func_174877_v().func_177958_n() + direction.func_82601_c();
                BlockPos pos = new BlockPos(x, y = this.func_174877_v().func_177956_o() + direction.func_96559_d(), z = this.func_174877_v().func_177952_p() + direction.func_82599_e());
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                if (this.canBreakBlock(state, block = state.func_177230_c(), pos)) {
                    this.broken = true;
                    int meta = state.func_177230_c().func_176201_c(state);
                    block.func_180663_b(this.field_145850_b, pos, state);
                    this.field_145850_b.func_175698_g(pos);
                }
            }
        }
    }

    private boolean canBreakBlock(IBlockState state, Block block, BlockPos pos) {
        return block != null && Block.func_149682_b((Block)block) != Block.func_149682_b((Block)Blocks.field_150357_h) && block.func_176195_g(state, this.field_145850_b, pos) >= 0.0f;
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.ON_BLOCK_PLACED_BY, ClusterMethodRegistration.ON_BLOCK_ACTIVATED);
    }

    @Override
    protected void readContentFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b(NBT_DIRECTION)) {
            this.setPlaceDirection(EnumFacing.func_82600_a((int)tagCompound.func_74771_c(NBT_DIRECTION)));
        } else if (this.field_145850_b != null) {
            this.setPlaceDirection(EnumFacing.func_82600_a((int)this.func_145832_p()));
        } else {
            this.missingPlaceDirection = true;
        }
    }

    @Override
    protected void writeContentToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74774_a(NBT_DIRECTION, (byte)(this.placeDirection != null ? this.placeDirection.func_176745_a() : 0));
    }

    @SideOnly(value=Side.CLIENT)
    private void keepClientDataUpdated() {
        if (this.isPartOfCluster()) {
            return;
        }
        double distance = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        if (distance > Math.pow(128.0, 2.0)) {
            this.hasUpdatedData = false;
        } else if (!this.hasUpdatedData && distance < Math.pow(123.0, 2.0)) {
            this.hasUpdatedData = true;
            PacketHandler.sendBlockPacket(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
        }
    }

    @Override
    public void writeData(DataWriter dw, EntityPlayer player, boolean onServer, int id) {
        if (onServer) {
            if (this.placeDirection == null) {
                this.placeDirection = BlockCableBreaker.getSide(this.func_145832_p());
            }
            dw.writeData(this.placeDirection.func_176745_a(), DataBitHelper.PLACE_DIRECTION);
        }
    }

    @Override
    public void readData(DataReader dr, EntityPlayer player, boolean onServer, int id) {
        if (onServer) {
            PacketHandler.sendBlockPacket(this, player, 0);
        } else {
            int val = dr.readData(DataBitHelper.PLACE_DIRECTION);
            this.setPlaceDirection(EnumFacing.func_82600_a((int)val));
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.func_70296_d();
        }
    }

    @Override
    public int infoBitLength(boolean onServer) {
        return 0;
    }

    public EnumFacing getPlaceDirection() {
        return this.placeDirection;
    }

    public void setPlaceDirection(EnumFacing placeDirection) {
        if (this.placeDirection != placeDirection) {
            this.placeDirection = placeDirection;
            this.func_70296_d();
            if (!this.isPartOfCluster() && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                PacketHandler.sendBlockPacket(this, null, 0);
            }
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }
}

