/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.ClusterRegistry;
import vswe.stevesfactory.blocks.ITileEntityInterface;
import vswe.stevesfactory.blocks.TileEntityCamouflage;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.IPacketBlock;
import vswe.stevesfactory.network.PacketHandler;

public class TileEntityCluster
extends TileEntity
implements ITileEntityInterface,
IPacketBlock,
ITickable {
    private boolean requestedInfo;
    private List<TileEntityClusterElement> elements = new ArrayList<TileEntityClusterElement>();
    private List<ClusterRegistry> registryList = new ArrayList<ClusterRegistry>();
    private Map<ClusterMethodRegistration, List<Pair>> methodRegistration = new HashMap<ClusterMethodRegistration, List<Pair>>();
    private ITileEntityInterface interfaceObject;
    private TileEntityCamouflage camouflageObject;
    private static final String NBT_SUB_BLOCKS = "SubBlocks";
    private static final String NBT_SUB_BLOCK_ID = "SubId";
    private static final String NBT_SUB_BLOCK_META = "SubMeta";

    public TileEntityCluster() {
        for (ClusterMethodRegistration clusterMethodRegistration : ClusterMethodRegistration.values()) {
            this.methodRegistration.put(clusterMethodRegistration, new ArrayList());
        }
    }

    public void loadElements(ItemStack itemStack) {
        NBTTagCompound compound = itemStack.func_77978_p();
        if (compound != null && compound.func_74764_b("Cable")) {
            NBTTagCompound cable = compound.func_74775_l("Cable");
            byte[] types = cable.func_74770_j("Types");
            this.loadElements(types);
        }
    }

    private void loadElements(byte[] types) {
        this.registryList.clear();
        this.elements.clear();
        for (byte type : types) {
            ClusterRegistry block = ClusterRegistry.getRegistryList().get(type);
            this.registryList.add(block);
            TileEntityClusterElement element = (TileEntityClusterElement)block.getBlock().func_149915_a(this.func_145831_w(), 0);
            this.elements.add(element);
            if (element instanceof ITileEntityInterface) {
                this.interfaceObject = (ITileEntityInterface)((Object)element);
            } else if (element instanceof TileEntityCamouflage) {
                this.camouflageObject = (TileEntityCamouflage)element;
            }
            for (ClusterMethodRegistration clusterMethodRegistration : element.getRegistrations()) {
                this.methodRegistration.get((Object)clusterMethodRegistration).add(new Pair(block, element));
            }
            element.func_174878_a(new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
            element.func_145834_a(this.field_145850_b);
            element.setPartOfCluster(true);
        }
    }

    public List<TileEntityClusterElement> getElements() {
        return this.elements;
    }

    public void func_73660_a() {
        for (TileEntityClusterElement element : this.elements) {
            this.setWorldObject(element);
            element.func_73660_a();
        }
        if (!this.requestedInfo && this.field_145850_b.field_72995_K) {
            this.requestedInfo = true;
            this.requestData();
        }
    }

    public void setWorldObject(TileEntityClusterElement te) {
        if (!te.func_145830_o()) {
            te.func_145834_a(this.field_145850_b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void requestData() {
        PacketHandler.sendBlockPacket(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 1);
    }

    private List<Pair> getRegistrations(ClusterMethodRegistration method) {
        return this.methodRegistration.get((Object)method);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.ON_BLOCK_PLACED_BY)) {
            this.setWorldObject(blockContainer.te);
            blockContainer.registry.getBlock().func_180633_a(world, pos, state, entity, blockContainer.registry.getItemStack());
        }
    }

    public void onNeighborBlockChange(IBlockAccess world, BlockPos pos, IBlockState state, Block block) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.ON_NEIGHBOR_BLOCK_CHANGED)) {
            this.setWorldObject(blockContainer.te);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.CAN_CONNECT_REDSTONE)) {
            this.setWorldObject(blockContainer.te);
            if (!blockContainer.registry.getBlock().canConnectRedstone(state, blockAccess, pos, side)) continue;
            return true;
        }
        return false;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.ON_BLOCK_ADDED)) {
            this.setWorldObject(blockContainer.te);
            blockContainer.registry.getBlock().func_176213_c(world, pos, state);
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.SHOULD_CHECK_WEAK_POWER)) {
            this.setWorldObject(blockContainer.te);
            if (!blockContainer.registry.getBlock().shouldCheckWeakPower(state, blockAccess, pos, side)) continue;
            return true;
        }
        return false;
    }

    public int isProvidingWeakPower(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        int max = 0;
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.IS_PROVIDING_WEAK_POWER)) {
            this.setWorldObject(blockContainer.te);
            max = Math.max(max, blockContainer.registry.getBlock().func_176211_b(state, blockAccess, pos, side));
        }
        return max;
    }

    public int isProvidingStrongPower(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        int max = 0;
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.IS_PROVIDING_STRONG_POWER)) {
            this.setWorldObject(blockContainer.te);
            max = Math.max(max, blockContainer.registry.getBlock().func_180656_a(state, blockAccess, pos, side));
        }
        return max;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.ON_BLOCK_ACTIVATED)) {
            this.setWorldObject(blockContainer.te);
            if (!blockContainer.registry.getBlock().func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getTileEntity(Class<? extends TileEntityClusterElement> clazz, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            if (clazz.isInstance(te)) {
                return (T)te;
            }
            if (te instanceof TileEntityCluster) {
                for (TileEntityClusterElement element : ((TileEntityCluster)te).getElements()) {
                    if (!clazz.isInstance((Object)element)) continue;
                    return (T)((Object)element);
                }
            }
        }
        return null;
    }

    @Override
    public Container getContainer(TileEntity te, InventoryPlayer inv) {
        return this.interfaceObject == null ? null : this.interfaceObject.getContainer((TileEntity)this.interfaceObject, inv);
    }

    @Override
    public GuiScreen getGui(TileEntity te, InventoryPlayer inv) {
        return this.interfaceObject == null ? null : this.interfaceObject.getGui((TileEntity)this.interfaceObject, inv);
    }

    @Override
    public void readAllData(DataReader dr, EntityPlayer player) {
        if (this.interfaceObject != null) {
            this.interfaceObject.readAllData(dr, player);
        }
    }

    @Override
    public void readUpdatedData(DataReader dr, EntityPlayer player) {
        if (this.interfaceObject != null) {
            this.interfaceObject.readUpdatedData(dr, player);
        }
    }

    @Override
    public void writeAllData(DataWriter dw) {
        if (this.interfaceObject != null) {
            this.interfaceObject.writeAllData(dw);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagList subList = new NBTTagList();
        for (int i = 0; i < this.elements.size(); ++i) {
            TileEntityClusterElement element = this.elements.get(i);
            ClusterRegistry registryElement = this.registryList.get(i);
            NBTTagCompound sub = new NBTTagCompound();
            sub.func_74774_a(NBT_SUB_BLOCK_ID, (byte)registryElement.getId());
            sub.func_74774_a(NBT_SUB_BLOCK_META, (byte)element.func_145832_p());
            element.writeContentToNBT(sub);
            subList.func_74742_a((NBTBase)sub);
        }
        compound.func_74782_a(NBT_SUB_BLOCKS, (NBTBase)subList);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        int i;
        super.func_145839_a(tagCompound);
        NBTTagList subList = tagCompound.func_150295_c(NBT_SUB_BLOCKS, 10);
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (int i2 = 0; i2 < subList.func_74745_c(); ++i2) {
            NBTTagCompound sub = subList.func_150305_b(i2);
            bytes.add(sub.func_74771_c(NBT_SUB_BLOCK_ID));
        }
        byte[] byteArr = new byte[bytes.size()];
        for (i = 0; i < bytes.size(); ++i) {
            byteArr[i] = (Byte)bytes.get(i);
        }
        this.loadElements(byteArr);
        for (i = 0; i < subList.func_74745_c(); ++i) {
            NBTTagCompound sub = subList.func_150305_b(i);
            TileEntityClusterElement element = this.elements.get(i);
            element.setMetaData(sub.func_74771_c(NBT_SUB_BLOCK_META));
            element.readContentFromNBT(sub);
        }
    }

    @Override
    public void writeData(DataWriter dw, EntityPlayer player, boolean onServer, int id) {
        if (id == 0) {
            if (this.camouflageObject != null) {
                this.camouflageObject.writeData(dw, player, onServer, id);
            }
        } else if (onServer) {
            int i;
            dw.writeData(this.elements.size(), DataBitHelper.CLUSTER_SUB_ID);
            for (i = 0; i < this.elements.size(); ++i) {
                dw.writeData((int)((byte)this.registryList.get(i).getId()), DataBitHelper.CLUSTER_SUB_ID);
            }
            for (i = 0; i < this.elements.size(); ++i) {
                dw.writeData((int)((byte)this.elements.get(i).func_145832_p()), DataBitHelper.BLOCK_META);
            }
        }
    }

    @Override
    public void readData(DataReader dr, EntityPlayer player, boolean onServer, int id) {
        if (id == 0) {
            if (this.camouflageObject != null) {
                this.camouflageObject.readData(dr, player, onServer, id);
            }
        } else if (onServer) {
            PacketHandler.sendBlockPacket(this, player, 1);
        } else {
            int i;
            int length = dr.readData(DataBitHelper.CLUSTER_SUB_ID);
            byte[] types = new byte[length];
            for (i = 0; i < length; ++i) {
                types[i] = (byte)dr.readData(DataBitHelper.CLUSTER_SUB_ID);
            }
            this.loadElements(types);
            for (i = 0; i < length; ++i) {
                this.elements.get(i).setMetaData(dr.readData(DataBitHelper.BLOCK_META));
            }
        }
    }

    @Override
    public int infoBitLength(boolean onServer) {
        return 1;
    }

    public byte[] getTypes() {
        byte[] bytes = new byte[this.registryList.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.registryList.get(i).getId();
        }
        return bytes;
    }

    private class Pair {
        private ClusterRegistry registry;
        private TileEntityClusterElement te;

        private Pair(ClusterRegistry registry, TileEntityClusterElement te) {
            this.registry = registry;
            this.te = te;
        }
    }
}

