/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks.client;

import com.google.common.base.Function;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.util.vector.Vector3f;
import vswe.stevesfactory.blocks.BlockCableOutput;
import vswe.stevesfactory.blocks.client.EmitterBlockModel;
import vswe.stevesfactory.blocks.client.SideQuad;

public class BakedEmitterBlockModel
implements IBakedModel {
    private VertexFormat format;
    private TextureAtlasSprite strongSprite;
    private TextureAtlasSprite weakSprite;
    private TextureAtlasSprite idleSprite;
    private BakedQuad[] strongQuads = new BakedQuad[EnumFacing.values().length];
    private BakedQuad[] weakQuads = new BakedQuad[EnumFacing.values().length];
    private BakedQuad[] idleQuads = new BakedQuad[EnumFacing.values().length];

    public BakedEmitterBlockModel(Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        FaceBakery faceBakery = new FaceBakery();
        BlockFaceUV bfUV = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        this.strongSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)EmitterBlockModel.STRONG);
        this.weakSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)EmitterBlockModel.WEAK);
        this.idleSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)EmitterBlockModel.IDLE);
        Vector3f v1 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f v2 = new Vector3f(16.0f, 16.0f, 16.0f);
        for (EnumFacing facing : EnumFacing.values()) {
            this.strongQuads[facing.func_176745_a()] = faceBakery.func_178414_a(v1, v2, new BlockPartFace(facing, -1, "stevesfactorymanager:blocks/cable_output_strong", bfUV), this.strongSprite, facing, ModelRotation.X0_Y0, null, false, true);
            this.weakQuads[facing.func_176745_a()] = faceBakery.func_178414_a(v1, v2, new BlockPartFace(facing, -1, "stevesfactorymanager:blocks/cable_weak_strong", bfUV), this.weakSprite, facing, ModelRotation.X0_Y0, null, false, true);
            this.idleQuads[facing.func_176745_a()] = faceBakery.func_178414_a(v1, v2, new BlockPartFace(facing, -1, "stevesfactorymanager:blocks/cable_idle", bfUV), this.idleSprite, facing, ModelRotation.X0_Y0, null, false, true);
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState blockState = (IExtendedBlockState)state;
            return new AssembledBakedModel(blockState).func_188616_a(state, side, rand);
        }
        return new AssembledBakedModel().func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.idleSprite;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public class AssembledBakedModel
    implements IBakedModel {
        private SideQuad[] sideQuads = new SideQuad[EnumFacing.values().length];

        public AssembledBakedModel(IExtendedBlockState blockState) {
            Object obj = blockState.getValue(BlockCableOutput.STRONG_SIDES);
            if (obj != null) {
                int strongVals = (Integer)blockState.getValue(BlockCableOutput.STRONG_SIDES);
                int weakVals = (Integer)blockState.getValue(BlockCableOutput.WEAK_SIDES);
                for (EnumFacing facing : EnumFacing.values()) {
                    this.sideQuads[facing.func_176745_a()] = (strongVals & 1 << facing.func_176745_a()) >> facing.func_176745_a() == 1 ? SideQuad.STRONG : ((weakVals & 1 << facing.func_176745_a()) >> facing.func_176745_a() == 1 ? SideQuad.WEAK : SideQuad.IDLE);
                }
            } else {
                for (int i = 0; i < 6; ++i) {
                    this.sideQuads[i] = SideQuad.IDLE;
                }
            }
        }

        public AssembledBakedModel() {
            for (int i = 0; i < 6; ++i) {
                this.sideQuads[i] = SideQuad.IDLE;
            }
        }

        private BakedQuad getQuadFromSide(SideQuad sideQuad, EnumFacing facing) {
            switch (sideQuad) {
                case STRONG: {
                    return BakedEmitterBlockModel.this.strongQuads[facing.func_176745_a()];
                }
                case WEAK: {
                    return BakedEmitterBlockModel.this.weakQuads[facing.func_176745_a()];
                }
            }
            return BakedEmitterBlockModel.this.idleQuads[facing.func_176745_a()];
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            LinkedList<BakedQuad> allFaceQuads = new LinkedList<BakedQuad>();
            if (side != null) {
                allFaceQuads.add(this.getQuadFromSide(this.sideQuads[side.func_176745_a()], side));
            } else {
                for (EnumFacing facing : EnumFacing.values()) {
                    allFaceQuads.add(this.getQuadFromSide(this.sideQuads[facing.func_176745_a()], facing));
                }
            }
            return allFaceQuads;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return BakedEmitterBlockModel.this.idleSprite;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

