/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import vswe.stevesfactory.blocks.ConnectionBlock;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.blocks.TileEntityCreative;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuCamouflageInside;
import vswe.stevesfactory.components.ComponentMenuCamouflageItems;
import vswe.stevesfactory.components.ComponentMenuCamouflageShape;
import vswe.stevesfactory.components.ComponentMenuCamouflageSides;
import vswe.stevesfactory.components.ComponentMenuContainer;
import vswe.stevesfactory.components.ComponentMenuContainerScrap;
import vswe.stevesfactory.components.ComponentMenuContainerTypes;
import vswe.stevesfactory.components.ComponentMenuCrafting;
import vswe.stevesfactory.components.ComponentMenuCraftingPriority;
import vswe.stevesfactory.components.ComponentMenuListOrder;
import vswe.stevesfactory.components.ComponentMenuPulse;
import vswe.stevesfactory.components.ComponentMenuRedstoneOutput;
import vswe.stevesfactory.components.ComponentMenuRedstoneSidesEmitter;
import vswe.stevesfactory.components.ComponentMenuSignText;
import vswe.stevesfactory.components.ComponentMenuSplit;
import vswe.stevesfactory.components.ComponentMenuStuff;
import vswe.stevesfactory.components.ComponentMenuTarget;
import vswe.stevesfactory.components.ComponentMenuTargetInventory;
import vswe.stevesfactory.components.ComponentMenuTargetTank;
import vswe.stevesfactory.components.ComponentMenuVariable;
import vswe.stevesfactory.components.ComponentMenuVariableLoop;
import vswe.stevesfactory.components.ConditionSettingChecker;
import vswe.stevesfactory.components.Connection;
import vswe.stevesfactory.components.ConnectionOption;
import vswe.stevesfactory.components.CraftingBufferElement;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.FluidBufferElement;
import vswe.stevesfactory.components.FluidSetting;
import vswe.stevesfactory.components.IConditionStuffMenu;
import vswe.stevesfactory.components.IItemBufferElement;
import vswe.stevesfactory.components.IItemBufferSubElement;
import vswe.stevesfactory.components.ItemBufferElement;
import vswe.stevesfactory.components.ItemSetting;
import vswe.stevesfactory.components.OutputFluidCounter;
import vswe.stevesfactory.components.OutputItemCounter;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.SlotInventoryHolder;
import vswe.stevesfactory.components.SlotSideTarget;
import vswe.stevesfactory.components.SlotStackInventoryHolder;
import vswe.stevesfactory.components.StackTankHolder;
import vswe.stevesfactory.components.Variable;
import vswe.stevesfactory.components.VariableColor;

public class CommandExecutor {
    private TileEntityManager manager;
    List<ItemBufferElement> itemBuffer;
    List<CraftingBufferElement> craftingBufferHigh;
    List<CraftingBufferElement> craftingBufferLow;
    List<FluidBufferElement> fluidBuffer;
    private List<Integer> usedCommands;
    public static final int MAX_FLUID_TRANSFER = 10000000;

    public CommandExecutor(TileEntityManager manager) {
        this.manager = manager;
        this.itemBuffer = new ArrayList<ItemBufferElement>();
        this.craftingBufferHigh = new ArrayList<CraftingBufferElement>();
        this.craftingBufferLow = new ArrayList<CraftingBufferElement>();
        this.fluidBuffer = new ArrayList<FluidBufferElement>();
        this.usedCommands = new ArrayList<Integer>();
    }

    private CommandExecutor(TileEntityManager manager, List<ItemBufferElement> itemBufferSplit, List<CraftingBufferElement> craftingBufferHighSplit, List<CraftingBufferElement> craftingBufferLowSplit, List<FluidBufferElement> fluidBufferSplit, List<Integer> usedCommandCopy) {
        this.manager = manager;
        this.itemBuffer = itemBufferSplit;
        this.craftingBufferHigh = craftingBufferHighSplit;
        this.craftingBufferLow = craftingBufferLowSplit;
        this.usedCommands = usedCommandCopy;
        this.fluidBuffer = fluidBufferSplit;
    }

    public void executeTriggerCommand(FlowComponent command, EnumSet<ConnectionOption> validTriggerOutputs) {
        for (Variable variable : this.manager.getVariables()) {
            if (!variable.isValid() || variable.hasBeenExecuted() && ((ComponentMenuVariable)variable.getDeclaration().getMenus().get(0)).getVariableMode() != ComponentMenuVariable.VariableMode.LOCAL) continue;
            this.executeCommand(variable.getDeclaration(), 0);
            variable.setExecuted(true);
        }
        this.executeChildCommands(command, validTriggerOutputs);
    }

    private void executeChildCommands(FlowComponent command, EnumSet<ConnectionOption> validTriggerOutputs) {
        for (int i = 0; i < command.getConnectionSet().getConnections().length; ++i) {
            Connection connection = command.getConnection(i);
            ConnectionOption option = command.getConnectionSet().getConnections()[i];
            if (connection == null || option.isInput() || !validTriggerOutputs.contains((Object)option)) continue;
            this.executeCommand(this.manager.getFlowItems().get(connection.getComponentId()), connection.getConnectionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(FlowComponent command, int connectionId) {
        if (this.usedCommands.contains(command.getId())) {
            return;
        }
        try {
            this.usedCommands.add(command.getId());
            switch (command.getType()) {
                case INPUT: {
                    List<SlotInventoryHolder> inputInventory = this.getInventories(command.getMenus().get(0));
                    if (inputInventory == null) break;
                    this.getValidSlots(command.getMenus().get(1), inputInventory);
                    this.getItems(command.getMenus().get(2), inputInventory);
                    break;
                }
                case OUTPUT: {
                    List<SlotInventoryHolder> outputInventory = this.getInventories(command.getMenus().get(0));
                    if (outputInventory == null) break;
                    this.getValidSlots(command.getMenus().get(1), outputInventory);
                    this.insertItems(command.getMenus().get(2), outputInventory);
                    break;
                }
                case CONDITION: {
                    List<SlotInventoryHolder> conditionInventory = this.getInventories(command.getMenus().get(0));
                    if (conditionInventory != null) {
                        this.getValidSlots(command.getMenus().get(1), conditionInventory);
                        if (this.searchForStuff(command.getMenus().get(2), conditionInventory, false)) {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                        } else {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                        }
                    }
                    return;
                }
                case FLUID_INPUT: {
                    List<SlotInventoryHolder> inputTank = this.getTanks(command.getMenus().get(0));
                    if (inputTank == null) break;
                    this.getValidTanks(command.getMenus().get(1), inputTank);
                    this.getFluids(command.getMenus().get(2), inputTank);
                    break;
                }
                case FLUID_OUTPUT: {
                    List<SlotInventoryHolder> outputTank = this.getTanks(command.getMenus().get(0));
                    if (outputTank == null) break;
                    this.getValidTanks(command.getMenus().get(1), outputTank);
                    this.insertFluids(command.getMenus().get(2), outputTank);
                    break;
                }
                case FLUID_CONDITION: {
                    List<SlotInventoryHolder> conditionTank = this.getTanks(command.getMenus().get(0));
                    if (conditionTank != null) {
                        this.getValidTanks(command.getMenus().get(1), conditionTank);
                        if (this.searchForStuff(command.getMenus().get(2), conditionTank, true)) {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                        } else {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                        }
                    }
                    return;
                }
                case FLOW_CONTROL: {
                    if (!ComponentMenuSplit.isSplitConnection(command) || !this.splitFlow(command.getMenus().get(0))) break;
                    return;
                }
                case REDSTONE_EMITTER: {
                    List<SlotInventoryHolder> emitters = this.getEmitters(command.getMenus().get(0));
                    if (emitters == null) break;
                    for (SlotInventoryHolder emitter : emitters) {
                        emitter.getEmitter().updateState((ComponentMenuRedstoneSidesEmitter)command.getMenus().get(1), (ComponentMenuRedstoneOutput)command.getMenus().get(2), (ComponentMenuPulse)command.getMenus().get(3));
                    }
                    break;
                }
                case REDSTONE_CONDITION: {
                    List<SlotInventoryHolder> nodes = this.getNodes(command.getMenus().get(0));
                    if (nodes != null) {
                        if (this.evaluateRedstoneCondition(nodes, command)) {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                        } else {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                        }
                    }
                    return;
                }
                case VARIABLE: {
                    List<SlotInventoryHolder> tiles = this.getTiles(command.getMenus().get(2));
                    if (tiles == null) break;
                    this.updateVariable(tiles, (ComponentMenuVariable)command.getMenus().get(0), (ComponentMenuListOrder)command.getMenus().get(3));
                    break;
                }
                case FOR_EACH: {
                    this.updateForLoop(command, (ComponentMenuVariableLoop)command.getMenus().get(0), (ComponentMenuContainerTypes)command.getMenus().get(1), (ComponentMenuListOrder)command.getMenus().get(2));
                    this.executeChildCommands(command, EnumSet.of(ConnectionOption.STANDARD_OUTPUT));
                    return;
                }
                case AUTO_CRAFTING: {
                    CraftingBufferElement element = new CraftingBufferElement(this, (ComponentMenuCrafting)command.getMenus().get(0), (ComponentMenuContainerScrap)command.getMenus().get(2));
                    if (((ComponentMenuCraftingPriority)command.getMenus().get(1)).shouldPrioritizeCrafting()) {
                        this.craftingBufferHigh.add(element);
                        break;
                    }
                    this.craftingBufferLow.add(element);
                    break;
                }
                case GROUP: {
                    if (connectionId < command.getChildrenInputNodes().size()) {
                        this.executeChildCommands(command.getChildrenInputNodes().get(connectionId), EnumSet.allOf(ConnectionOption.class));
                    }
                    return;
                }
                case NODE: {
                    FlowComponent parent = command.getParent();
                    if (parent != null) {
                        for (int i = 0; i < parent.getChildrenOutputNodes().size(); ++i) {
                            if (!command.equals(parent.getChildrenOutputNodes().get(i))) continue;
                            Connection connection = parent.getConnection(parent.getConnectionSet().getInputCount() + i);
                            if (connection == null) break;
                            this.executeCommand(this.manager.getFlowItems().get(connection.getComponentId()), connection.getConnectionId());
                            break;
                        }
                    }
                    return;
                }
                case CAMOUFLAGE: {
                    List<SlotInventoryHolder> camouflage = this.getCamouflage(command.getMenus().get(0));
                    if (camouflage == null) break;
                    ComponentMenuCamouflageShape shape = (ComponentMenuCamouflageShape)command.getMenus().get(1);
                    ComponentMenuCamouflageInside inside = (ComponentMenuCamouflageInside)command.getMenus().get(2);
                    ComponentMenuCamouflageSides sides = (ComponentMenuCamouflageSides)command.getMenus().get(3);
                    ComponentMenuCamouflageItems items = (ComponentMenuCamouflageItems)command.getMenus().get(4);
                    if (!items.isFirstRadioButtonSelected() && !items.getSettings().get(0).isValid()) break;
                    ItemStack itemStack = items.isFirstRadioButtonSelected() ? null : ((ItemSetting)items.getSettings().get(0)).getItem();
                    for (SlotInventoryHolder slotInventoryHolder : camouflage) {
                        slotInventoryHolder.getCamouflage().setBounds(shape);
                        for (int i = 0; i < EnumFacing.values().length; ++i) {
                            if (!sides.isSideRequired(i)) continue;
                            slotInventoryHolder.getCamouflage().setItem(itemStack, i, inside.getCurrentType());
                        }
                    }
                    break;
                }
                case SIGN: {
                    List<SlotInventoryHolder> sign = this.getSign(command.getMenus().get(0));
                    if (sign == null) break;
                    for (SlotInventoryHolder slotInventoryHolder : sign) {
                        slotInventoryHolder.getSign().updateSign((ComponentMenuSignText)command.getMenus().get(1));
                    }
                    break;
                }
            }
            this.executeChildCommands(command, EnumSet.allOf(ConnectionOption.class));
        }
        finally {
            this.usedCommands.remove((Object)command.getId());
        }
    }

    private List<SlotInventoryHolder> getEmitters(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.EMITTER);
    }

    private List<SlotInventoryHolder> getInventories(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.INVENTORY);
    }

    private List<SlotInventoryHolder> getTanks(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.TANK);
    }

    private List<SlotInventoryHolder> getNodes(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.NODE);
    }

    private List<SlotInventoryHolder> getCamouflage(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.CAMOUFLAGE);
    }

    private List<SlotInventoryHolder> getSign(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.SIGN);
    }

    private List<SlotInventoryHolder> getTiles(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, null);
    }

    public static List<SlotInventoryHolder> getContainers(TileEntityManager manager, ComponentMenu componentMenu, ConnectionBlockType type) {
        int i;
        ComponentMenuContainer menuContainer = (ComponentMenuContainer)componentMenu;
        if (menuContainer.getSelectedInventories().size() == 0) {
            return null;
        }
        ArrayList<SlotInventoryHolder> ret = new ArrayList<SlotInventoryHolder>();
        List<ConnectionBlock> inventories = manager.getConnectedInventories();
        Variable[] variables = manager.getVariables();
        for (i = 0; i < variables.length; ++i) {
            Variable variable = variables[i];
            if (!variable.isValid()) continue;
            for (int val : menuContainer.getSelectedInventories()) {
                if (val != i) continue;
                List<Integer> selection = variable.getContainers();
                for (int selected : selection) {
                    CommandExecutor.addContainer(inventories, ret, selected, menuContainer, type, ((ComponentMenuContainerTypes)variable.getDeclaration().getMenus().get(1)).getValidTypes());
                }
            }
        }
        for (i = 0; i < menuContainer.getSelectedInventories().size(); ++i) {
            int selected = menuContainer.getSelectedInventories().get(i) - VariableColor.values().length;
            CommandExecutor.addContainer(inventories, ret, selected, menuContainer, type, EnumSet.allOf(ConnectionBlockType.class));
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    private static void addContainer(List<ConnectionBlock> inventories, List<SlotInventoryHolder> ret, int selected, ComponentMenuContainer menuContainer, ConnectionBlockType requestType, EnumSet<ConnectionBlockType> variableType) {
        ConnectionBlock connection;
        if (selected >= 0 && selected < inventories.size() && (connection = inventories.get(selected)).isOfType(requestType) && connection.isOfAnyType(variableType) && !connection.getTileEntity().func_145837_r() && !CommandExecutor.containsTe(ret, connection.getTileEntity())) {
            ret.add(new SlotInventoryHolder(selected, connection.getTileEntity(), menuContainer.getOption()));
        }
    }

    private static boolean containsTe(List<SlotInventoryHolder> lst, TileEntity te) {
        for (SlotInventoryHolder slotInventoryHolder : lst) {
            if (slotInventoryHolder.getTile().func_174877_v().func_177958_n() != te.func_174877_v().func_177958_n() || slotInventoryHolder.getTile().func_174877_v().func_177956_o() != te.func_174877_v().func_177956_o() || slotInventoryHolder.getTile().func_174877_v().func_177952_p() != te.func_174877_v().func_177952_p() || !slotInventoryHolder.getTile().getClass().equals(te.getClass())) continue;
            return true;
        }
        return false;
    }

    private void getValidSlots(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories) {
        ComponentMenuTargetInventory menuTarget = (ComponentMenuTargetInventory)componentMenu;
        for (int i = 0; i < inventories.size(); ++i) {
            IInventory inventory = inventories.get(i).getInventory();
            Map<Integer, SlotSideTarget> validSlots = inventories.get(i).getValidSlots();
            for (int side = 0; side < ComponentMenuTarget.directions.length; ++side) {
                int end;
                int start;
                int[] inventoryValidSlots;
                if (!menuTarget.isActive(side)) continue;
                if (inventory instanceof ISidedInventory) {
                    inventoryValidSlots = ((ISidedInventory)inventory).func_180463_a(EnumFacing.func_82600_a((int)side));
                } else {
                    inventoryValidSlots = new int[inventory.func_70302_i_()];
                    for (int j = 0; j < inventoryValidSlots.length; ++j) {
                        inventoryValidSlots[j] = j;
                    }
                }
                if (menuTarget.useAdvancedSetting(side)) {
                    start = menuTarget.getStart(side);
                    end = menuTarget.getEnd(side);
                } else {
                    start = 0;
                    end = inventory.func_70302_i_();
                }
                if (start > end) continue;
                for (int inventoryValidSlot : inventoryValidSlots) {
                    if (inventoryValidSlot < start || inventoryValidSlot > end) continue;
                    SlotSideTarget target = validSlots.get(inventoryValidSlot);
                    if (target == null) {
                        validSlots.put(inventoryValidSlot, new SlotSideTarget(inventoryValidSlot, side));
                        continue;
                    }
                    target.addSide(side);
                }
            }
        }
    }

    private void getValidTanks(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        ComponentMenuTargetTank menuTarget = (ComponentMenuTargetTank)componentMenu;
        for (int i = 0; i < tanks.size(); ++i) {
            IFluidHandler tank = tanks.get(i).getTank();
            Map<Integer, SlotSideTarget> validTanks = tanks.get(i).getValidSlots();
            for (int side = 0; side < ComponentMenuTarget.directions.length; ++side) {
                SlotSideTarget target;
                if (!menuTarget.isActive(side)) continue;
                if (menuTarget.useAdvancedSetting(side)) {
                    boolean empty = true;
                    for (FluidTankInfo fluidTankInfo : tank.getTankInfo(ComponentMenuTarget.directions[side])) {
                        if (fluidTankInfo.fluid == null || fluidTankInfo.fluid.amount <= 0) continue;
                        empty = false;
                        break;
                    }
                    if (empty != menuTarget.requireEmpty(side)) continue;
                }
                if ((target = validTanks.get(0)) == null) {
                    validTanks.put(0, new SlotSideTarget(0, side));
                    continue;
                }
                target.addSide(side);
            }
        }
    }

    private boolean isSlotValid(IInventory inventory, ItemStack item, SlotSideTarget slot, boolean isInput) {
        if (item == null) {
            return false;
        }
        if (inventory instanceof ISidedInventory) {
            boolean hasValidSide = false;
            for (int side : slot.getSides()) {
                if (isInput && ((ISidedInventory)inventory).func_180461_b(slot.getSlot(), item, EnumFacing.func_82600_a((int)side))) {
                    hasValidSide = true;
                    break;
                }
                if (isInput || !((ISidedInventory)inventory).func_180462_a(slot.getSlot(), item, EnumFacing.func_82600_a((int)side))) continue;
                hasValidSide = true;
                break;
            }
            if (!hasValidSide) {
                return false;
            }
        }
        return isInput || inventory.func_94041_b(slot.getSlot(), item);
    }

    private void getItems(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories) {
        for (SlotInventoryHolder inventory : inventories) {
            ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
            if (inventory.getInventory() instanceof TileEntityCreative) {
                if (!menuItem.useWhiteList()) continue;
                for (SlotSideTarget slot : inventory.getValidSlots().values()) {
                    for (Setting setting : menuItem.getSettings()) {
                        ItemStack item = ((ItemSetting)setting).getItem();
                        if (item == null) continue;
                        item = item.func_77946_l();
                        item.field_77994_a = setting.isLimitedByAmount() ? setting.getAmount() : setting.getDefaultAmount();
                        this.addItemToBuffer(menuItem, inventory, setting, item, slot);
                    }
                }
                continue;
            }
            for (SlotSideTarget slot : inventory.getValidSlots().values()) {
                Setting setting;
                ItemStack itemStack = inventory.getInventory().func_70301_a(slot.getSlot());
                if (!this.isSlotValid(inventory.getInventory(), itemStack, slot, true)) continue;
                setting = this.isItemValid(componentMenu, itemStack);
                this.addItemToBuffer(menuItem, inventory, setting, itemStack, slot);
            }
        }
    }

    private void addItemToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder inventory, Setting setting, ItemStack itemStack, SlotSideTarget slot) {
        if (menuItem.useWhiteList() == (setting != null) || setting != null && setting.isLimitedByAmount()) {
            FlowComponent owner = menuItem.getParent();
            SlotStackInventoryHolder target = new SlotStackInventoryHolder(itemStack, inventory.getInventory(), slot.getSlot());
            boolean added = false;
            for (ItemBufferElement itemBufferElement : this.itemBuffer) {
                if (!itemBufferElement.addTarget(owner, setting, inventory, target)) continue;
                added = true;
                break;
            }
            if (!added) {
                ItemBufferElement itemBufferElement = new ItemBufferElement(owner, setting, inventory, menuItem.useWhiteList(), target);
                this.itemBuffer.add(itemBufferElement);
            }
        }
    }

    private void getFluids(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        for (SlotInventoryHolder tank : tanks) {
            ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
            if (tank.getTank() instanceof TileEntityCreative) {
                if (!menuItem.useWhiteList()) continue;
                for (SlotSideTarget slot : tank.getValidSlots().values()) {
                    for (Setting setting : menuItem.getSettings()) {
                        FluidStack fluidStack;
                        Fluid fluid = ((FluidSetting)setting).getFluid();
                        if (fluid == null || (fluidStack = new FluidStack(fluid, setting.isLimitedByAmount() ? setting.getAmount() : setting.getDefaultAmount())) == null) continue;
                        this.addFluidToBuffer(menuItem, tank, setting, fluidStack, 0);
                    }
                }
                continue;
            }
            for (SlotSideTarget slot : tank.getValidSlots().values()) {
                ArrayList<FluidTankInfo> tankInfos = new ArrayList<FluidTankInfo>();
                for (int side : slot.getSides()) {
                    FluidTankInfo[] currentTankInfos = tank.getTank().getTankInfo(EnumFacing.func_82600_a((int)side));
                    if (currentTankInfos == null) continue;
                    for (FluidTankInfo fluidTankInfo : currentTankInfos) {
                        FluidStack fluidStack;
                        if (fluidTankInfo == null) continue;
                        boolean alreadyUsed = false;
                        for (FluidTankInfo tankInfo : tankInfos) {
                            if (!FluidStack.areFluidStackTagsEqual((FluidStack)tankInfo.fluid, (FluidStack)fluidTankInfo.fluid) || tankInfo.capacity != fluidTankInfo.capacity) continue;
                            alreadyUsed = true;
                        }
                        if (alreadyUsed || (fluidStack = fluidTankInfo.fluid) == null) continue;
                        fluidStack = fluidStack.copy();
                        Setting setting = this.isFluidValid(componentMenu, fluidStack);
                        this.addFluidToBuffer(menuItem, tank, setting, fluidStack, side);
                    }
                    for (FluidTankInfo fluidTankInfo : tank.getTank().getTankInfo(EnumFacing.func_82600_a((int)side))) {
                        if (fluidTankInfo == null) continue;
                        tankInfos.add(fluidTankInfo);
                    }
                }
            }
        }
    }

    private void addFluidToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder tank, Setting setting, FluidStack fluidStack, int side) {
        if (menuItem.useWhiteList() == (setting != null) || setting != null && setting.isLimitedByAmount()) {
            FlowComponent owner = menuItem.getParent();
            StackTankHolder target = new StackTankHolder(fluidStack, tank.getTank(), EnumFacing.func_82600_a((int)side));
            boolean added = false;
            for (FluidBufferElement fluidBufferElement : this.fluidBuffer) {
                if (!fluidBufferElement.addTarget(owner, setting, tank, target)) continue;
                added = true;
                break;
            }
            if (!added) {
                FluidBufferElement itemBufferElement = new FluidBufferElement(owner, setting, tank, menuItem.useWhiteList(), target);
                this.fluidBuffer.add(itemBufferElement);
            }
        }
    }

    private Setting isItemValid(ComponentMenu componentMenu, ItemStack itemStack) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        for (Setting setting : menuItem.getSettings()) {
            if (!((ItemSetting)setting).isEqualForCommandExecutor(itemStack)) continue;
            return setting;
        }
        return null;
    }

    private Setting isFluidValid(ComponentMenu componentMenu, FluidStack fluidStack) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        if (fluidStack != null) {
            String fluidName = fluidStack.getFluid().getName();
            for (Setting setting : menuItem.getSettings()) {
                if (!setting.isValid() || !((FluidSetting)setting).getFluidName().equals(fluidName)) continue;
                return setting;
            }
        }
        return null;
    }

    private void insertItems(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        ArrayList<OutputItemCounter> outputCounters = new ArrayList<OutputItemCounter>();
        for (SlotInventoryHolder inventoryHolder : inventories) {
            if (!inventoryHolder.isShared()) {
                outputCounters.clear();
            }
            for (CraftingBufferElement craftingBufferElement : this.craftingBufferHigh) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, craftingBufferElement);
            }
            for (ItemBufferElement itemBufferElement : this.itemBuffer) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, itemBufferElement);
            }
            for (CraftingBufferElement craftingBufferElement : this.craftingBufferLow) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, craftingBufferElement);
            }
        }
    }

    private void insertItemsFromInputBufferElement(ComponentMenuStuff menuItem, List<SlotInventoryHolder> inventories, List<OutputItemCounter> outputCounters, SlotInventoryHolder inventoryHolder, IItemBufferElement itemBufferElement) {
        IItemBufferSubElement subElement;
        IInventory inventory = inventoryHolder.getInventory();
        itemBufferElement.prepareSubElements();
        block0: while ((subElement = itemBufferElement.getSubElement()) != null) {
            ItemStack itemStack = subElement.getItemStack();
            Setting setting = this.isItemValid(menuItem, itemStack);
            if (menuItem.useWhiteList() == (setting == null) && (setting == null || !setting.isLimitedByAmount())) continue;
            OutputItemCounter outputItemCounter = null;
            for (OutputItemCounter e : outputCounters) {
                if (!e.areSettingsSame(setting)) continue;
                outputItemCounter = e;
                break;
            }
            if (outputItemCounter == null) {
                outputItemCounter = new OutputItemCounter(this.itemBuffer, inventories, inventory, setting, menuItem.useWhiteList());
                outputCounters.add(outputItemCounter);
            }
            for (SlotSideTarget slot : inventoryHolder.getValidSlots().values()) {
                boolean newItem;
                if (!this.isSlotValid(inventory, itemStack, slot, false)) continue;
                ItemStack itemInSlot = inventory.func_70301_a(slot.getSlot());
                boolean bl = newItem = itemInSlot == null;
                if (!newItem && (!itemInSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemInSlot) || !itemStack.func_77985_e())) continue;
                int itemCountInSlot = newItem ? 0 : itemInSlot.field_77994_a;
                int moveCount = Math.min(subElement.getSizeLeft(), Math.min(inventory.func_70297_j_(), itemStack.func_77976_d()) - itemCountInSlot);
                moveCount = outputItemCounter.retrieveItemCount(moveCount);
                if ((moveCount = itemBufferElement.retrieveItemCount(moveCount)) <= 0) continue;
                if (newItem) {
                    itemInSlot = itemStack.func_77946_l();
                    itemInSlot.field_77994_a = 0;
                }
                itemBufferElement.decreaseStackSize(moveCount);
                outputItemCounter.modifyStackSize(moveCount);
                itemInSlot.field_77994_a += moveCount;
                subElement.reduceAmount(moveCount);
                if (newItem) {
                    inventory.func_70299_a(slot.getSlot(), itemInSlot);
                }
                boolean done = false;
                if (subElement.getSizeLeft() == 0) {
                    subElement.remove();
                    itemBufferElement.removeSubElement();
                    done = true;
                }
                inventory.func_70296_d();
                subElement.onUpdate();
                if (!done) continue;
                continue block0;
            }
        }
        itemBufferElement.releaseSubElements();
    }

    private void insertFluids(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        ArrayList<OutputFluidCounter> outputCounters = new ArrayList<OutputFluidCounter>();
        for (SlotInventoryHolder tankHolder : tanks) {
            if (!tankHolder.isShared()) {
                outputCounters.clear();
            }
            IFluidHandler tank = tankHolder.getTank();
            for (FluidBufferElement fluidBufferElement : this.fluidBuffer) {
                Iterator<StackTankHolder> fluidIterator = fluidBufferElement.getHolders().iterator();
                while (fluidIterator.hasNext()) {
                    StackTankHolder holder = fluidIterator.next();
                    FluidStack fluidStack = holder.getFluidStack();
                    Setting setting = this.isFluidValid(componentMenu, fluidStack);
                    if (menuItem.useWhiteList() == (setting == null) && (setting == null || !setting.isLimitedByAmount())) continue;
                    OutputFluidCounter outputFluidCounter = null;
                    for (OutputFluidCounter e : outputCounters) {
                        if (!e.areSettingsSame(setting)) continue;
                        outputFluidCounter = e;
                        break;
                    }
                    if (outputFluidCounter == null) {
                        outputFluidCounter = new OutputFluidCounter(this.fluidBuffer, tanks, tankHolder, setting, menuItem.useWhiteList());
                        outputCounters.add(outputFluidCounter);
                    }
                    block4: for (SlotSideTarget slot : tankHolder.getValidSlots().values()) {
                        for (int side : slot.getSides()) {
                            FluidStack temp = fluidStack.copy();
                            temp.amount = holder.getSizeLeft();
                            int amount = tank.fill(EnumFacing.func_82600_a((int)side), temp, false);
                            amount = fluidBufferElement.retrieveItemCount(amount);
                            if ((amount = outputFluidCounter.retrieveItemCount(amount)) <= 0) continue;
                            FluidStack resource = fluidStack.copy();
                            resource.amount = amount;
                            resource = holder.getTank().drain(holder.getSide(), resource, true);
                            if (resource == null || resource.amount <= 0) continue;
                            tank.fill(EnumFacing.func_82600_a((int)side), resource, true);
                            fluidBufferElement.decreaseStackSize(resource.amount);
                            outputFluidCounter.modifyStackSize(resource.amount);
                            holder.reduceAmount(resource.amount);
                            if (holder.getSizeLeft() != 0) continue;
                            fluidIterator.remove();
                            continue block4;
                        }
                    }
                }
            }
        }
    }

    private boolean searchForStuff(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories, boolean useFluids) {
        if (inventories.get(0).isShared()) {
            HashMap<Integer, ConditionSettingChecker> conditionSettingCheckerMap = new HashMap<Integer, ConditionSettingChecker>();
            for (int i = 0; i < inventories.size(); ++i) {
                this.calculateConditionData(componentMenu, inventories.get(i), conditionSettingCheckerMap, useFluids);
            }
            return this.checkConditionResult(componentMenu, conditionSettingCheckerMap);
        }
        boolean useAnd = inventories.get(0).getSharedOption() == 1;
        for (int i = 0; i < inventories.size(); ++i) {
            HashMap<Integer, ConditionSettingChecker> conditionSettingCheckerMap = new HashMap<Integer, ConditionSettingChecker>();
            this.calculateConditionData(componentMenu, inventories.get(i), conditionSettingCheckerMap, useFluids);
            if (this.checkConditionResult(componentMenu, conditionSettingCheckerMap)) {
                if (useAnd) continue;
                return true;
            }
            if (!useAnd) continue;
            return false;
        }
        return useAnd;
    }

    private void calculateConditionData(ComponentMenu componentMenu, SlotInventoryHolder inventoryHolder, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap, boolean useFluids) {
        if (useFluids) {
            this.calculateConditionDataFluid(componentMenu, inventoryHolder, conditionSettingCheckerMap);
        } else {
            this.calculateConditionDataItem(componentMenu, inventoryHolder, conditionSettingCheckerMap);
        }
    }

    private void calculateConditionDataItem(ComponentMenu componentMenu, SlotInventoryHolder inventoryHolder, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        for (SlotSideTarget slot : inventoryHolder.getValidSlots().values()) {
            Setting setting;
            ItemStack itemStack = inventoryHolder.getInventory().func_70301_a(slot.getSlot());
            if (!this.isSlotValid(inventoryHolder.getInventory(), itemStack, slot, true) || (setting = this.isItemValid(componentMenu, itemStack)) == null) continue;
            ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
            if (conditionSettingChecker == null) {
                conditionSettingChecker = new ConditionSettingChecker(setting);
                conditionSettingCheckerMap.put(setting.getId(), conditionSettingChecker);
            }
            conditionSettingChecker.addCount(itemStack.field_77994_a);
        }
    }

    private void calculateConditionDataFluid(ComponentMenu componentMenu, SlotInventoryHolder tank, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        for (SlotSideTarget slot : tank.getValidSlots().values()) {
            ArrayList<FluidTankInfo> tankInfos = new ArrayList<FluidTankInfo>();
            for (int side : slot.getSides()) {
                FluidTankInfo[] currentTankInfos = tank.getTank().getTankInfo(EnumFacing.func_82600_a((int)side));
                if (currentTankInfos == null) continue;
                for (FluidTankInfo fluidTankInfo : currentTankInfos) {
                    FluidStack fluidStack;
                    Setting setting;
                    if (fluidTankInfo == null) continue;
                    boolean alreadyUsed = false;
                    for (FluidTankInfo tankInfo : tankInfos) {
                        if (!FluidStack.areFluidStackTagsEqual((FluidStack)tankInfo.fluid, (FluidStack)fluidTankInfo.fluid) || tankInfo.capacity != fluidTankInfo.capacity) continue;
                        alreadyUsed = true;
                    }
                    if (alreadyUsed || (setting = this.isFluidValid(componentMenu, fluidStack = fluidTankInfo.fluid)) == null) continue;
                    ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
                    if (conditionSettingChecker == null) {
                        conditionSettingChecker = new ConditionSettingChecker(setting);
                        conditionSettingCheckerMap.put(setting.getId(), conditionSettingChecker);
                    }
                    conditionSettingChecker.addCount(fluidStack.amount);
                }
                for (FluidTankInfo fluidTankInfo : tank.getTank().getTankInfo(EnumFacing.func_82600_a((int)side))) {
                    if (fluidTankInfo == null) continue;
                    tankInfos.add(fluidTankInfo);
                }
            }
        }
    }

    private boolean checkConditionResult(ComponentMenu componentMenu, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        IConditionStuffMenu menuCondition = (IConditionStuffMenu)((Object)componentMenu);
        for (Setting setting : menuItem.getSettings()) {
            if (!setting.isValid()) continue;
            ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
            if (conditionSettingChecker != null && conditionSettingChecker.isTrue()) {
                if (menuCondition.requiresAll()) continue;
                return true;
            }
            if (!menuCondition.requiresAll()) continue;
            return false;
        }
        return menuCondition.requiresAll();
    }

    private boolean splitFlow(ComponentMenu componentMenu) {
        ComponentMenuSplit split = (ComponentMenuSplit)componentMenu;
        if (split.useSplit()) {
            int amount = componentMenu.getParent().getConnectionSet().getOutputCount();
            if (!split.useEmpty()) {
                ConnectionOption[] connections = componentMenu.getParent().getConnectionSet().getConnections();
                for (int i = 0; i < connections.length; ++i) {
                    ConnectionOption connectionOption = connections[i];
                    if (connectionOption.isInput() || componentMenu.getParent().getConnection(i) != null) continue;
                    --amount;
                }
            }
            int usedId = 0;
            ConnectionOption[] connections = componentMenu.getParent().getConnectionSet().getConnections();
            for (int i = 0; i < connections.length; ++i) {
                ConnectionOption connectionOption = connections[i];
                Connection connection = componentMenu.getParent().getConnection(i);
                if (connectionOption.isInput() || connection == null) continue;
                ArrayList<ItemBufferElement> itemBufferSplit = new ArrayList<ItemBufferElement>();
                ArrayList<FluidBufferElement> fluidBufferSplit = new ArrayList<FluidBufferElement>();
                for (ItemBufferElement itemBufferElement : this.itemBuffer) {
                    itemBufferSplit.add(itemBufferElement.getSplitElement(amount, usedId, split.useFair()));
                }
                for (FluidBufferElement fluidBufferElement : this.fluidBuffer) {
                    fluidBufferSplit.add(fluidBufferElement.getSplitElement(amount, usedId, split.useFair()));
                }
                ArrayList<Integer> usedCommandCopy = new ArrayList<Integer>();
                for (int usedCommand : this.usedCommands) {
                    usedCommandCopy.add(usedCommand);
                }
                CommandExecutor commandExecutor = new CommandExecutor(this.manager, itemBufferSplit, new ArrayList<CraftingBufferElement>(this.craftingBufferHigh), new ArrayList<CraftingBufferElement>(this.craftingBufferLow), fluidBufferSplit, usedCommandCopy);
                commandExecutor.executeCommand(this.manager.getFlowItems().get(connection.getComponentId()), connection.getConnectionId());
                ++usedId;
            }
            return true;
        }
        return false;
    }

    private boolean evaluateRedstoneCondition(List<SlotInventoryHolder> nodes, FlowComponent component) {
        return TileEntityManager.redstoneCondition.isTriggerPowered(nodes, component, true);
    }

    private void updateVariable(List<SlotInventoryHolder> tiles, ComponentMenuVariable menuVariable, ComponentMenuListOrder menuOrder) {
        ComponentMenuVariable.VariableMode mode = menuVariable.getVariableMode();
        Variable variable = this.manager.getVariables()[menuVariable.getSelectedVariable()];
        if (variable.isValid()) {
            boolean remove;
            boolean bl = remove = mode == ComponentMenuVariable.VariableMode.REMOVE;
            if (!remove && mode != ComponentMenuVariable.VariableMode.ADD) {
                variable.clearContainers();
            }
            List<Integer> idList = new ArrayList<Integer>();
            for (SlotInventoryHolder tile : tiles) {
                idList.add(tile.getId());
            }
            if (!menuVariable.isDeclaration()) {
                idList = this.applyOrder(idList, menuOrder);
            }
            List<ConnectionBlock> inventories = this.manager.getConnectedInventories();
            EnumSet<ConnectionBlockType> validTypes = ((ComponentMenuContainerTypes)variable.getDeclaration().getMenus().get(1)).getValidTypes();
            for (int id : idList) {
                if (remove) {
                    variable.remove(id);
                    continue;
                }
                if (id < 0 || id >= inventories.size() || !inventories.get(id).isOfAnyType(validTypes)) continue;
                variable.add(id);
            }
        }
    }

    private void updateForLoop(FlowComponent command, ComponentMenuVariableLoop variableMenu, ComponentMenuContainerTypes typesMenu, ComponentMenuListOrder orderMenu) {
        Variable list = variableMenu.getListVariable();
        Variable element = variableMenu.getElementVariable();
        if (!list.isValid() || !element.isValid()) {
            return;
        }
        List<Integer> selection = this.applyOrder(list.getContainers(), orderMenu);
        EnumSet<ConnectionBlockType> validTypes = typesMenu.getValidTypes();
        validTypes.addAll(((ComponentMenuContainerTypes)element.getDeclaration().getMenus().get(1)).getValidTypes());
        List<ConnectionBlock> inventories = this.manager.getConnectedInventories();
        for (Integer selected : selection) {
            ConnectionBlock inventory;
            if (selected < 0 || selected >= inventories.size() || !(inventory = inventories.get(selected)).isOfAnyType(validTypes)) continue;
            element.clearContainers();
            element.add(selected);
            this.executeChildCommands(command, EnumSet.of(ConnectionOption.FOR_EACH));
        }
    }

    private List<Integer> applyOrder(List<Integer> original, ComponentMenuListOrder orderMenu) {
        ArrayList<Integer> ret = new ArrayList<Integer>(original);
        if (orderMenu.getOrder() == ComponentMenuListOrder.LoopOrder.RANDOM) {
            Collections.shuffle(ret);
        } else if (orderMenu.getOrder() == ComponentMenuListOrder.LoopOrder.NORMAL) {
            if (!orderMenu.isReversed()) {
                Collections.reverse(ret);
            }
        } else {
            Collections.sort(ret, orderMenu.getComparator());
        }
        if (!orderMenu.useAll()) {
            int len = orderMenu.getAmount();
            while (ret.size() > len) {
                ret.remove(ret.size() - 1);
            }
        }
        return ret;
    }
}

