/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.CheckBox;
import vswe.stevesfactory.components.CheckBoxList;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.RadioButton;
import vswe.stevesfactory.components.RadioButtonList;
import vswe.stevesfactory.components.TextBoxNumber;
import vswe.stevesfactory.components.TextBoxNumberList;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public class ComponentMenuPulse
extends ComponentMenu {
    private static final int CHECK_BOX_X = 5;
    private static final int CHECK_BOX_Y = 5;
    private static final int RADIO_BUTTON_X = 5;
    private static final int RADIO_BUTTON_Y = 44;
    private static final int RADIO_BUTTON_SPACING_X = 67;
    private static final int RADIO_BUTTON_SPACING_Y = 12;
    private static final int TEXT_BOX_X_LEFT = 10;
    private static final int TEXT_BOX_X_RIGHT = 70;
    private static final int TEXT_BOX_Y = 25;
    private CheckBoxList checkBoxes = new CheckBoxList();
    private boolean usePulse;
    private RadioButtonList radioButtons;
    private TextBoxNumberList textBoxes;
    private TextBoxNumber ticksTextBox;
    private TextBoxNumber secondsTextBox;
    private static final String NBT_USE_PULSE = "UsePulse";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_SECOND = "Seconds";
    private static final String NBT_TICK = "Ticks";

    public ComponentMenuPulse(FlowComponent parent) {
        super(parent);
        this.checkBoxes.addCheckBox(new CheckBox(Localization.DO_EMIT_PULSE, 5, 5){

            @Override
            public void setValue(boolean val) {
                ComponentMenuPulse.this.usePulse = val;
            }

            @Override
            public boolean getValue() {
                return ComponentMenuPulse.this.usePulse;
            }

            @Override
            public void onUpdate() {
                ComponentMenuPulse.this.sendServerPacket(ComponentSyncType.CHECK_BOX);
            }
        });
        this.radioButtons = new RadioButtonList(){

            @Override
            public void updateSelectedOption(int selectedOption) {
                ComponentMenuPulse.this.radioButtons.setSelectedOption(selectedOption);
                ComponentMenuPulse.this.sendServerPacket(ComponentSyncType.RADIO_BUTTON);
            }
        };
        for (int i = 0; i < PULSE_OPTIONS.values().length; ++i) {
            int x = i % 2;
            int y = i / 2;
            this.radioButtons.add(new RadioButton(5 + x * 67, 44 + y * 12, PULSE_OPTIONS.values()[i].getName()));
        }
        this.textBoxes = new TextBoxNumberList();
        this.secondsTextBox = new TextBoxNumber(10, 25, 2, true){

            @Override
            public void onNumberChanged() {
                ComponentMenuPulse.this.sendServerPacket(ComponentSyncType.TEXT_BOX_1);
            }
        };
        this.textBoxes.addTextBox(this.secondsTextBox);
        this.ticksTextBox = new TextBoxNumber(70, 25, 2, true){

            @Override
            public int getMaxNumber() {
                return 19;
            }

            @Override
            public void onNumberChanged() {
                ComponentMenuPulse.this.sendServerPacket(ComponentSyncType.TEXT_BOX_2);
            }
        };
        this.textBoxes.addTextBox(this.ticksTextBox);
        this.setDefault();
    }

    @Override
    public String getName() {
        return Localization.PULSE_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.checkBoxes.draw(gui, mX, mY);
        if (this.usePulse) {
            this.radioButtons.draw(gui, mX, mY);
            this.textBoxes.draw(gui, mX, mY);
            gui.drawCenteredString(Localization.SECONDS.toString(), this.secondsTextBox.getX(), this.secondsTextBox.getY() - 7, 0.7f, this.secondsTextBox.getWidth(), 0x404040);
            gui.drawCenteredString(Localization.TICKS.toString(), this.ticksTextBox.getX(), this.ticksTextBox.getY() - 7, 0.7f, this.ticksTextBox.getWidth(), 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.checkBoxes.onClick(mX, mY);
        if (this.usePulse) {
            this.radioButtons.onClick(mX, mY, button);
            this.textBoxes.onClick(mX, mY, button);
        }
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        return this.usePulse && this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeBoolean(this.usePulse);
        if (this.usePulse) {
            dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.PULSE_TYPES);
            dw.writeData(this.secondsTextBox.getNumber(), DataBitHelper.PULSE_SECONDS);
            dw.writeData(this.ticksTextBox.getNumber(), DataBitHelper.PULSE_TICKS);
        }
    }

    @Override
    public void readData(DataReader dr) {
        this.usePulse = dr.readBoolean();
        if (this.usePulse) {
            this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.PULSE_TYPES));
            this.secondsTextBox.setNumber(dr.readData(DataBitHelper.PULSE_SECONDS));
            this.ticksTextBox.setNumber(dr.readData(DataBitHelper.PULSE_TICKS));
        }
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuPulse menuPulse = (ComponentMenuPulse)menu;
        this.usePulse = menuPulse.usePulse;
        if (this.usePulse) {
            this.radioButtons.setSelectedOption(menuPulse.radioButtons.getSelectedOption());
            this.secondsTextBox.setNumber(menuPulse.secondsTextBox.getNumber());
            this.ticksTextBox.setNumber(menuPulse.ticksTextBox.getNumber());
        } else {
            this.setDefault();
        }
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuPulse newDataPulse = (ComponentMenuPulse)newData;
        if (this.usePulse != newDataPulse.usePulse) {
            this.usePulse = newDataPulse.usePulse;
            this.sendClientPacket(container, ComponentSyncType.CHECK_BOX);
            if (!this.usePulse) {
                this.setDefault();
                return;
            }
        }
        if (this.radioButtons.getSelectedOption() != newDataPulse.radioButtons.getSelectedOption()) {
            this.radioButtons.setSelectedOption(newDataPulse.radioButtons.getSelectedOption());
            this.sendClientPacket(container, ComponentSyncType.RADIO_BUTTON);
        }
        if (this.secondsTextBox.getNumber() != newDataPulse.secondsTextBox.getNumber()) {
            this.secondsTextBox.setNumber(newDataPulse.secondsTextBox.getNumber());
            this.sendClientPacket(container, ComponentSyncType.TEXT_BOX_1);
        }
        if (this.ticksTextBox.getNumber() != newDataPulse.ticksTextBox.getNumber()) {
            this.ticksTextBox.setNumber(newDataPulse.ticksTextBox.getNumber());
            this.sendClientPacket(container, ComponentSyncType.TEXT_BOX_2);
        }
    }

    private void sendClientPacket(ContainerManager container, ComponentSyncType type) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, type);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    private void sendServerPacket(ComponentSyncType type) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, type);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeData(DataWriter dw, ComponentSyncType type) {
        dw.writeData(type.ordinal(), DataBitHelper.PULSE_COMPONENT_TYPES);
        switch (type) {
            case CHECK_BOX: {
                dw.writeBoolean(this.usePulse);
                break;
            }
            case RADIO_BUTTON: {
                dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.PULSE_TYPES);
                break;
            }
            case TEXT_BOX_1: {
                dw.writeData(this.secondsTextBox.getNumber(), DataBitHelper.PULSE_SECONDS);
                break;
            }
            case TEXT_BOX_2: {
                dw.writeData(this.ticksTextBox.getNumber(), DataBitHelper.PULSE_TICKS);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.usePulse = nbtTagCompound.func_74767_n(NBT_USE_PULSE);
        if (this.usePulse) {
            this.radioButtons.setSelectedOption(nbtTagCompound.func_74771_c(NBT_TYPE));
            this.secondsTextBox.setNumber(nbtTagCompound.func_74771_c(NBT_SECOND));
            this.ticksTextBox.setNumber(nbtTagCompound.func_74771_c(NBT_TICK));
        } else {
            this.setDefault();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74757_a(NBT_USE_PULSE, this.usePulse);
        if (this.usePulse) {
            nbtTagCompound.func_74774_a(NBT_TYPE, (byte)this.radioButtons.getSelectedOption());
            nbtTagCompound.func_74774_a(NBT_SECOND, (byte)this.secondsTextBox.getNumber());
            nbtTagCompound.func_74774_a(NBT_TICK, (byte)this.ticksTextBox.getNumber());
        }
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        ComponentSyncType type = ComponentSyncType.values()[dr.readData(DataBitHelper.PULSE_COMPONENT_TYPES)];
        switch (type) {
            case CHECK_BOX: {
                this.usePulse = dr.readBoolean();
                if (this.usePulse) break;
                this.setDefault();
                break;
            }
            case RADIO_BUTTON: {
                this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.PULSE_TYPES));
                break;
            }
            case TEXT_BOX_1: {
                this.secondsTextBox.setNumber(dr.readData(DataBitHelper.PULSE_SECONDS));
                break;
            }
            case TEXT_BOX_2: {
                this.ticksTextBox.setNumber(dr.readData(DataBitHelper.PULSE_TICKS));
            }
        }
    }

    private void setDefault() {
        this.radioButtons.setSelectedOption(0);
        this.secondsTextBox.setNumber(0);
        this.ticksTextBox.setNumber(10);
    }

    public boolean shouldEmitPulse() {
        return this.usePulse;
    }

    public PULSE_OPTIONS getSelectedPulseOverride() {
        return PULSE_OPTIONS.values()[this.radioButtons.getSelectedOption()];
    }

    public int getPulseTime() {
        return this.secondsTextBox.getNumber() * 20 + this.ticksTextBox.getNumber();
    }

    private static enum ComponentSyncType {
        CHECK_BOX,
        RADIO_BUTTON,
        TEXT_BOX_1,
        TEXT_BOX_2;

    }

    public static enum PULSE_OPTIONS {
        EXTEND_OLD(Localization.EXTEND_OLD),
        KEEP_ALL(Localization.KEEP_ALL),
        KEEP_OLD(Localization.KEEP_OLD),
        KEEP_NEW(Localization.KEEP_NEW);

        private Localization name;

        private PULSE_OPTIONS(Localization name) {
            this.name = name;
        }

        public String toString() {
            return this.name.toString();
        }

        public Localization getName() {
            return this.name;
        }
    }
}

