/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentType;
import vswe.stevesfactory.components.ConnectionSet;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.RadioButton;
import vswe.stevesfactory.components.RadioButtonList;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public class ComponentMenuResult
extends ComponentMenu {
    private static final int RADIO_X = 5;
    private static final int RADIO_Y = 5;
    private static final int RADIO_MARGIN = 13;
    private ConnectionSet[] sets;
    private RadioButtonList radioButtons;
    private static final String NBT_SELECTED = "SelectedOption";

    public ComponentMenuResult(FlowComponent parent) {
        super(parent);
        int i;
        this.sets = parent.getType().getSets();
        this.radioButtons = new RadioButtonList(){

            @Override
            public void updateSelectedOption(int selectedOption) {
                DataWriter dw = ComponentMenuResult.this.getWriterForServerComponentPacket();
                ComponentMenuResult.this.writeData(dw, selectedOption);
                PacketHandler.sendDataToServer(dw);
            }

            @Override
            public void setSelectedOption(int selectedOption) {
                super.setSelectedOption(selectedOption);
                if (selectedOption >= ComponentMenuResult.this.sets.length) {
                    System.out.println(ComponentMenuResult.this.getParent().getType().getLongName());
                }
                ComponentMenuResult.this.getParent().setConnectionSet(ComponentMenuResult.this.sets[ComponentMenuResult.this.radioButtons.getSelectedOption()]);
                if (ComponentMenuResult.this.getParent().getType() == ComponentType.VARIABLE) {
                    ComponentMenuResult.this.getParent().getManager().updateVariables();
                } else if (ComponentMenuResult.this.getParent().getType() == ComponentType.NODE) {
                    ComponentMenuResult.this.getParent().setParent(ComponentMenuResult.this.getParent().getParent());
                }
            }
        };
        for (i = 0; i < this.sets.length; ++i) {
            this.radioButtons.add(new RadioButton(5, 5 + i * 13, this.sets[i].getName()));
        }
        for (i = 0; i < this.sets.length; ++i) {
            ConnectionSet set = this.sets[i];
            if (!parent.getConnectionSet().equals((Object)set)) continue;
            this.radioButtons.setSelectedOption(i);
            break;
        }
    }

    @Override
    public String getName() {
        return Localization.CONNECTIONS_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.radioButtons.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.radioButtons.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        this.writeData(dw, this.radioButtons.getSelectedOption());
    }

    @Override
    public void readData(DataReader dr) {
        this.readTheData(dr);
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        this.radioButtons.setSelectedOption(((ComponentMenuResult)menu).radioButtons.getSelectedOption());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuResult newDataResult = (ComponentMenuResult)newData;
        if (this.radioButtons.getSelectedOption() != newDataResult.radioButtons.getSelectedOption()) {
            this.radioButtons.setSelectedOption(newDataResult.radioButtons.getSelectedOption());
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            this.writeData(dw, this.radioButtons.getSelectedOption());
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        this.readTheData(dr);
    }

    private void readTheData(DataReader dr) {
        this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.MENU_CONNECTION_TYPE_ID));
    }

    private void writeData(DataWriter dw, int val) {
        dw.writeData(val, DataBitHelper.MENU_CONNECTION_TYPE_ID);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.radioButtons.setSelectedOption(nbtTagCompound.func_74771_c(NBT_SELECTED));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_SELECTED, (byte)this.radioButtons.getSelectedOption());
    }

    @Override
    public boolean isVisible() {
        return this.sets.length > 1;
    }
}

