/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.CheckBox;
import vswe.stevesfactory.components.CheckBoxList;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.TextBoxLogic;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public class ComponentMenuSignText
extends ComponentMenu {
    private static final int TEXT_BOX_SIZE_W = 64;
    private static final int TEXT_BOX_SIZE_H = 12;
    private static final int TEXT_BOX_SRC_X = 0;
    private static final int TEXT_BOX_SRC_Y = 165;
    private static final int TEXT_BOX_X = 5;
    private static final int TEXT_BOX_Y = 5;
    private static final int TEXT_BOX_Y_SPACING = 15;
    private static final int TEXT_BOX_TEXT_X = 3;
    private static final int TEXT_BOX_TEXT_Y = 5;
    private static final int CURSOR_X = 2;
    private static final int CURSOR_Y = 0;
    private static final int CURSOR_Z = 5;
    private static final int CHECK_BOX_X = 75;
    private static final int CHECK_BOX_Y = 2;
    private static final float IDLE_TIME = 1.0f;
    private TextBoxLogic[] textBoxes = new TextBoxLogic[4];
    private CheckBoxList checkBoxes;
    private boolean[] update = new boolean[this.textBoxes.length];
    private float[] hasChanged = new float[this.textBoxes.length];
    private int selected = -1;
    private static final String NBT_LINES = "Lines";
    private static final String NBT_UPDATE = "Update";
    private static final String NBT_TEXT = "Text";

    public ComponentMenuSignText(FlowComponent parent) {
        super(parent);
        this.checkBoxes = new CheckBoxList();
        for (int i = 0; i < this.textBoxes.length; ++i) {
            final int id = i;
            this.textBoxes[i] = new TextBoxLogic(15, 58){

                @Override
                protected void textChanged() {
                    ((ComponentMenuSignText)ComponentMenuSignText.this).hasChanged[id] = 1.0f;
                }
            };
            this.textBoxes[i].setMult(0.6f);
            this.textBoxes[i].setTextAndCursor("");
            this.checkBoxes.addCheckBox(new CheckBox(Localization.UPDATE_LINE, 75, 7 + i * 15){

                @Override
                public void setValue(boolean val) {
                    ((ComponentMenuSignText)ComponentMenuSignText.this).update[id] = val;
                }

                @Override
                public boolean getValue() {
                    return ComponentMenuSignText.this.update[id];
                }

                @Override
                public void onUpdate() {
                    DataWriter dw = ComponentMenuSignText.this.getWriterForServerComponentPacket();
                    dw.writeData(id, DataBitHelper.LINE_ID);
                    dw.writeBoolean(false);
                    dw.writeBoolean(this.getValue());
                    PacketHandler.sendDataToServer(dw);
                }
            });
            this.update[i] = true;
        }
    }

    @Override
    public void update(float partial) {
        for (int i = 0; i < this.hasChanged.length; ++i) {
            if (!(this.hasChanged[i] > 0.0f)) continue;
            int n = i;
            this.hasChanged[n] = this.hasChanged[n] - partial;
            if (!(this.hasChanged[i] <= 0.0f)) continue;
            DataWriter dw = this.getWriterForServerComponentPacket();
            dw.writeData(i, DataBitHelper.LINE_ID);
            dw.writeBoolean(true);
            dw.writeString(this.textBoxes[i].getText(), DataBitHelper.LINE_LENGTH);
            PacketHandler.sendDataToServer(dw);
        }
    }

    @Override
    public void onGuiClosed() {
        this.update(1.0f);
    }

    @Override
    public String getName() {
        return Localization.SIGN_TEXT.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        for (int i = 0; i < this.textBoxes.length; ++i) {
            TextBoxLogic textBox = this.textBoxes[i];
            int srcBoxY = this.selected == i ? 1 : 0;
            int y = 5 + i * 15;
            gui.drawTexture(5, y, 0, 165 + srcBoxY * 12, 64, 12);
            gui.drawString(textBox.getText(), 8, y + 5, 0.6f, 0xFFFFFF);
            if (this.selected != i) continue;
            gui.drawCursor(5 + textBox.getCursorPosition(gui) + 2, y + 0, 5, -1);
        }
        this.checkBoxes.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (k == 15) {
            this.selected = (this.selected + 1) % 4;
            this.onSelectedChange();
            return true;
        }
        if (this.selected == -1) {
            return super.onKeyStroke(gui, c, k);
        }
        this.textBoxes[this.selected].onKeyStroke(gui, c, k);
        return true;
    }

    private void onSelectedChange() {
        this.update(1.0f);
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        for (int i = 0; i < this.textBoxes.length; ++i) {
            if (!CollisionHelper.inBounds(5, 5 + 15 * i, 64, 12, mX, mY)) continue;
            this.selected = i == this.selected ? -1 : i;
            this.onSelectedChange();
            break;
        }
        this.checkBoxes.onClick(mX, mY);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        for (int i = 0; i < this.textBoxes.length; ++i) {
            dw.writeBoolean(this.update[i]);
            dw.writeString(this.textBoxes[i].getText(), DataBitHelper.LINE_LENGTH);
        }
    }

    @Override
    public void readData(DataReader dr) {
        for (int i = 0; i < this.textBoxes.length; ++i) {
            this.update[i] = dr.readBoolean();
            this.setTextPostSync(i, dr.readString(DataBitHelper.LINE_LENGTH));
            this.textBoxes[i].resetCursor();
        }
    }

    private void setTextPostSync(int id, String str) {
        if (str == null) {
            str = "";
        }
        this.textBoxes[id].setText(str);
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuSignText textMenu = (ComponentMenuSignText)menu;
        for (int i = 0; i < this.textBoxes.length; ++i) {
            this.textBoxes[i].setText(textMenu.textBoxes[i].getText());
            this.update[i] = textMenu.update[i];
        }
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuSignText newDataText = (ComponentMenuSignText)newData;
        for (int i = 0; i < this.textBoxes.length; ++i) {
            DataWriter dw;
            if (!newDataText.textBoxes[i].getText().equals(this.textBoxes[i].getText())) {
                this.textBoxes[i].setText(newDataText.textBoxes[i].getText());
                dw = this.getWriterForClientComponentPacket(container);
                dw.writeData(i, DataBitHelper.LINE_ID);
                dw.writeBoolean(true);
                dw.writeString(this.textBoxes[i].getText(), DataBitHelper.LINE_LENGTH);
                PacketHandler.sendDataToListeningClients(container, dw);
            }
            if (newDataText.update[i] == this.update[i]) continue;
            this.update[i] = newDataText.update[i];
            dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(i, DataBitHelper.LINE_ID);
            dw.writeBoolean(false);
            dw.writeBoolean(this.update[i]);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        NBTTagList list = nbtTagCompound.func_150295_c(NBT_LINES, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound element = list.func_150305_b(i);
            this.update[i] = element.func_74767_n(NBT_UPDATE);
            this.setTextPostSync(i, element.func_74779_i(NBT_TEXT));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.textBoxes.length; ++i) {
            NBTTagCompound element = new NBTTagCompound();
            element.func_74757_a(NBT_UPDATE, this.update[i]);
            element.func_74778_a(NBT_TEXT, this.textBoxes[i].getText());
            list.func_74742_a((NBTBase)element);
        }
        nbtTagCompound.func_74782_a(NBT_LINES, (NBTBase)list);
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        int id = dr.readData(DataBitHelper.LINE_ID);
        if (dr.readBoolean()) {
            this.setTextPostSync(id, dr.readString(DataBitHelper.LINE_LENGTH));
            this.textBoxes[id].updateCursor();
        } else {
            this.update[id] = dr.readBoolean();
        }
    }

    public boolean shouldUpdate(int id) {
        return this.update[id];
    }

    public String getText(int id) {
        return this.textBoxes[id].getText();
    }
}

