/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.CheckBox;
import vswe.stevesfactory.components.CheckBoxList;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ConnectionSet;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.RadioButton;
import vswe.stevesfactory.components.RadioButtonList;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public class ComponentMenuSplit
extends ComponentMenu {
    private RadioButtonList radioButtons = new RadioButtonList(){

        @Override
        public void updateSelectedOption(int selectedOption) {
            this.setSelectedOption(selectedOption);
            ComponentMenuSplit.this.sendServerData(0);
        }
    };
    private CheckBoxList checkBoxes;
    private boolean useFair;
    private boolean useEmpty;
    private static final int RADIO_X = 5;
    private static final int RADIO_Y = 5;
    private static final int CHECK_BOX_X = 15;
    private static final int SPACING_Y = 15;
    private static final String NBT_SPLIT = "Split";
    private static final String NBT_FAIR = "Fair";
    private static final String NBT_EMPTY = "Empty";

    public ComponentMenuSplit(FlowComponent parent) {
        super(parent);
        this.radioButtons.add(new RadioButton(5, 5, Localization.SEQUENTIAL));
        this.radioButtons.add(new RadioButton(5, 20, Localization.SPLIT));
        this.checkBoxes = new CheckBoxList();
        this.checkBoxes.addCheckBox(new CheckBox(Localization.FAIR_SPLIT, 15, 35){

            @Override
            public void setValue(boolean val) {
                ComponentMenuSplit.this.setFair(val);
            }

            @Override
            public boolean getValue() {
                return ComponentMenuSplit.this.useFair();
            }

            @Override
            public void onUpdate() {
                ComponentMenuSplit.this.sendServerData(1);
            }
        });
        this.checkBoxes.addCheckBox(new CheckBox(Localization.EMPTY_PINS, 15, 50){

            @Override
            public void setValue(boolean val) {
                ComponentMenuSplit.this.setEmpty(val);
            }

            @Override
            public boolean getValue() {
                return ComponentMenuSplit.this.useEmpty();
            }

            @Override
            public void onUpdate() {
                ComponentMenuSplit.this.sendServerData(2);
            }
        });
    }

    @Override
    public String getName() {
        return Localization.SPLIT_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        if (this.useSplit()) {
            this.checkBoxes.draw(gui, mX, mY);
        }
        this.radioButtons.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        if (this.useSplit()) {
            this.checkBoxes.onClick(mX, mY);
        }
        this.radioButtons.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeBoolean(this.useSplit());
        if (this.useSplit()) {
            dw.writeBoolean(this.useFair());
            dw.writeBoolean(this.useEmpty());
        }
    }

    @Override
    public void readData(DataReader dr) {
        this.setSplit(dr.readBoolean());
        if (this.useSplit()) {
            this.setFair(dr.readBoolean());
            this.setEmpty(dr.readBoolean());
        } else {
            this.setFair(false);
            this.setEmpty(false);
        }
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuSplit menuSplit = (ComponentMenuSplit)menu;
        this.setSplit(menuSplit.useSplit());
        this.setFair(menuSplit.useFair());
        this.setEmpty(menuSplit.useEmpty());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuSplit newDataSplit = (ComponentMenuSplit)newData;
        if (this.useSplit() != newDataSplit.useSplit()) {
            this.setSplit(newDataSplit.useSplit());
            this.sendClientData(container, 0);
        }
        if (this.useFair() != newDataSplit.useFair()) {
            this.setFair(newDataSplit.useFair());
            this.sendClientData(container, 1);
        }
        if (this.useEmpty() != newDataSplit.useEmpty()) {
            this.setEmpty(newDataSplit.useEmpty());
            this.sendClientData(container, 2);
        }
    }

    private void sendClientData(ContainerManager container, int id) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, id);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    private void sendServerData(int id) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, id);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeData(DataWriter dw, int id) {
        dw.writeData(id, DataBitHelper.MENU_SPLIT_DATA_ID);
        switch (id) {
            case 0: {
                dw.writeBoolean(this.useSplit());
                break;
            }
            case 1: {
                dw.writeBoolean(this.useFair());
                break;
            }
            case 2: {
                dw.writeBoolean(this.useEmpty());
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.setSplit(nbtTagCompound.func_74767_n(NBT_SPLIT));
        if (this.useSplit()) {
            this.setFair(nbtTagCompound.func_74767_n(NBT_FAIR));
            this.setEmpty(nbtTagCompound.func_74767_n(NBT_EMPTY));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74757_a(NBT_SPLIT, this.useSplit());
        if (this.useSplit()) {
            nbtTagCompound.func_74757_a(NBT_FAIR, this.useFair());
            nbtTagCompound.func_74757_a(NBT_EMPTY, this.useEmpty());
        }
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        int id = dr.readData(DataBitHelper.MENU_SPLIT_DATA_ID);
        switch (id) {
            case 0: {
                this.setSplit(dr.readBoolean());
                break;
            }
            case 1: {
                this.setFair(dr.readBoolean());
                break;
            }
            case 2: {
                this.setEmpty(dr.readBoolean());
            }
        }
    }

    @Override
    public boolean isVisible() {
        return ComponentMenuSplit.isSplitConnection(this.getParent());
    }

    public static boolean isSplitConnection(FlowComponent component) {
        return component.getConnectionSet() == ConnectionSet.MULTIPLE_OUTPUT_2 || component.getConnectionSet() == ConnectionSet.MULTIPLE_OUTPUT_5;
    }

    public boolean useSplit() {
        return this.radioButtons.getSelectedOption() == 1;
    }

    private void setSplit(boolean val) {
        this.radioButtons.setSelectedOption(val ? 1 : 0);
    }

    public boolean useFair() {
        return this.useFair;
    }

    private void setFair(boolean val) {
        this.useFair = val;
    }

    public boolean useEmpty() {
        return this.useEmpty;
    }

    private void setEmpty(boolean val) {
        this.useEmpty = val;
    }
}

