/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.components.Point;

public class Connection {
    private int componentId;
    private int connectionId;
    private List<Point> nodes;
    private Point selectedNode;

    public Connection(int componentId, int connectionId) {
        this.componentId = componentId;
        this.connectionId = connectionId;
        this.nodes = new ArrayList<Point>();
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    public Connection copy() {
        Connection copy = new Connection(this.componentId, this.connectionId);
        for (Point node : this.nodes) {
            copy.nodes.add(node.copy());
        }
        return copy;
    }

    public void addAndSelectNode(int mX, int mY, int id) {
        this.selectedNode = new Point(mX, mY);
        this.nodes.add(id, this.selectedNode);
    }

    @SideOnly(value=Side.CLIENT)
    public void update(int mX, int mY) {
        if (this.selectedNode != null) {
            this.selectedNode.setX(mX);
            this.selectedNode.setY(mY);
            if (GuiScreen.func_146272_n()) {
                this.selectedNode.adjustToGrid();
            }
        }
    }

    public void adjustAllToGrid() {
        for (Point node : this.nodes) {
            node.adjustToGrid();
        }
    }

    public List<Point> getNodes() {
        return this.nodes;
    }

    public Point getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Point selectedNode) {
        this.selectedNode = selectedNode;
    }
}

