/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.CommandExecutor;
import vswe.stevesfactory.components.ComponentMenuContainerScrap;
import vswe.stevesfactory.components.ComponentMenuCrafting;
import vswe.stevesfactory.components.CraftingSetting;
import vswe.stevesfactory.components.FuzzyMode;
import vswe.stevesfactory.components.IItemBufferElement;
import vswe.stevesfactory.components.IItemBufferSubElement;
import vswe.stevesfactory.components.ItemBufferElement;
import vswe.stevesfactory.components.SlotInventoryHolder;
import vswe.stevesfactory.components.SlotStackInventoryHolder;

public class CraftingBufferElement
implements IItemBufferElement,
IItemBufferSubElement {
    private static final ItemStack DUMMY_ITEM = new ItemStack(Item.func_150899_d((int)1), 0, 0);
    private CommandExecutor executor;
    private ComponentMenuCrafting craftingMenu;
    private ComponentMenuContainerScrap scrapMenu;
    private IRecipe recipe;
    private ItemStack result;
    private boolean isCrafting;
    private boolean justRemoved;
    private int overflowBuffer;
    private List<ItemStack> containerItems;
    private static final double SPEED_MULTIPLIER = (double)0.05f;
    private static final Random rand = new Random();
    private List<IInventory> inventories = new ArrayList<IInventory>();

    public CraftingBufferElement(CommandExecutor executor, ComponentMenuCrafting craftingMenu, ComponentMenuContainerScrap scrapMenu) {
        this.executor = executor;
        this.craftingMenu = craftingMenu;
        this.scrapMenu = scrapMenu;
        this.recipe = craftingMenu.getDummy().getRecipe();
        this.result = this.recipe == null ? null : this.recipe.func_77572_b((InventoryCrafting)craftingMenu.getDummy());
        this.containerItems = new ArrayList<ItemStack>();
    }

    @Override
    public void prepareSubElements() {
        this.isCrafting = true;
        this.justRemoved = false;
    }

    @Override
    public IItemBufferSubElement getSubElement() {
        if (this.isCrafting && this.result != null) {
            this.isCrafting = false;
            return this;
        }
        return null;
    }

    @Override
    public void removeSubElement() {
    }

    @Override
    public void releaseSubElements() {
        if (this.result != null) {
            if (this.overflowBuffer > 0) {
                ItemStack overflow = this.result.func_77946_l();
                overflow.field_77994_a = this.overflowBuffer;
                this.disposeOfExtraItem(overflow);
                this.overflowBuffer = 0;
            }
            for (ItemStack containerItem : this.containerItems) {
                this.disposeOfExtraItem(containerItem);
            }
            this.containerItems.clear();
        }
    }

    private void disposeOfExtraItem(ItemStack itemStack) {
        TileEntityManager manager = this.craftingMenu.getParent().getManager();
        List<SlotInventoryHolder> inventories = CommandExecutor.getContainers(manager, this.scrapMenu, ConnectionBlockType.INVENTORY);
        for (SlotInventoryHolder inventoryHolder : inventories) {
            IInventory inventory = inventoryHolder.getInventory();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemInSlot;
                if (!inventory.func_94041_b(i, itemStack) || (itemInSlot = inventory.func_70301_a(i)) != null && (!itemInSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemInSlot) || !itemStack.func_77985_e())) continue;
                int itemCountInSlot = itemInSlot == null ? 0 : itemInSlot.field_77994_a;
                int moveCount = Math.min(itemStack.field_77994_a, Math.min(inventory.func_70297_j_(), itemStack.func_77976_d()) - itemCountInSlot);
                if (moveCount <= 0) continue;
                if (itemInSlot == null) {
                    itemInSlot = itemStack.func_77946_l();
                    itemInSlot.field_77994_a = 0;
                    inventory.func_70299_a(i, itemInSlot);
                }
                itemInSlot.field_77994_a += moveCount;
                itemStack.field_77994_a -= moveCount;
                inventory.func_70296_d();
                if (itemStack.field_77994_a != 0) continue;
                return;
            }
        }
        double spawnX = (double)manager.func_174877_v().func_177958_n() + rand.nextDouble() * 0.8 + 0.1;
        double spawnY = (double)manager.func_174877_v().func_177956_o() + rand.nextDouble() * 0.3 + 1.1;
        double spawnZ = (double)manager.func_174877_v().func_177952_p() + rand.nextDouble() * 0.8 + 0.1;
        EntityItem entityitem = new EntityItem(manager.func_145831_w(), spawnX, spawnY, spawnZ, itemStack);
        entityitem.field_70159_w = rand.nextGaussian() * (double)0.05f;
        entityitem.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
        entityitem.field_70179_y = rand.nextGaussian() * (double)0.05f;
        manager.func_145831_w().func_72838_d((Entity)entityitem);
    }

    @Override
    public int retrieveItemCount(int moveCount) {
        return moveCount;
    }

    @Override
    public void decreaseStackSize(int moveCount) {
    }

    @Override
    public void remove() {
    }

    @Override
    public void onUpdate() {
        for (IInventory inventory : this.inventories) {
            inventory.func_70296_d();
        }
        this.inventories.clear();
    }

    @Override
    public int getSizeLeft() {
        if (!this.justRemoved) {
            return this.overflowBuffer > 0 ? this.overflowBuffer : (this.findItems(false) ? this.result.field_77994_a : 0);
        }
        this.justRemoved = false;
        return 0;
    }

    @Override
    public void reduceAmount(int amount) {
        this.justRemoved = true;
        if (this.overflowBuffer > 0) {
            this.overflowBuffer -= amount;
        } else {
            this.findItems(true);
            this.overflowBuffer = this.result.field_77994_a - amount;
        }
        this.isCrafting = true;
    }

    @Override
    public ItemStack getItemStack() {
        if (this.useAdvancedDetection()) {
            this.findItems(false);
        }
        return this.result;
    }

    private boolean useAdvancedDetection() {
        return this.craftingMenu.getResultItem().getFuzzyMode() != FuzzyMode.PRECISE;
    }

    private boolean findItems(boolean remove) {
        HashMap<Integer, ItemStack> foundItems = new HashMap<Integer, ItemStack>();
        for (ItemBufferElement itemBufferElement : this.executor.itemBuffer) {
            int count = itemBufferElement.retrieveItemCount(9);
            Iterator<SlotStackInventoryHolder> iterator = itemBufferElement.getSubElements().iterator();
            while (iterator.hasNext()) {
                IItemBufferSubElement itemBufferSubElement = iterator.next();
                ItemStack itemstack = itemBufferSubElement.getItemStack();
                int subCount = Math.min(count, itemBufferSubElement.getSizeLeft());
                for (int i = 0; i < 9; ++i) {
                    CraftingSetting setting = (CraftingSetting)this.craftingMenu.getSettings().get(i);
                    if (foundItems.get(i) != null) continue;
                    if (!setting.isValid()) {
                        foundItems.put(i, DUMMY_ITEM);
                        continue;
                    }
                    if (subCount <= 0 || !setting.isEqualForCommandExecutor(itemstack)) continue;
                    foundItems.put(i, itemstack.func_77946_l());
                    if (this.craftingMenu.getDummy().isItemValidForRecipe(this.recipe, this.craftingMenu.getResultItem(), foundItems, this.useAdvancedDetection())) {
                        --subCount;
                        --count;
                        if (!remove) continue;
                        if (itemstack.func_77973_b().hasContainerItem(itemstack)) {
                            this.containerItems.add(itemstack.func_77973_b().getContainerItem(itemstack));
                        }
                        itemBufferElement.decreaseStackSize(1);
                        itemBufferSubElement.reduceAmount(1);
                        if (itemBufferSubElement.getSizeLeft() == 0) {
                            itemBufferSubElement.remove();
                            iterator.remove();
                        }
                        this.inventories.add(((SlotStackInventoryHolder)itemBufferSubElement).getInventory());
                        continue;
                    }
                    foundItems.remove(i);
                }
            }
        }
        if (foundItems.size() == 9) {
            this.result = this.craftingMenu.getDummy().getResult(foundItems);
            this.result = this.result != null ? this.result.func_77946_l() : null;
            return true;
        }
        return false;
    }
}

