/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.components.RadioButton;
import vswe.stevesfactory.interfaces.GuiManager;

public abstract class RadioButtonList {
    private static final int RADIO_SIZE = 8;
    private static final int RADIO_SRC_X = 30;
    private static final int RADIO_SRC_Y = 52;
    private static final int RADIO_TEXT_X = 12;
    private static final int RADIO_TEXT_Y = 2;
    private List<RadioButton> radioButtonList = new ArrayList<RadioButton>();
    private int selectedOption;

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        for (int i = 0; i < this.radioButtonList.size(); ++i) {
            RadioButton radioButton = this.radioButtonList.get(i);
            if (!radioButton.isVisible()) continue;
            int srcRadioX = this.getSelectedOption() == i ? 1 : 0;
            int srcRadioY = CollisionHelper.inBounds(radioButton.getX(), radioButton.getY(), 8, 8, mX, mY) ? 1 : 0;
            gui.drawTexture(radioButton.getX(), radioButton.getY(), 30 + srcRadioX * 8, 52 + srcRadioY * 8, 8, 8);
            gui.drawString(radioButton.getText(), radioButton.getX() + 12, radioButton.getY() + 2, 0.7f, 0x404040);
        }
    }

    public void onClick(int mX, int mY, int button) {
        for (int i = 0; i < this.radioButtonList.size(); ++i) {
            RadioButton radioButton = this.radioButtonList.get(i);
            if (!radioButton.isVisible() || !CollisionHelper.inBounds(radioButton.getX(), radioButton.getY(), 8, 8, mX, mY) || this.getSelectedOption() == i) continue;
            this.updateSelectedOption(i);
            break;
        }
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(int selectedOption) {
        this.selectedOption = selectedOption;
    }

    public abstract void updateSelectedOption(int var1);

    public void add(RadioButton radioButton) {
        this.radioButtonList.add(radioButton);
    }

    public final int getRawSelectedOption() {
        return this.selectedOption;
    }

    public int size() {
        return this.radioButtonList.size();
    }
}

