/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.BlockCableCamouflages;
import vswe.stevesfactory.blocks.BlockCableCluster;
import vswe.stevesfactory.blocks.BlockCableOutput;
import vswe.stevesfactory.blocks.ClusterRegistry;
import vswe.stevesfactory.blocks.TileEntityCamouflage;
import vswe.stevesfactory.blocks.TileEntityCluster;
import vswe.stevesfactory.blocks.TileEntityOutput;

public class Provider
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntityCamouflage camouflage;
        TileEntity te = accessor.getTileEntity();
        if (te != null && !this.isShiftDown() && (camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, (IBlockAccess)te.func_145831_w(), te.func_174877_v())) != null) {
            Block block;
            int id = camouflage.getId(accessor.getSide().func_176745_a());
            int meta = camouflage.getMeta(accessor.getSide().func_176745_a());
            if (id != 0 && (block = Block.func_149729_e((int)id)) != null) {
                return new ItemStack(block, 1, block.func_180651_a(block.func_176203_a(meta)));
            }
        }
        return new ItemStack(accessor.getBlock(), 1, accessor.getBlock().func_180651_a(accessor.getBlock().func_176203_a(accessor.getMetadata())));
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> list, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        return list;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        TileEntity te;
        if (itemStack != null && itemStack.func_77973_b() == iWailaDataAccessor.getStack().func_77973_b() && (te = iWailaDataAccessor.getTileEntity()) != null) {
            if (te instanceof TileEntityCluster) {
                TileEntityCluster cluster = (TileEntityCluster)te;
                for (byte type : cluster.getTypes()) {
                    list.add(ClusterRegistry.getRegistryList().get(type).getItemStack().func_82833_r());
                }
            } else if (te instanceof TileEntityOutput) {
                TileEntityOutput emitter = (TileEntityOutput)te;
                if (this.isShiftDown()) {
                    for (EnumFacing side : EnumFacing.values()) {
                        list.add(this.getEmitterSide(emitter, side, true));
                    }
                } else {
                    list.add(this.getEmitterSide(emitter, iWailaDataAccessor.getSide(), false));
                }
            }
        }
        return list;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> list, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        return list;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isShiftDown() {
        return GuiScreen.func_146272_n();
    }

    private String getEmitterSide(TileEntityOutput emitter, EnumFacing side, boolean full) {
        String str = (emitter.hasStrongSignalAtSide(side) ? Localization.STRONG_POWER.toString() : Localization.WEAK_POWER.toString()) + ": " + emitter.getStrengthFromSide(side) + " ";
        if (full) {
            str = (Object)((Object)Localization.getDirectionLocalization(side)) + " " + str;
        }
        return str;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        Provider instance = new Provider();
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockCableCluster.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockCableOutput.class);
        registrar.registerStackProvider((IWailaDataProvider)instance, BlockCableCluster.class);
        registrar.registerStackProvider((IWailaDataProvider)instance, BlockCableCamouflages.class);
    }
}

