/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.ctm;

import mekanism.client.render.ctm.ISubmap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class Submap
implements ISubmap {
    private final float width;
    private final float height;
    private final float xOffset;
    private final float yOffset;
    private final SubmapNormalized normalized = new SubmapNormalized(this);
    private static final float FACTOR = 16.0f;

    public Submap(float w, float h, float x, float y) {
        this.width = w;
        this.height = h;
        this.xOffset = x;
        this.yOffset = y;
    }

    @Override
    public float getXOffset() {
        return this.xOffset;
    }

    @Override
    public float getYOffset() {
        return this.yOffset;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
        return sprite.func_94214_a((double)(this.getXOffset() + u / this.getWidth()));
    }

    @Override
    public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
        return sprite.func_94207_b((double)(this.getYOffset() + v / this.getWidth()));
    }

    @Override
    public float[] toArray() {
        return new float[]{this.getXOffset(), this.getYOffset(), this.getXOffset() + this.getWidth(), this.getYOffset() + this.getHeight()};
    }

    @Override
    public SubmapNormalized normalize() {
        return this.normalized;
    }

    @Override
    public ISubmap relativize() {
        return this;
    }

    private static class SubmapNormalized
    implements ISubmap {
        private final ISubmap parent;

        public SubmapNormalized(ISubmap submap) {
            this.parent = submap;
        }

        @Override
        public float getXOffset() {
            return this.parent.getXOffset() / 16.0f;
        }

        @Override
        public float getYOffset() {
            return this.parent.getYOffset() / 16.0f;
        }

        @Override
        public float getWidth() {
            return this.parent.getWidth() / 16.0f;
        }

        @Override
        public float getHeight() {
            return this.parent.getHeight() / 16.0f;
        }

        @Override
        public ISubmap relativize() {
            return this.parent;
        }

        @Override
        public ISubmap normalize() {
            return this;
        }

        @Override
        public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
            return this.parent.getInterpolatedU(sprite, u);
        }

        @Override
        public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
            return this.parent.getInterpolatedV(sprite, v);
        }

        @Override
        public float[] toArray() {
            return this.parent.toArray();
        }
    }
}

