/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockBasic
extends ItemBlock
implements IEnergizedItem,
ITierItem {
    public Block metaBlock;

    public ItemBlockBasic(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
    }

    public int getItemStackLimit(ItemStack stack) {
        if (BlockStateBasic.BasicBlockType.get(stack) == BlockStateBasic.BasicBlockType.BIN) {
            return new InventoryBin(stack).getItemCount() == 0 ? super.getItemStackLimit(stack) : 1;
        }
        return super.getItemStackLimit(stack);
    }

    public ItemStack getUnchargedCell(Tier.InductionCellTier tier) {
        ItemStack stack = new ItemStack(MekanismBlocks.BasicBlock2, 1, 3);
        this.setBaseTier(stack, tier.getBaseTier());
        return stack;
    }

    public ItemStack getUnchargedProvider(Tier.InductionProviderTier tier) {
        ItemStack stack = new ItemStack(MekanismBlocks.BasicBlock2, 1, 4);
        this.setBaseTier(stack, tier.getBaseTier());
        return stack;
    }

    @Override
    public Tier.BaseTier getBaseTier(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return Tier.BaseTier.BASIC;
        }
        return Tier.BaseTier.values()[itemstack.func_77978_p().func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, Tier.BaseTier tier) {
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("tier", tier.ordinal());
    }

    public int func_77647_b(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(itemstack);
        if (type.hasDescription) {
            if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
                if (type == BlockStateBasic.BasicBlockType.BIN) {
                    InventoryBin inv = new InventoryBin(itemstack);
                    if (inv.getItemCount() > 0) {
                        list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + inv.getItemType().func_82833_r());
                        String amountStr = inv.getItemCount() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : "" + inv.getItemCount();
                        list.add((Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.itemAmount") + ": " + (Object)((Object)EnumColor.GREY) + amountStr);
                    } else {
                        list.add((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.empty"));
                    }
                    int cap = Tier.BinTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].storage;
                    list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + (cap == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(cap)) + " " + LangUtils.localize("transmission.Items"));
                } else if (type == BlockStateBasic.BasicBlockType.INDUCTION_CELL) {
                    Tier.InductionCellTier tier = Tier.InductionCellTier.values()[this.getBaseTier(itemstack).ordinal()];
                    list.add((Object)((Object)tier.getBaseTier().getColor()) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(tier.maxEnergy));
                } else if (type == BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER) {
                    Tier.InductionProviderTier tier = Tier.InductionProviderTier.values()[this.getBaseTier(itemstack).ordinal()];
                    list.add((Object)((Object)tier.getBaseTier().getColor()) + LangUtils.localize("tooltip.outputRate") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(tier.output));
                }
                if (this.getMaxEnergy(itemstack) > 0.0) {
                    list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
                }
                list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.INDIGO) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
            } else {
                list.addAll(MekanismUtils.splitTooltip(type.getDescription(), itemstack));
            }
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return BlockStateBasic.BasicBlockType.get(stack) == BlockStateBasic.BasicBlockType.BIN && ItemDataUtils.hasData(stack, "newCount");
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (BlockStateBasic.BasicBlockType.get(stack) == BlockStateBasic.BasicBlockType.BIN) {
            if (!ItemDataUtils.hasData(stack, "newCount")) {
                return null;
            }
            int newCount = ItemDataUtils.getInt(stack, "newCount");
            ItemDataUtils.removeData(stack, "newCount");
            ItemStack ret = stack.func_77946_l();
            ItemDataUtils.setInt(ret, "itemCount", newCount);
            return ret;
        }
        return null;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        boolean place = true;
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(stack);
        if (!(type != BlockStateBasic.BasicBlockType.SECURITY_DESK || pos.func_177956_o() + 1 <= 255 && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a()))) {
            place = false;
        }
        if (place && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state)) {
            TileEntityBasicBlock tileEntity;
            if (type == BlockStateBasic.BasicBlockType.BIN && stack.func_77978_p() != null) {
                tileEntity = (TileEntityBin)world.func_175625_s(pos);
                InventoryBin inv = new InventoryBin(stack);
                ((TileEntityBin)tileEntity).tier = Tier.BinTier.values()[this.getBaseTier(stack).ordinal()];
                if (inv.getItemType() != null) {
                    ((TileEntityBin)tileEntity).setItemType(inv.getItemType());
                }
                ((TileEntityBin)tileEntity).setItemCount(inv.getItemCount());
            } else if (type == BlockStateBasic.BasicBlockType.INDUCTION_CELL) {
                tileEntity = (TileEntityInductionCell)world.func_175625_s(pos);
                ((TileEntityInductionCell)tileEntity).tier = Tier.InductionCellTier.values()[this.getBaseTier(stack).ordinal()];
                if (!world.field_72995_K) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), ((TileEntityInductionCell)tileEntity).getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(tileEntity)));
                }
            } else if (type == BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER) {
                tileEntity = (TileEntityInductionProvider)world.func_175625_s(pos);
                ((TileEntityInductionProvider)tileEntity).tier = Tier.InductionProviderTier.values()[this.getBaseTier(stack).ordinal()];
                if (!world.field_72995_K) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), ((TileEntityInductionProvider)tileEntity).getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(tileEntity)));
                }
            }
            tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IStrictEnergyStorage && !(tileEntity instanceof TileEntityMultiblock)) {
                ((IStrictEnergyStorage)((Object)tileEntity)).setEnergy(this.getEnergy(stack));
            }
        }
        return place;
    }

    public String func_77667_c(ItemStack itemstack) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(itemstack);
        if (type != null) {
            String name = this.func_77658_a() + "." + BlockStateBasic.BasicBlockType.get((ItemStack)itemstack).name;
            if (type == BlockStateBasic.BasicBlockType.BIN || type == BlockStateBasic.BasicBlockType.INDUCTION_CELL || type == BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER) {
                name = name + this.getBaseTier(itemstack).getSimpleName();
            }
            return name;
        }
        return "null";
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (BlockStateBasic.BasicBlockType.get(itemStack) == BlockStateBasic.BasicBlockType.INDUCTION_CELL) {
            return ItemDataUtils.getDouble(itemStack, "energyStored");
        }
        return 0.0;
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (BlockStateBasic.BasicBlockType.get(itemStack) == BlockStateBasic.BasicBlockType.INDUCTION_CELL) {
            ItemDataUtils.setDouble(itemStack, "energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
        }
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        if (BlockStateBasic.BasicBlockType.get(itemStack) == BlockStateBasic.BasicBlockType.INDUCTION_CELL) {
            return Tier.InductionCellTier.values()[this.getBaseTier((ItemStack)itemStack).ordinal()].maxEnergy;
        }
        return 0.0;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }
}

