/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemEnergized;
import mekanism.common.security.IOwnerItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemPortableTeleporter
extends ItemEnergized
implements IOwnerItem {
    public ItemPortableTeleporter() {
        super(1000000.0);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(SecurityUtils.getOwnerDisplay(entityplayer.func_70005_c_(), this.getOwner(itemstack)));
        if (this.getFrequency(itemstack) != null) {
            list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("gui.frequency") + ": " + (Object)((Object)EnumColor.GREY) + this.getFrequency(itemstack));
            list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("gui.mode") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui." + (this.isPrivateMode(itemstack) ? "private" : "public")));
        }
        super.func_77624_a(itemstack, entityplayer, list, flag);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer, EnumHand hand) {
        if (!world.field_72995_K) {
            if (this.getOwner(itemstack) == null) {
                this.setOwner(itemstack, entityplayer.func_70005_c_());
                entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.nowOwn")));
            } else if (SecurityUtils.canAccess(entityplayer, itemstack)) {
                entityplayer.openGui((Object)Mekanism.instance, 14, world, hand.ordinal(), 0, 0);
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public static double calculateEnergyCost(Entity entity, Coord4D coords) {
        if (coords == null) {
            return 0.0;
        }
        int neededEnergy = 1000;
        if (entity.field_70170_p.field_73011_w.getDimension() != coords.dimensionId) {
            neededEnergy += 10000;
        }
        int distance = (int)entity.func_70011_f((double)coords.xCoord, (double)coords.yCoord, (double)coords.zCoord);
        return neededEnergy += distance * 10;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public String getOwner(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "owner")) {
            return ItemDataUtils.getString(stack, "owner");
        }
        return null;
    }

    @Override
    public void setOwner(ItemStack stack, String owner) {
        this.setFrequency(stack, null);
        this.setPrivateMode(stack, false);
        if (owner == null || owner.isEmpty()) {
            ItemDataUtils.removeData(stack, "owner");
            return;
        }
        ItemDataUtils.setString(stack, "owner", owner);
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return true;
    }

    public boolean isPrivateMode(ItemStack stack) {
        return ItemDataUtils.getBoolean(stack, "private");
    }

    public void setPrivateMode(ItemStack stack, boolean isPrivate) {
        ItemDataUtils.setBoolean(stack, "private", isPrivate);
    }

    public String getFrequency(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "frequency")) {
            return ItemDataUtils.getString(stack, "frequency");
        }
        return null;
    }

    public void setFrequency(ItemStack stack, String frequency) {
        if (frequency == null || frequency.isEmpty()) {
            ItemDataUtils.removeData(stack, "frequency");
            return;
        }
        ItemDataUtils.setString(stack, "frequency", frequency);
    }
}

