/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Map;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasItem;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileEntityPurificationChamber
extends TileEntityAdvancedElectricMachine<PurificationRecipe> {
    public TileEntityPurificationChamber() {
        super("purification", "PurificationChamber", MekanismConfig.usage.purificationChamberUsage, 1, 200, BlockStateMachine.MachineType.PURIFICATION_CHAMBER.baseEnergy);
    }

    @Override
    public Map getRecipes() {
        return RecipeHandler.Recipe.PURIFICATION_CHAMBER.get();
    }

    @Override
    public GasStack getItemGas(ItemStack itemstack) {
        if (itemstack.func_77969_a(new ItemStack(Items.field_151145_ak))) {
            return new GasStack(GasRegistry.getGas("oxygen"), 10);
        }
        if (Block.func_149634_a((Item)itemstack.func_77973_b()) == MekanismBlocks.GasTank && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas() == GasRegistry.getGas("oxygen")) {
            return new GasStack(GasRegistry.getGas("oxygen"), 1);
        }
        return null;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (stack.getGas() == GasRegistry.getGas("oxygen")) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return type == GasRegistry.getGas("oxygen");
    }

    @Override
    public void handleSecondaryFuel() {
        if (this.inventory[1] != null && this.gasTank.getNeeded() > 0 && this.inventory[1].func_77973_b() instanceof IGasItem) {
            GasStack removed = GasTransmission.removeGas(this.inventory[1], GasRegistry.getGas("oxygen"), this.gasTank.getNeeded());
            this.gasTank.receive(removed, true);
            return;
        }
        super.handleSecondaryFuel();
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return true;
    }

    @Override
    public boolean isValidGas(Gas gas) {
        return gas == GasRegistry.getGas("oxygen");
    }

    @Override
    public boolean upgradeableSecondaryEfficiency() {
        return true;
    }

    @Override
    public boolean useStatisticalMechanics() {
        return true;
    }
}

