/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.uv;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.uv.UV;
import codechicken.lib.render.uv.UVTransformation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class UVRotation
extends UVTransformation {
    public double angle;

    public UVRotation(double angle) {
        this.angle = angle;
    }

    public void apply(UV uv) {
        double c = MathHelper.cos(this.angle);
        double s = MathHelper.sin(this.angle);
        double u2 = c * uv.u + s * uv.v;
        uv.v = -s * uv.u + c * uv.v;
        uv.u = u2;
    }

    public UVTransformation inverse() {
        return new UVRotation(-this.angle);
    }

    public UVTransformation merge(UVTransformation next) {
        if (next instanceof UVRotation) {
            return new UVRotation(this.angle + ((UVRotation)next).angle);
        }
        return null;
    }

    public boolean isRedundant() {
        return MathHelper.between(-1.0E-5, this.angle, 1.0E-5);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "UVRotation(" + new BigDecimal(this.angle, cont) + ")";
    }
}

