/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import com.google.common.base.Objects;
import net.minecraft.client.renderer.GlStateManager;

public class GlStateManagerHelper {
    private static String parseBoolState(GlStateManager.BooleanState boolState) {
        return String.valueOf(boolState.field_179201_b).toUpperCase();
    }

    public static String dumpGLState(State ... states) {
        StringBuilder builder = new StringBuilder();
        builder.append("GlStateManager { ");
        for (int i = 0; i < states.length; ++i) {
            State state = states[i];
            builder.append(state.getState());
            if (i == states.length - 1) continue;
            builder.append(", ");
        }
        builder.append(" }");
        return builder.toString();
    }

    public static enum State {
        GL_ALPHA_TEST{

            @Override
            public String getState() {
                GlStateManager.AlphaState alphaState = GlStateManager.field_179160_a;
                return Objects.toStringHelper((String)this.name()).add("Func", alphaState.field_179206_b).add("Ref", alphaState.field_179207_c).add("Enabled", (Object)String.valueOf(alphaState.field_179208_a.field_179201_b).toUpperCase()).toString();
            }
        }
        ,
        GL_LIGHTING{

            @Override
            public String getState() {
                return Objects.toStringHelper((String)this.name()).add("Enabled", (Object)GlStateManagerHelper.parseBoolState(GlStateManager.field_179158_b)).toString();
            }
        }
        ,
        GL_BLEND{

            @Override
            public String getState() {
                GlStateManager.BlendState blendState = GlStateManager.field_179157_e;
                return Objects.toStringHelper((String)this.name()).add("SrcFactor", (Object)this.parseFactor(blendState.field_179211_b)).add("DstFactor", (Object)this.parseFactor(blendState.field_179212_c)).add("SrcFactorAlpha", (Object)this.parseFactor(blendState.field_179209_d)).add("DstFactorAlpha", (Object)this.parseFactor(blendState.field_179210_e)).add("Enabled", (Object)GlStateManagerHelper.parseBoolState(blendState.field_179213_a)).toString();
            }

            private String parseFactor(int factor) {
                switch (factor) {
                    case 32771: {
                        return "CONSTANT_ALPHA";
                    }
                    case 32769: {
                        return "CONSTANT_COLOR";
                    }
                    case 772: {
                        return "DST_ALPHA";
                    }
                    case 774: {
                        return "DST_COLOR";
                    }
                    case 1: {
                        return "ONE";
                    }
                    case 32772: {
                        return "ONE_MINUS_CONSTANT_ALPHA";
                    }
                    case 32770: {
                        return "ONE_MINUS_CONSTANT_COLOR";
                    }
                    case 773: {
                        return "ONE_MINUS_DST_ALPHA";
                    }
                    case 775: {
                        return "ONE_MINUS_DST_COLOR";
                    }
                    case 771: {
                        return "ONE_MINUS_SRC_ALPHA";
                    }
                    case 769: {
                        return "ONE_MINUS_SRC_COLOR";
                    }
                    case 770: {
                        return "SRC_ALPHA";
                    }
                    case 776: {
                        return "SRC_ALPHA_SATURATE";
                    }
                    case 768: {
                        return "SRC_COLOR";
                    }
                    case 0: {
                        return "ZERO";
                    }
                }
                return "UNKNOWN:" + factor;
            }
        }
        ,
        GL_DEPTH_TEST{

            @Override
            public String getState() {
                GlStateManager.DepthState depthState = GlStateManager.field_179154_f;
                return Objects.toStringHelper((String)this.name()).add("Func", (Object)this.parseFunc(depthState.field_179051_c)).add("Mask", (Object)String.valueOf(depthState.field_179050_b).toUpperCase()).add("Enabled", (Object)GlStateManagerHelper.parseBoolState(depthState.field_179052_a)).toString();
            }

            private String parseFunc(int func) {
                switch (func) {
                    case 512: {
                        return "GL_NEVER";
                    }
                    case 513: {
                        return "GL_LESS";
                    }
                    case 514: {
                        return "GL_EQUAL";
                    }
                    case 515: {
                        return "GL_LEQUAL";
                    }
                    case 516: {
                        return "GL_GREATER";
                    }
                    case 517: {
                        return "GL_NOTEQUAL";
                    }
                    case 518: {
                        return "GL_GEQUAL";
                    }
                    case 519: {
                        return "GL_ALWAYS";
                    }
                }
                return "UNKNOWN:" + func;
            }
        }
        ,
        GL_CULL_FACE{

            @Override
            public String getState() {
                GlStateManager.CullState cullState = GlStateManager.field_179167_h;
                return Objects.toStringHelper((String)this.name()).add("Mode", (Object)this.parseMode(cullState.field_179053_b)).add("Enabled", (Object)GlStateManagerHelper.parseBoolState(cullState.field_179054_a)).toString();
            }

            private String parseMode(int mode) {
                switch (mode) {
                    case 1028: {
                        return "FRONT";
                    }
                    case 1029: {
                        return "BACK";
                    }
                    case 1032: {
                        return "FRONT_AND_BACK";
                    }
                }
                return "UNKNOWN:" + mode;
            }
        }
        ,
        GL_RESCALE_NORMAL{

            @Override
            public String getState() {
                return Objects.toStringHelper((String)this.name()).add("Enabled", (Object)GlStateManagerHelper.parseBoolState(GlStateManager.field_179172_r)).toString();
            }
        };


        public abstract String getState();
    }
}

