/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemNBTUtils {
    public static boolean hasTag(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static void setTag(ItemStack stack, NBTTagCompound tagCompound) {
        stack.func_77982_d(tagCompound);
    }

    public static NBTTagCompound getTag(ItemStack stack) {
        return stack.func_77978_p();
    }

    public static NBTTagCompound validateTagExists(ItemStack stack) {
        if (!ItemNBTUtils.hasTag(stack)) {
            ItemNBTUtils.setTag(stack, new NBTTagCompound());
        }
        return ItemNBTUtils.getTag(stack);
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return ItemNBTUtils.hasTag(stack) && ItemNBTUtils.getTag(stack).func_74764_b(key);
    }

    public static boolean hasKey(ItemStack stack, String key, int nbtType) {
        return ItemNBTUtils.hasTag(stack) && ItemNBTUtils.getTag(stack).func_150297_b(key, nbtType);
    }

    public static void removeTag(ItemStack stack, String key) {
        if (ItemNBTUtils.hasTag(stack)) {
            ItemNBTUtils.getTag(stack).func_82580_o(key);
        }
    }

    public static void setByte(ItemStack stack, String key, byte b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74774_a(key, b);
    }

    public static void setShort(ItemStack stack, String key, short s) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74777_a(key, s);
    }

    public static void setInteger(ItemStack stack, String key, int i) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74768_a(key, i);
    }

    public static void setLong(ItemStack stack, String key, long l) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74772_a(key, l);
    }

    public static void setUUID(ItemStack stack, String key, UUID uuid) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_186854_a(key, uuid);
    }

    public static void setFloat(ItemStack stack, String key, float f) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74776_a(key, f);
    }

    public static void setDouble(ItemStack stack, String key, double d) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74780_a(key, d);
    }

    public static void setString(ItemStack stack, String key, String s) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74778_a(key, s);
    }

    public static void setByteArray(ItemStack stack, String key, byte[] b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74773_a(key, b);
    }

    public static void setIntArray(ItemStack stack, String key, int[] i) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74783_a(key, i);
    }

    public static void setBoolean(ItemStack stack, String key, boolean b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74757_a(key, b);
    }

    public static byte getByte(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74771_c(key);
    }

    public static short getShort(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74765_d(key);
    }

    public static int getInteger(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74762_e(key);
    }

    public static long getLong(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74763_f(key);
    }

    public static UUID getUUID(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_186857_a(key);
    }

    public static float getFloat(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74760_g(key);
    }

    public static double getDouble(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74769_h(key);
    }

    public static String getString(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74779_i(key);
    }

    public static byte[] getByteArray(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74770_j(key);
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74759_k(key);
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74767_n(key);
    }

    public static NBTTagCompound getCompoundTag(ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74775_l(key);
    }

    public static NBTTagList getTagList(ItemStack stack, String key, int type) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_150295_c(key, type);
    }
}

