/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.IConfigurable;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Tier;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITankManager;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityFluidTank
extends TileEntityContainerBlock
implements IActiveState,
IConfigurable,
IFluidHandlerWrapper,
ISustainedTank,
IFluidContainerManager,
ITankManager,
ISecurityTile,
ITierUpgradeable {
    public boolean isActive;
    public boolean clientActive;
    public FluidTank fluidTank;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;
    public Tier.FluidTankTier tier = Tier.FluidTankTier.BASIC;
    public int updateDelay;
    public int prevAmount;
    public int valve;
    public Fluid valveFluid;
    public float prevScale;
    public boolean needsPacket;
    public int currentRedstoneLevel;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityFluidTank() {
        super("FluidTank");
        this.fluidTank = new FluidTank(this.tier.storage);
        this.inventory = new ItemStack[2];
    }

    @Override
    public boolean upgrade(Tier.BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = Tier.FluidTankTier.values()[upgradeTier.ordinal()];
        this.fluidTank.setCapacity(this.tier.storage);
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
        this.func_70296_d();
        return true;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            float targetScale;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
            if ((double)Math.abs(this.prevScale - (targetScale = (float)(this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0) / (float)this.fluidTank.getCapacity())) > 0.01) {
                this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
            }
        } else {
            int newRedstoneLevel;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.needsPacket = true;
                }
            }
            if (this.valve > 0) {
                --this.valve;
                if (this.valve == 0) {
                    this.valveFluid = null;
                    this.needsPacket = true;
                }
            }
            if (this.fluidTank.getFluidAmount() != this.prevAmount) {
                MekanismUtils.saveChunk(this);
                this.needsPacket = true;
            }
            this.prevAmount = this.fluidTank.getFluidAmount();
            if (this.inventory[0] != null) {
                this.manageInventory();
            }
            if (this.isActive) {
                this.activeEmit();
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.func_70296_d();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
            if (this.needsPacket) {
                Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), Coord4D.get(this).getTargetPoint(50.0));
            }
            this.needsPacket = false;
        }
    }

    @Override
    public String func_70005_c_() {
        return LangUtils.localize("tile.FluidTank" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    private void activeEmit() {
        TileEntity tileEntity;
        if (this.fluidTank.getFluid() != null && (tileEntity = Coord4D.get(this).offset(EnumFacing.DOWN).getTileEntity((IBlockAccess)this.field_145850_b)) != null && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IFluidHandler handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            FluidStack toDrain = new FluidStack(this.fluidTank.getFluid(), Math.min(this.tier.output, this.fluidTank.getFluidAmount()));
            this.fluidTank.drain(handler.fill(toDrain, true), this.tier != Tier.FluidTankTier.CREATIVE);
        }
    }

    private void manageInventory() {
        if (FluidContainerUtils.isFluidContainer(this.inventory[0])) {
            FluidStack ret = FluidContainerUtils.handleContainerItem(this, this.inventory, this.editMode, this.fluidTank.getFluid(), this.getCurrentNeeded(), 0, 1, null);
            if (ret != null) {
                this.fluidTank.setFluid(PipeUtils.copy(ret, Math.min(this.fluidTank.getCapacity(), ret.amount)));
                if (this.tier == Tier.FluidTankTier.CREATIVE) {
                    this.fluidTank.getFluid().amount = Integer.MAX_VALUE;
                } else {
                    int rejects = Math.max(0, ret.amount - this.fluidTank.getCapacity());
                    if (rejects > 0) {
                        this.pushUp(PipeUtils.copy(ret, rejects), true);
                    }
                }
            } else if (this.tier != Tier.FluidTankTier.CREATIVE) {
                this.fluidTank.setFluid(null);
            }
        }
    }

    public int pushUp(FluidStack fluid, boolean doFill) {
        IFluidHandler handler;
        Coord4D up = Coord4D.get(this).offset(EnumFacing.UP);
        if (up.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityFluidTank && PipeUtils.canFill(handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)up.getTileEntity((IBlockAccess)this.field_145850_b), CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN), fluid)) {
            return handler.fill(fluid, doFill);
        }
        return 0;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 1;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && FluidContainerUtils.isFluidContainer(itemstack);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        if (side == EnumFacing.UP) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("editMode", this.editMode.ordinal());
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = Tier.FluidTankTier.values()[nbtTags.func_74762_e("tier")];
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.editMode = FluidContainerUtils.ContainerEditMode.values()[nbtTags.func_74762_e("editMode")];
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.setCapacity(this.tier.storage);
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Tier.FluidTankTier prevTier = this.tier;
            this.tier = Tier.FluidTankTier.values()[dataStream.readInt()];
            this.fluidTank.setCapacity(this.tier.storage);
            this.clientActive = dataStream.readBoolean();
            this.valve = dataStream.readInt();
            this.editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
            this.valveFluid = this.valve > 0 ? FluidRegistry.getFluid((String)PacketHandler.readString(dataStream)) : null;
            if (dataStream.readInt() == 1) {
                this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((String)PacketHandler.readString(dataStream)), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
            if (prevTier != this.tier || this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    public int getRedstoneLevel() {
        double fractionFull = (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    public int getCurrentNeeded() {
        int needed = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (this.tier == Tier.FluidTankTier.CREATIVE) {
            return Integer.MAX_VALUE;
        }
        Coord4D top = Coord4D.get(this).offset(EnumFacing.UP);
        TileEntity topTile = top.getTileEntity((IBlockAccess)this.field_145850_b);
        if (topTile instanceof TileEntityFluidTank) {
            TileEntityFluidTank topTank = (TileEntityFluidTank)topTile;
            if (this.fluidTank.getFluid() != null && topTank.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() != topTank.fluidTank.getFluid().getFluid()) {
                return needed;
            }
            needed += topTank.getCurrentNeeded();
        }
        return needed;
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        data.add(this.isActive);
        data.add(this.valve);
        data.add(this.editMode.ordinal());
        if (this.valve > 0) {
            data.add(FluidRegistry.getFluidName((Fluid)this.valveFluid));
        }
        if (this.fluidTank.getFluid() != null) {
            data.add(1);
            data.add(FluidRegistry.getFluidName((FluidStack)this.fluidTank.getFluid()));
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(0);
        }
        return data;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K) {
            this.setActive(!this.getActive());
            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.tier == Tier.FluidTankTier.CREATIVE) {
            return resource != null ? resource.amount : 0;
        }
        if (resource != null && this.canFill(from, resource.getFluid())) {
            int filled = this.fluidTank.fill(resource, doFill);
            if (filled < resource.amount && !this.isActive) {
                filled += this.pushUp(PipeUtils.copy(resource, resource.amount - filled), doFill);
            }
            if (filled > 0 && from == EnumFacing.UP) {
                if (this.valve == 0) {
                    this.needsPacket = true;
                }
                this.valve = 20;
                this.valveFluid = resource.getFluid();
            }
            return filled;
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource != null && this.canDrain(from, resource.getFluid())) {
            return this.fluidTank.drain(resource.amount, this.tier != Tier.FluidTankTier.CREATIVE);
        }
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.fluidTank.drain(maxDrain, this.tier != Tier.FluidTankTier.CREATIVE);
        }
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == EnumFacing.DOWN && this.field_145850_b != null && this.func_174877_v() != null) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.DOWN));
            if (this.isActive && !(tile instanceof TileEntityFluidTank)) {
                return false;
            }
        }
        if (this.tier == Tier.FluidTankTier.CREATIVE) {
            return true;
        }
        return this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid() == fluid;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (this.fluidTank != null && (fluid == null || this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == fluid)) {
            return !this.isActive || from != EnumFacing.DOWN;
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        return this.editMode;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        this.editMode = mode;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

