/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.lighting;

import codechicken.lib.lighting.PlanarLightModel;
import codechicken.lib.render.CCRenderState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PlanarLightMatrix
extends PlanarLightModel {
    public static final int operationIndex = CCRenderState.registerOperation();
    public static PlanarLightMatrix instance = new PlanarLightMatrix();
    public IBlockAccess access;
    public BlockPos pos = BlockPos.field_177992_a;
    private int sampled = 0;
    public int[] brightness = new int[6];

    public PlanarLightMatrix() {
        super(PlanarLightModel.standardLightModel.colours);
    }

    public PlanarLightMatrix locate(IBlockAccess a, BlockPos bPos) {
        this.access = a;
        this.pos = bPos;
        this.sampled = 0;
        return this;
    }

    public int brightness(int side) {
        if ((this.sampled & 1 << side) == 0) {
            IBlockState b = this.access.func_180495_p(this.pos);
            this.brightness[side] = this.access.func_175626_b(this.pos, b.func_177230_c().getLightValue(b, this.access, this.pos));
            this.sampled |= 1 << side;
        }
        return this.brightness[side];
    }

    @Override
    public boolean load(CCRenderState state) {
        state.pipeline.addDependency(state.sideAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState state) {
        super.operate(state);
        state.brightness = this.brightness(state.side);
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

