/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.uv;

import codechicken.lib.render.uv.UV;
import codechicken.lib.render.uv.UVTransformation;
import codechicken.lib.vec.ITransformation;
import java.util.ArrayList;
import java.util.Iterator;

public class UVTransformationList
extends UVTransformation {
    private ArrayList<UVTransformation> transformations = new ArrayList();

    public UVTransformationList(UVTransformation ... transforms) {
        for (UVTransformation t : transforms) {
            if (t instanceof UVTransformationList) {
                this.transformations.addAll(((UVTransformationList)t).transformations);
                continue;
            }
            this.transformations.add(t);
        }
        this.compact();
    }

    public void apply(UV uv) {
        for (int i = 0; i < this.transformations.size(); ++i) {
            this.transformations.get(i).apply((Object)uv);
        }
    }

    public UVTransformationList with(UVTransformation t) {
        if (t.isRedundant()) {
            return this;
        }
        if (t instanceof UVTransformationList) {
            this.transformations.addAll(((UVTransformationList)t).transformations);
        } else {
            this.transformations.add(t);
        }
        this.compact();
        return this;
    }

    public UVTransformationList prepend(UVTransformation t) {
        if (t.isRedundant()) {
            return this;
        }
        if (t instanceof UVTransformationList) {
            this.transformations.addAll(0, ((UVTransformationList)t).transformations);
        } else {
            this.transformations.add(0, t);
        }
        this.compact();
        return this;
    }

    private void compact() {
        ArrayList<UVTransformation> newList = new ArrayList<UVTransformation>(this.transformations.size());
        Iterator<UVTransformation> iterator = this.transformations.iterator();
        UVTransformation prev = null;
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (t.isRedundant()) continue;
            if (prev != null) {
                UVTransformation m = (UVTransformation)prev.merge((ITransformation)t);
                if (m == null) {
                    newList.add(prev);
                } else {
                    t = m.isRedundant() ? null : m;
                }
            }
            prev = t;
        }
        if (prev != null) {
            newList.add(prev);
        }
        if (newList.size() < this.transformations.size()) {
            this.transformations = newList;
        }
    }

    public boolean isRedundant() {
        return this.transformations.size() == 0;
    }

    public UVTransformation inverse() {
        UVTransformationList rev = new UVTransformationList(new UVTransformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            rev.with((UVTransformation)this.transformations.get(i).inverse());
        }
        return rev;
    }

    public String toString() {
        String s = "";
        for (UVTransformation t : this.transformations) {
            s = s + "\n" + t.toString();
        }
        return s.trim();
    }
}

