/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.vec.uv;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.util.TripleABC;
import codechicken.lib.vec.IrreversibleTransformationException;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class IconVertexRangeUVTransform
extends UVTransformation {
    private final ImmutableList<TripleABC<Integer, Integer, TextureAtlasSprite>> transformMap;

    private IconVertexRangeUVTransform(List<TripleABC<Integer, Integer, TextureAtlasSprite>> transformMap) {
        this.transformMap = ImmutableList.copyOf(transformMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void operate(CCRenderState state) {
        UV uv = state.vert.uv;
        int index = state.vertexIndex;
        TextureAtlasSprite sprite = this.getSpriteForVertexIndex(index);
        if (sprite == null) {
            return;
        }
        uv.u = sprite.func_94214_a(uv.u * 16.0);
        uv.v = sprite.func_94207_b(uv.v * 16.0);
        state.sprite = this.getSpriteForVertexIndex(state.vertexIndex);
    }

    @Override
    public void apply(UV uv) {
    }

    @Override
    public UVTransformation inverse() {
        throw new IrreversibleTransformationException(this);
    }

    public TextureAtlasSprite getSpriteForVertexIndex(int index) {
        for (TripleABC entry : this.transformMap) {
            if (!MathHelper.between(((Integer)entry.getA()).intValue(), index, ((Integer)entry.getB()).intValue())) continue;
            return (TextureAtlasSprite)entry.getC();
        }
        return null;
    }

    public static class Builder {
        private LinkedList<TripleABC<Integer, Integer, TextureAtlasSprite>> transformMap = new LinkedList();

        private Builder() {
        }

        public IconVertexRangeUVTransform build() {
            return new IconVertexRangeUVTransform(this.transformMap);
        }

        public Builder addTransform(int start, int end, TextureAtlasSprite sprite) {
            for (TripleABC tripleABC : this.transformMap) {
                if (!MathHelper.between(((Integer)tripleABC.getA()).intValue(), start, ((Integer)tripleABC.getB()).intValue()) && !MathHelper.between(((Integer)tripleABC.getA()).intValue(), end, ((Integer)tripleABC.getB()).intValue())) continue;
                throw new IllegalArgumentException("Unable to have overlapping sprite transforms!");
            }
            this.transformMap.add(new TripleABC<Integer, Integer, TextureAtlasSprite>(start, end, sprite));
            return this;
        }
    }
}

