/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;

public class GasNetwork
extends DynamicNetwork<IGasHandler, GasNetwork> {
    public int transferDelay = 0;
    public boolean didTransfer;
    public boolean prevTransfer;
    public float gasScale;
    public Gas refGas;
    public GasStack buffer;
    public int prevStored;
    public int prevTransferAmount = 0;

    public GasNetwork() {
    }

    public GasNetwork(Collection<GasNetwork> networks) {
        for (GasNetwork net : networks) {
            if (net == null) continue;
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                if (net.refGas != null && net.gasScale > this.gasScale) {
                    this.gasScale = net.gasScale;
                    this.refGas = net.refGas;
                    this.buffer = net.buffer;
                    net.gasScale = 0.0f;
                    net.refGas = null;
                    net.buffer = null;
                }
            } else if (net.buffer != null) {
                if (this.buffer == null) {
                    this.buffer = net.buffer.copy();
                } else if (this.buffer.isGasEqual(net.buffer)) {
                    this.buffer.amount += net.buffer.amount;
                } else if (net.buffer.amount > this.buffer.amount) {
                    this.buffer = net.buffer.copy();
                }
                net.buffer = null;
            }
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.gasScale = this.getScale();
        this.register();
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IGasHandler, GasNetwork> transmitter) {
        Object b = transmitter.getBuffer();
        if (!(b instanceof GasStack) || ((GasStack)b).getGas() == null || ((GasStack)b).amount == 0) {
            return;
        }
        GasStack gas = (GasStack)b;
        if (this.buffer == null || this.buffer.getGas() == null || this.buffer.amount == 0) {
            this.buffer = gas.copy();
            gas.amount = 0;
            return;
        }
        if (this.buffer.isGasEqual(gas)) {
            this.buffer.amount += gas.amount;
        }
        gas.amount = 0;
    }

    @Override
    public void clampBuffer() {
        if (this.buffer != null && this.buffer.amount > this.getCapacity()) {
            this.buffer.amount = this.capacity;
        }
    }

    public int getGasNeeded() {
        return this.getCapacity() - (this.buffer != null ? this.buffer.amount : 0);
    }

    public int tickEmit(GasStack stack) {
        int sent;
        int toSend;
        ArrayList availableAcceptors = Lists.newArrayList();
        availableAcceptors.addAll(this.getAcceptors(stack.getGas()));
        Collections.shuffle(availableAcceptors);
        int prevSending = toSend = stack.amount;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = toSend % divider;
            int sending = (toSend - remaining) / divider;
            block0: for (Pair pair : availableAcceptors) {
                IGasHandler acceptor = (IGasHandler)pair.getRight();
                int currentSending = sending;
                EnumSet sides = (EnumSet)this.acceptorDirections.get(pair.getLeft());
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                for (EnumFacing side : sides) {
                    int prev = toSend;
                    if ((toSend -= acceptor.receiveGas(side, new GasStack(stack.getGas(), currentSending), true)) >= prev) continue;
                    continue block0;
                }
            }
        }
        if ((sent = prevSending - toSend) > 0 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.didTransfer = true;
            this.transferDelay = 2;
        }
        return sent;
    }

    public int emit(GasStack stack, boolean doTransfer) {
        if (this.buffer != null && this.buffer.getGas() != stack.getGas()) {
            return 0;
        }
        int toUse = Math.min(this.getGasNeeded(), stack.amount);
        if (doTransfer) {
            if (this.buffer == null) {
                this.buffer = stack.copy();
                this.buffer.amount = toUse;
            } else {
                this.buffer.amount += toUse;
            }
        }
        return toUse;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int stored;
            this.prevTransferAmount = 0;
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            int n = stored = this.buffer != null ? this.buffer.amount : 0;
            if (stored != this.prevStored) {
                this.needsUpdate = true;
            }
            this.prevStored = stored;
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new GasTransferEvent(this, this.buffer, this.didTransfer));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
            if (this.buffer != null) {
                this.prevTransferAmount = this.tickEmit(this.buffer);
                this.buffer.amount -= this.prevTransferAmount;
                if (this.buffer.amount <= 0) {
                    this.buffer = null;
                }
            }
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.gasScale = Math.max(this.gasScale, this.getScale());
        if (this.didTransfer && this.gasScale < 1.0f) {
            this.gasScale = Math.max(this.getScale(), Math.min(1.0f, this.gasScale + 0.02f));
        } else if (!this.didTransfer && this.gasScale > 0.0f) {
            this.gasScale = Math.max(this.getScale(), Math.max(0.0f, this.gasScale - 0.02f));
            if (this.gasScale == 0.0f) {
                this.buffer = null;
            }
        }
    }

    @Override
    public Set<Pair<Coord4D, IGasHandler>> getAcceptors(Object data) {
        Gas type = (Gas)data;
        HashSet<Pair<Coord4D, IGasHandler>> toReturn = new HashSet<Pair<Coord4D, IGasHandler>>();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return toReturn;
        }
        block0: for (Coord4D coord : this.possibleAcceptors.keySet()) {
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.getWorld());
            if (sides == null || sides.isEmpty()) continue;
            for (EnumFacing side : sides) {
                IGasHandler acceptor;
                if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side) || (acceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side)) == null || !acceptor.canReceiveGas(side, type)) continue;
                toReturn.add((Pair<Coord4D, IGasHandler>)Pair.of((Object)coord, (Object)acceptor));
                continue block0;
            }
        }
        return toReturn;
    }

    public float getScale() {
        return Math.min(1.0f, this.buffer == null || this.getCapacity() == 0 ? 0.0f : (float)this.buffer.amount / (float)this.getCapacity());
    }

    public String toString() {
        return "[GasNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public String getNeededInfo() {
        return Integer.toString(this.getGasNeeded());
    }

    @Override
    public String getStoredInfo() {
        return this.buffer != null ? this.buffer.getGas().getLocalizedName() + " (" + this.buffer.amount + ")" : "None";
    }

    @Override
    public String getFlowInfo() {
        return Integer.toString(this.prevTransferAmount) + "/t";
    }

    public static class GasTransferEvent
    extends Event {
        public final GasNetwork gasNetwork;
        public final GasStack transferType;
        public final boolean didTransfer;

        public GasTransferEvent(GasNetwork network, GasStack type, boolean did) {
            this.gasNetwork = network;
            this.transferType = type;
            this.didTransfer = did;
        }
    }
}

