/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import mekanism.client.ClientTickHandler;
import mekanism.client.sound.PlayerSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FlamethrowerSound
extends PlayerSound {
    public boolean inUse;
    public ResourceLocation onSound = new ResourceLocation("mekanism", "item.flamethrower.active");
    public ResourceLocation offSound = new ResourceLocation("mekanism", "item.flamethrower.idle");

    public FlamethrowerSound(EntityPlayer player) {
        super(player, new ResourceLocation("mekanism", "item.flamethrower.idle"));
        this.inUse = ClientTickHandler.isFlamethrowerOn(player);
        this.soundLocation = this.inUse ? this.onSound : this.offSound;
        this.setFadeIn(0);
        this.setFadeOut(0);
    }

    @Override
    public boolean func_147667_k() {
        return this.donePlaying;
    }

    @Override
    public boolean shouldPlaySound() {
        return true;
    }

    @Override
    public float func_147653_e() {
        return super.func_147653_e() * (float)(this.inUse ? 2 : 1);
    }

    @Override
    public void func_73660_a() {
        if (!ClientTickHandler.hasFlamethrower(this.player)) {
            this.donePlaying = true;
            return;
        }
        if (this.inUse != ClientTickHandler.isFlamethrowerOn(this.player)) {
            this.inUse = ClientTickHandler.isFlamethrowerOn(this.player);
            this.soundLocation = this.inUse ? this.onSound : this.offSound;
            this.donePlaying = true;
        }
    }
}

