/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mekanism.api.util.ItemInfo;
import mekanism.common.util.ItemRegistryUtils;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictCache {
    public static HashMap<ItemInfo, List<String>> cachedKeys = new HashMap();
    public static HashMap<String, List<ItemStack>> oreDictStacks = new HashMap();
    public static HashMap<String, List<ItemStack>> modIDStacks = new HashMap();

    public static List<String> getOreDictName(ItemStack check) {
        if (check == null || check.func_77973_b() == null) {
            return new ArrayList<String>();
        }
        ItemInfo info = ItemInfo.get(check);
        List<String> cached = cachedKeys.get(info);
        if (cached != null) {
            return cached;
        }
        int[] idsFound = OreDictionary.getOreIDs((ItemStack)check);
        ArrayList<String> ret = new ArrayList<String>();
        int[] nArray = idsFound;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer id = nArray[i];
            ret.add(OreDictionary.getOreName((int)id));
        }
        cachedKeys.put(info, ret);
        return ret;
    }

    public static List<ItemStack> getOreDictStacks(String oreName, boolean forceBlock) {
        if (oreDictStacks.get(oreName) != null) {
            return oreDictStacks.get(oreName);
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String s : OreDictionary.getOreNames()) {
            if (s == null) continue;
            if (oreName.equals(s) || oreName.equals("*")) {
                keys.add(s);
                continue;
            }
            if (oreName.endsWith("*") && !oreName.startsWith("*")) {
                if (!s.startsWith(oreName.substring(0, oreName.length() - 1))) continue;
                keys.add(s);
                continue;
            }
            if (oreName.startsWith("*") && !oreName.endsWith("*")) {
                if (!s.endsWith(oreName.substring(1))) continue;
                keys.add(s);
                continue;
            }
            if (!oreName.startsWith("*") || !oreName.endsWith("*") || !s.contains(oreName.substring(1, oreName.length() - 1))) continue;
            keys.add(s);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String key : keys) {
            for (ItemStack stack : OreDictionary.getOres((String)key)) {
                ItemStack toAdd = stack.func_77946_l();
                if (stacks.contains(stack) || forceBlock && !(toAdd.func_77973_b() instanceof ItemBlock)) continue;
                stacks.add(stack.func_77946_l());
            }
        }
        oreDictStacks.put(oreName, stacks);
        return stacks;
    }

    public static List<ItemStack> getModIDStacks(String modName, boolean forceBlock) {
        if (modIDStacks.get(modName) != null) {
            return modIDStacks.get(modName);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String key : OreDictionary.getOreNames()) {
            for (ItemStack stack : OreDictionary.getOres((String)key)) {
                ItemStack toAdd = stack.func_77946_l();
                String s = ItemRegistryUtils.getMod(toAdd);
                if (stacks.contains(stack) || !(toAdd.func_77973_b() instanceof ItemBlock)) continue;
                if (modName.equals(s) || modName.equals("*")) {
                    stacks.add(stack.func_77946_l());
                    continue;
                }
                if (modName.endsWith("*") && !modName.startsWith("*")) {
                    if (!s.startsWith(modName.substring(0, modName.length() - 1))) continue;
                    stacks.add(stack.func_77946_l());
                    continue;
                }
                if (modName.startsWith("*") && !modName.endsWith("*")) {
                    if (!s.endsWith(modName.substring(1))) continue;
                    stacks.add(stack.func_77946_l());
                    continue;
                }
                if (!modName.startsWith("*") || !modName.endsWith("*") || !s.contains(modName.substring(1, modName.length() - 1))) continue;
                stacks.add(stack.func_77946_l());
            }
        }
        modIDStacks.put(modName, stacks);
        return stacks;
    }
}

