/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.util.ListUtils;
import mekanism.common.item.ItemEnergized;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemAtomicDisassembler
extends ItemEnergized {
    public double HOE_USAGE = 10.0 * MekanismConfig.general.DISASSEMBLER_USAGE;

    public ItemAtomicDisassembler() {
        super(1000000.0);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return state.func_177230_c() != Blocks.field_150357_h;
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add(LangUtils.localize("tooltip.mode") + ": " + (Object)((Object)EnumColor.INDIGO) + this.getModeName(itemstack));
        list.add(LangUtils.localize("tooltip.efficiency") + ": " + (Object)((Object)EnumColor.INDIGO) + this.getEfficiency(itemstack));
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase hitEntity, EntityLivingBase player) {
        if (this.getEnergy(itemstack) > 0.0) {
            hitEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), 20.0f);
            this.setEnergy(itemstack, this.getEnergy(itemstack) - 2000.0);
        } else {
            hitEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), 4.0f);
        }
        return false;
    }

    public float func_150893_a(ItemStack itemstack, IBlockState state) {
        return this.getEnergy(itemstack) != 0.0 ? (float)this.getEfficiency(itemstack) : 1.0f;
    }

    public boolean func_179218_a(ItemStack itemstack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityliving) {
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            this.setEnergy(itemstack, this.getEnergy(itemstack) - MekanismConfig.general.DISASSEMBLER_USAGE * (double)this.getEfficiency(itemstack));
        } else {
            this.setEnergy(itemstack, this.getEnergy(itemstack) - MekanismConfig.general.DISASSEMBLER_USAGE * (double)this.getEfficiency(itemstack) / 2.0);
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        super.onBlockStartBreak(itemstack, pos, player);
        if (!player.field_70170_p.field_72995_K) {
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            int meta = block.func_176201_c(state);
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            ItemStack stack = new ItemStack(block, 1, meta);
            Coord4D orig = new Coord4D(pos, player.field_70170_p);
            List<String> names = MekanismUtils.getOreDictName(stack);
            boolean isOre = false;
            for (String s : names) {
                if (!s.startsWith("ore") && !s.equals("logWood")) continue;
                isOre = true;
            }
            if (this.getMode(itemstack) == 3 && isOre && !player.field_71075_bZ.field_75098_d) {
                Set<Coord4D> found = new Finder(player.field_70170_p, stack, new Coord4D(pos, player.field_70170_p)).calc();
                for (Coord4D coord : found) {
                    if (coord.equals(orig) || this.getEnergy(itemstack) < MekanismConfig.general.DISASSEMBLER_USAGE * (double)this.getEfficiency(itemstack)) continue;
                    Block block2 = coord.getBlock((IBlockAccess)player.field_70170_p);
                    block2.func_176206_d(player.field_70170_p, coord.getPos(), state);
                    player.field_70170_p.func_180498_a(null, 2001, coord.getPos(), Block.func_176210_f((IBlockState)state));
                    player.field_70170_p.func_175698_g(coord.getPos());
                    block2.func_180663_b(player.field_70170_p, coord.getPos(), state);
                    block2.func_176226_b(player.field_70170_p, coord.getPos(), state, 0);
                    this.setEnergy(itemstack, this.getEnergy(itemstack) - MekanismConfig.general.DISASSEMBLER_USAGE * (double)this.getEfficiency(itemstack));
                }
            }
        }
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer, EnumHand hand) {
        if (!world.field_72995_K && entityplayer.func_70093_af()) {
            this.toggleMode(itemstack);
            entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.modeToggle") + " " + (Object)((Object)EnumColor.INDIGO) + this.getModeName(itemstack) + (Object)((Object)EnumColor.AQUA) + " (" + this.getEfficiency(itemstack) + ")"));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            if (this.useHoe(stack, player, world, pos, side) == EnumActionResult.FAIL && world.func_180495_p(pos).func_177230_c() != Blocks.field_150458_ak) {
                return EnumActionResult.FAIL;
            }
            switch (this.getEfficiency(stack)) {
                case 20: {
                    for (int x1 = -1; x1 <= 1; ++x1) {
                        for (int z1 = -1; z1 <= 1; ++z1) {
                            this.useHoe(stack, player, world, pos.func_177982_a(x1, 0, z1), side);
                        }
                    }
                    break;
                }
                case 128: {
                    for (int x1 = -2; x1 <= 2; ++x1) {
                        for (int z1 = -2; z1 <= 2; ++z1) {
                            this.useHoe(stack, player, world, pos.func_177982_a(x1, 0, z1), side);
                        }
                    }
                    break;
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult useHoe(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing facing) {
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)stack, (EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (facing != EnumFacing.DOWN && worldIn.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                this.setBlock(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                return EnumActionResult.SUCCESS;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        this.setBlock(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                        return EnumActionResult.SUCCESS;
                    }
                    case COARSE_DIRT: {
                        this.setBlock(stack, playerIn, worldIn, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        return EnumActionResult.PASS;
    }

    protected void setBlock(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    public int getEfficiency(ItemStack itemStack) {
        switch (this.getMode(itemStack)) {
            case 0: {
                return 20;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 20;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public int getMode(ItemStack itemStack) {
        return ItemDataUtils.getInt(itemStack, "mode");
    }

    public String getModeName(ItemStack itemStack) {
        int mode = this.getMode(itemStack);
        switch (mode) {
            case 0: {
                return LangUtils.localize("tooltip.disassembler.normal");
            }
            case 1: {
                return LangUtils.localize("tooltip.disassembler.slow");
            }
            case 2: {
                return LangUtils.localize("tooltip.disassembler.fast");
            }
            case 3: {
                return LangUtils.localize("tooltip.disassembler.vein");
            }
            case 4: {
                return LangUtils.localize("tooltip.disassembler.off");
            }
        }
        return null;
    }

    public void toggleMode(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "mode", this.getMode(itemStack) < 4 ? this.getMode(itemStack) + 1 : 0);
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public static class Finder {
        public World world;
        public ItemStack stack;
        public Coord4D location;
        public Set<Coord4D> found = new HashSet<Coord4D>();
        public static Map<Block, List<Block>> ignoreBlocks = new HashMap<Block, List<Block>>();

        public Finder(World w, ItemStack s, Coord4D loc) {
            this.world = w;
            this.stack = s;
            this.location = loc;
        }

        public void loop(Coord4D pointer) {
            if (this.found.contains(pointer) || this.found.size() > 128) {
                return;
            }
            this.found.add(pointer);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                Coord4D coord = pointer.offset(side);
                if (!coord.exists(this.world) || !this.checkID(coord.getBlock((IBlockAccess)this.world)) || coord.getBlockMeta((IBlockAccess)this.world) != this.stack.func_77952_i() && (!MekanismUtils.getOreDictName(this.stack).contains("logWood") || coord.getBlockMeta((IBlockAccess)this.world) % 4 != this.stack.func_77952_i() % 4)) continue;
                this.loop(coord);
            }
        }

        public Set<Coord4D> calc() {
            this.loop(this.location);
            return this.found;
        }

        public boolean checkID(Block b) {
            Block origBlock = this.location.getBlock((IBlockAccess)this.world);
            return ignoreBlocks.get(origBlock) == null && b == origBlock || ignoreBlocks.get(origBlock) != null && ignoreBlocks.get(origBlock).contains(b);
        }

        static {
            ignoreBlocks.put(Blocks.field_150450_ax, ListUtils.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
            ignoreBlocks.put(Blocks.field_150439_ay, ListUtils.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
        }
    }
}

