/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.render.ModelCustomArmor;
import mekanism.common.Mekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScubaTank
extends ItemArmor
implements IGasItem {
    public int TRANSFER_RATE = 16;

    public ItemScubaTank() {
        super(EnumHelper.addArmorMaterial((String)"SCUBATANK", (String)"scubatank", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f), 0, EntityEquipmentSlot.CHEST);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add(LangUtils.localize("tooltip.noGas") + ".");
        } else {
            list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        }
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.flowing") + ": " + (Object)((Object)(this.getFlowing(itemstack) ? EnumColor.DARK_GREEN : EnumColor.DARK_RED)) + this.getFlowingStr(itemstack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)this.getMaxGas(stack);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "mekanism:render/NullArmor.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelCustomArmor model = ModelCustomArmor.INSTANCE;
        model.modelType = ModelCustomArmor.ArmorModel.SCUBATANK;
        return model;
    }

    public void useGas(ItemStack itemstack) {
        this.setGas(itemstack, new GasStack(this.getGas(itemstack).getGas(), this.getGas((ItemStack)itemstack).amount - 1));
    }

    public GasStack useGas(ItemStack itemstack, int amount) {
        if (this.getGas(itemstack) == null) {
            return null;
        }
        Gas type = this.getGas(itemstack).getGas();
        int gasToUse = Math.min(this.getStored(itemstack), Math.min(this.getRate(itemstack), amount));
        this.setGas(itemstack, new GasStack(type, this.getStored(itemstack) - gasToUse));
        return new GasStack(type, gasToUse);
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return MekanismConfig.general.maxScubaGas;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return this.TRANSFER_RATE;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != GasRegistry.getGas("oxygen")) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    public void toggleFlowing(ItemStack stack) {
        this.setFlowing(stack, !this.getFlowing(stack));
    }

    public boolean getFlowing(ItemStack stack) {
        return ItemDataUtils.getBoolean(stack, "flowing");
    }

    public String getFlowingStr(ItemStack stack) {
        boolean flowing = this.getFlowing(stack);
        return LangUtils.localize("tooltip." + (flowing ? "yes" : "no"));
    }

    public void setFlowing(ItemStack stack, boolean flowing) {
        ItemDataUtils.setBoolean(stack, "flowing", flowing);
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == GasRegistry.getGas("oxygen");
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "stored"));
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData(itemstack, "stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound(itemstack, "stored", gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        return empty;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        list.add(empty);
        ItemStack filled = new ItemStack((Item)this);
        this.setGas(filled, new GasStack(GasRegistry.getGas("oxygen"), ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
        list.add(filled);
    }
}

