/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class PartDiversionTransporter
extends PartLogisticalTransporter {
    public int[] modes = new int[]{0, 0, 0, 0, 0, 0};

    @Override
    public ResourceLocation getType() {
        return new ResourceLocation("mekanism:diversion_transporter");
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.DIVERSION_TRANSPORTER;
    }

    @Override
    public boolean renderCenter() {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTags) {
        super.readFromNBT(nbtTags);
        this.modes = nbtTags.func_74759_k("modes");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTags) {
        super.writeToNBT(nbtTags);
        nbtTags.func_74783_a("modes", this.modes);
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        super.handlePacketData(dataStream);
        if (this.getWorld().field_72995_K) {
            this.modes[0] = dataStream.readInt();
            this.modes[1] = dataStream.readInt();
            this.modes[2] = dataStream.readInt();
            this.modes[3] = dataStream.readInt();
            this.modes[4] = dataStream.readInt();
            this.modes[5] = dataStream.readInt();
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        data = super.getNetworkedData(data);
        data.add(this.modes[0]);
        data.add(this.modes[1]);
        data.add(this.modes[2]);
        data.add(this.modes[3]);
        data.add(this.modes[4]);
        data.add(this.modes[5]);
        return data;
    }

    @Override
    public ArrayList<Object> getSyncPacket(TransporterStack stack, boolean kill) {
        ArrayList<Object> data = super.getSyncPacket(stack, kill);
        data.add(this.modes[0]);
        data.add(this.modes[1]);
        data.add(this.modes[2]);
        data.add(this.modes[3]);
        data.add(this.modes[4]);
        data.add(this.modes[5]);
        return data;
    }

    @Override
    protected EnumActionResult onConfigure(EntityPlayer player, int part, EnumFacing side) {
        int newMode = (this.modes[side.ordinal()] + 1) % 3;
        String description = "ERROR";
        this.modes[side.ordinal()] = newMode;
        switch (newMode) {
            case 0: {
                description = LangUtils.localize("control.disabled.desc");
                break;
            }
            case 1: {
                description = LangUtils.localize("control.high.desc");
                break;
            }
            case 2: {
                description = LangUtils.localize("control.low.desc");
            }
        }
        this.refreshConnections();
        this.notifyPartUpdate();
        this.notifyTileChange();
        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.configurator.toggleDiverter") + ": " + (Object)((Object)EnumColor.RED) + description));
        Coord4D coord = new Coord4D(this.getPos(), this.getWorld());
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(coord, this.getNetworkedData(new ArrayList<Object>())), new Range4D(coord));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean canConnect(EnumFacing side) {
        if (!super.canConnect(side)) {
            return false;
        }
        int mode = this.modes[side.ordinal()];
        boolean redstone = MekanismUtils.isGettingPowered(this.getWorld(), new Coord4D(this.getPos(), this.getWorld()));
        return (mode != 2 || !redstone) && (mode != 1 || redstone);
    }

    @Override
    public EnumColor getRenderColor() {
        return null;
    }
}

