/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import mcmultipart.multipart.IMultipart;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.InventoryNetwork;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.multipart.ColorProperty;
import mekanism.common.multipart.MultipartTransporter;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class PartLogisticalTransporter
extends PartTransmitter<IInventory, InventoryNetwork> {
    public Tier.TransporterTier tier = Tier.TransporterTier.BASIC;
    public int pullDelay = 0;

    public PartLogisticalTransporter(Tier.TransporterTier transporterTier) {
        this();
        this.tier = transporterTier;
    }

    public PartLogisticalTransporter() {
        this.transmitterDelegate = new MultipartTransporter(this);
    }

    public ResourceLocation getType() {
        return new ResourceLocation("mekanism:logistical_transporter_" + this.tier.name().toLowerCase());
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ITEM;
    }

    @Override
    public void onWorldSeparate() {
        super.onWorldSeparate();
        if (!this.getWorld().field_72995_K) {
            PathfinderCache.onChanged(new Coord4D(this.getPos(), this.getWorld()));
        }
    }

    @Override
    public IInventory getCachedAcceptor(EnumFacing side) {
        return (IInventory)this.getCachedTile(side);
    }

    @Override
    protected boolean isValidTransmitter(TileEntity tileEntity) {
        ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
        if (this.getTransmitter().getColor() == null || transporter.getColor() == null || this.getTransmitter().getColor() == transporter.getColor()) {
            return super.isValidTransmitter(tileEntity);
        }
        return false;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, EnumFacing side) {
        return TransporterUtils.isValidAcceptorOnSide(tile, side);
    }

    @Override
    public boolean handlesRedstone() {
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.getTransmitter().update();
    }

    protected void pullItems() {
        if (this.pullDelay == 0) {
            boolean did = false;
            for (EnumFacing side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                IInventory inv;
                InvStack stack;
                TileEntity tile = this.getWorld().func_175625_s(this.getPos().func_177972_a(side));
                if (!(tile instanceof IInventory) || (stack = InventoryUtils.takeTopItem(inv = (IInventory)tile, side, this.tier.pullAmount)) == null || stack.getStack() == null) continue;
                ItemStack rejects = TransporterUtils.insert(tile, this.getTransmitter(), stack.getStack(), this.getTransmitter().getColor(), true, 0);
                if (!TransporterManager.didEmit(stack.getStack(), rejects)) continue;
                did = true;
                stack.use(TransporterManager.getToUse((ItemStack)stack.getStack(), (ItemStack)rejects).field_77994_a);
            }
            if (did) {
                this.pullDelay = 10;
            }
        } else {
            --this.pullDelay;
        }
    }

    @Override
    public void onWorldJoin() {
        super.onWorldJoin();
        PathfinderCache.onChanged(new Coord4D(this.getPos(), this.getWorld()));
    }

    @Override
    public InventoryNetwork createNewNetwork() {
        return new InventoryNetwork();
    }

    @Override
    public InventoryNetwork createNetworkByMerging(Collection<InventoryNetwork> networks) {
        return new InventoryNetwork(networks);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        super.handlePacketData(dataStream);
        if (this.getWorld().field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                int c = dataStream.readInt();
                EnumColor prev = this.getTransmitter().getColor();
                if (c != -1) {
                    this.getTransmitter().setColor(TransporterUtils.colors.get(c));
                } else {
                    this.getTransmitter().setColor(null);
                }
                if (prev != this.getTransmitter().getColor()) {
                    this.markRenderUpdate();
                }
                this.getTransmitter().transit.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    this.getTransmitter().transit.add(TransporterStack.readFromPacket(dataStream));
                }
            } else if (type == 1) {
                boolean kill = dataStream.readBoolean();
                int index = dataStream.readInt();
                if (kill) {
                    this.getTransmitter().transit.remove(index);
                } else {
                    TransporterStack stack = TransporterStack.readFromPacket(dataStream);
                    if (stack.progress == 0) {
                        stack.progress = 5;
                    }
                    this.getTransmitter().transit.replace(index, stack);
                }
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(0);
        if (this.getTransmitter().getColor() != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.getTransmitter().getColor()));
        } else {
            data.add(-1);
        }
        data.add(this.getTransmitter().transit.size());
        for (TransporterStack stack : this.getTransmitter().transit) {
            stack.write(this.getTransmitter(), data);
        }
        return data;
    }

    public ArrayList<Object> getSyncPacket(TransporterStack stack, boolean kill) {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(1);
        data.add(kill);
        data.add(this.getTransmitter().transit.indexOf(stack));
        if (!kill) {
            stack.write(this.getTransmitter(), data);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTags) {
        super.readFromNBT(nbtTags);
        if (nbtTags.func_74764_b("tier")) {
            this.tier = Tier.TransporterTier.values()[nbtTags.func_74762_e("tier")];
        }
        if (nbtTags.func_74764_b("color")) {
            this.getTransmitter().setColor(TransporterUtils.colors.get(nbtTags.func_74762_e("color")));
        }
        if (nbtTags.func_74764_b("stacks")) {
            NBTTagList tagList = nbtTags.func_150295_c("stacks", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                TransporterStack stack = TransporterStack.readFromNBT(tagList.func_150305_b(i));
                this.getTransmitter().transit.add(stack);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTags) {
        super.writeToNBT(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        if (this.getTransmitter().getColor() != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.getTransmitter().getColor()));
        }
        NBTTagList stacks = new NBTTagList();
        for (TransporterStack stack : this.getTransmitter().transit) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            stack.write(tagCompound);
            stacks.func_74742_a((NBTBase)tagCompound);
        }
        if (stacks.func_74745_c() != 0) {
            nbtTags.func_74782_a("stacks", (NBTBase)stacks);
        }
        return nbtTags;
    }

    @Override
    protected EnumActionResult onConfigure(EntityPlayer player, int part, EnumFacing side) {
        TransporterUtils.incrementColor(this.getTransmitter());
        this.onPartChanged((IMultipart)this);
        PathfinderCache.onChanged(new Coord4D(this.getPos(), this.getWorld()));
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(new Coord4D(this.getPos(), this.getWorld()), this.getNetworkedData(new ArrayList<Object>())), new Range4D(new Coord4D(this.getPos(), this.getWorld())));
        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.configurator.toggleColor") + ": " + (this.getTransmitter().getColor() != null ? this.getTransmitter().getColor().getColoredName() : (Object)((Object)EnumColor.BLACK) + LangUtils.localize("gui.none"))));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        super.onRightClick(player, side);
        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.configurator.viewColor") + ": " + (this.getTransmitter().getColor() != null ? this.getTransmitter().getColor().getColoredName() : "None")));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumColor getRenderColor() {
        return this.getTransmitter().getColor();
    }

    @Override
    public boolean transparencyRender() {
        return true;
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (!this.getWorld().field_72995_K) {
            for (TransporterStack stack : this.getTransmitter().transit) {
                TransporterUtils.drop(this.getTransmitter(), stack);
            }
        }
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Object getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Override
    public void updateShare() {
    }

    public MultipartTransporter getTransmitter() {
        return (MultipartTransporter)this.transmitterDelegate;
    }

    public double getCost() {
        return (double)Tier.TransporterTier.ULTIMATE.speed / (double)this.tier.speed;
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.TransporterTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)super.getExtendedState(state)).withProperty((IUnlistedProperty)ColorProperty.INSTANCE, (Object)new ColorProperty(this.getRenderColor()));
    }

    @Override
    public void readUpdatePacket(PacketBuffer packet) {
        this.tier = Tier.TransporterTier.values()[packet.readInt()];
        super.readUpdatePacket(packet);
    }

    @Override
    public void writeUpdatePacket(PacketBuffer packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeUpdatePacket(packet);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY) {
            return (T)this.getTransmitter();
        }
        return super.getCapability(capability, side);
    }
}

