/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Tier;

public enum TransmitterType {
    UNIVERSAL_CABLE_BASIC("BasicUniversalCable", Tier.BaseTier.BASIC, Size.SMALL, TransmissionType.ENERGY, false, 0, 0),
    UNIVERSAL_CABLE_ADVANCED("AdvancedUniversalCable", Tier.BaseTier.ADVANCED, Size.SMALL, TransmissionType.ENERGY, false, 1, 1),
    UNIVERSAL_CABLE_ELITE("EliteUniversalCable", Tier.BaseTier.ELITE, Size.SMALL, TransmissionType.ENERGY, false, 2, 2),
    UNIVERSAL_CABLE_ULTIMATE("UltimateUniversalCable", Tier.BaseTier.ULTIMATE, Size.SMALL, TransmissionType.ENERGY, false, 3, 3),
    MECHANICAL_PIPE_BASIC("BasicMechanicalPipe", Tier.BaseTier.BASIC, Size.LARGE, TransmissionType.FLUID, false, 0, 0),
    MECHANICAL_PIPE_ADVANCED("AdvancedMechanicalPipe", Tier.BaseTier.ADVANCED, Size.LARGE, TransmissionType.FLUID, false, 1, 1),
    MECHANICAL_PIPE_ELITE("EliteMechanicalPipe", Tier.BaseTier.ELITE, Size.LARGE, TransmissionType.FLUID, false, 2, 2),
    MECHANICAL_PIPE_ULTIMATE("UltimateMechanicalPipe", Tier.BaseTier.ULTIMATE, Size.LARGE, TransmissionType.FLUID, false, 3, 3),
    PRESSURIZED_TUBE_BASIC("BasicPressurizedTube", Tier.BaseTier.BASIC, Size.SMALL, TransmissionType.GAS, false, 0, 0),
    PRESSURIZED_TUBE_ADVANCED("AdvancedPressurizedTube", Tier.BaseTier.ADVANCED, Size.SMALL, TransmissionType.GAS, false, 1, 1),
    PRESSURIZED_TUBE_ELITE("ElitePressurizedTube", Tier.BaseTier.ELITE, Size.SMALL, TransmissionType.GAS, false, 2, 2),
    PRESSURIZED_TUBE_ULTIMATE("UltimatePressurizedTube", Tier.BaseTier.ULTIMATE, Size.SMALL, TransmissionType.GAS, false, 3, 3),
    LOGISTICAL_TRANSPORTER_BASIC("BasicLogisticalTransporter", Tier.BaseTier.BASIC, Size.LARGE, TransmissionType.ITEM, true, 0, 0, 6, 10),
    LOGISTICAL_TRANSPORTER_ADVANCED("AdvancedLogisticalTransporter", Tier.BaseTier.ADVANCED, Size.LARGE, TransmissionType.ITEM, true, 1, 1, 6, 10),
    LOGISTICAL_TRANSPORTER_ELITE("EliteLogisticalTransporter", Tier.BaseTier.ELITE, Size.LARGE, TransmissionType.ITEM, true, 2, 2, 6, 10),
    LOGISTICAL_TRANSPORTER_ULTIMATE("UltimateLogisticalTransporter", Tier.BaseTier.ULTIMATE, Size.LARGE, TransmissionType.ITEM, true, 3, 3, 6, 10),
    RESTRICTIVE_TRANSPORTER("RestrictiveTransporter", Tier.BaseTier.BASIC, Size.LARGE, TransmissionType.ITEM, false, 4, 8),
    DIVERSION_TRANSPORTER("DiversionTransporter", Tier.BaseTier.BASIC, Size.LARGE, TransmissionType.ITEM, true, 5, 14, 6, 10),
    THERMODYNAMIC_CONDUCTOR_BASIC("BasicThermodynamicConductor", Tier.BaseTier.BASIC, Size.SMALL, TransmissionType.HEAT, false, 0, 0),
    THERMODYNAMIC_CONDUCTOR_ADVANCED("AdvancedThermodynamicConductor", Tier.BaseTier.ADVANCED, Size.SMALL, TransmissionType.HEAT, false, 1, 1),
    THERMODYNAMIC_CONDUCTOR_ELITE("EliteThermodynamicConductor", Tier.BaseTier.ELITE, Size.SMALL, TransmissionType.HEAT, false, 2, 2),
    THERMODYNAMIC_CONDUCTOR_ULTIMATE("UltimateThermodynamicConductor", Tier.BaseTier.ULTIMATE, Size.SMALL, TransmissionType.HEAT, false, 3, 3);

    private String unlocalizedName;
    private Size size;
    private TransmissionType transmissionType;
    private boolean transparencyRender;
    private int[] indexes;
    private Tier.BaseTier tier;

    private TransmitterType(String name, Tier.BaseTier t, Size s, TransmissionType type, boolean transparency, int ... is) {
        this.unlocalizedName = name;
        this.tier = t;
        this.size = s;
        this.transmissionType = type;
        this.transparencyRender = transparency;
        this.indexes = is;
    }

    public Tier.BaseTier getTier() {
        return this.tier;
    }

    public String getName() {
        return this.unlocalizedName;
    }

    public Size getSize() {
        return this.size;
    }

    public boolean hasTransparency() {
        return this.transparencyRender;
    }

    public TransmissionType getTransmission() {
        return this.transmissionType;
    }

    public static enum Size {
        SMALL(6),
        LARGE(8);

        public int centerSize;

        private Size(int size) {
            this.centerSize = size;
        }
    }
}

