/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.IGuiProvider;
import mekanism.common.tile.TileEntityBasicBlock;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSimpleGui
implements IMessageHandler<SimpleGuiMessage, IMessage> {
    public static List<IGuiProvider> handlers = new ArrayList<IGuiProvider>();

    public IMessage onMessage(final SimpleGuiMessage message, MessageContext context) {
        final EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(new Runnable(){

            @Override
            public void run() {
                if (!player.field_70170_p.field_72995_K) {
                    WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
                    if (worldServer != null && message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityBasicBlock) {
                        if (message.guiId == -1) {
                            return;
                        }
                        SimpleGuiMessage.openServerGui(message.guiHandler, message.guiId, (EntityPlayerMP)player, player.field_70170_p, message.coord4D);
                    }
                } else {
                    FMLCommonHandler.instance().showGuiScreen((Object)SimpleGuiMessage.getGui(message.guiHandler, message.guiId, player, player.field_70170_p, message.coord4D));
                    player.field_71070_bA.field_75152_c = message.windowId;
                }
            }
        }, player);
        return null;
    }

    public static class SimpleGuiMessage
    implements IMessage {
        public Coord4D coord4D;
        public int guiHandler;
        public int guiId;
        public int windowId;

        public SimpleGuiMessage() {
        }

        public SimpleGuiMessage(Coord4D coord, int handler, int gui) {
            this.coord4D = coord;
            this.guiHandler = handler;
            this.guiId = gui;
        }

        public SimpleGuiMessage(Coord4D coord, int handler, int gui, int id) {
            this(coord, handler, gui);
            this.windowId = id;
        }

        public static void openServerGui(int handler, int id, EntityPlayerMP playerMP, World world, Coord4D obj) {
            playerMP.func_71128_l();
            playerMP.func_71117_bO();
            int window = playerMP.field_71139_cq;
            Mekanism.packetHandler.sendTo(new SimpleGuiMessage(obj, handler, id, window), playerMP);
            playerMP.field_71070_bA = handlers.get(handler).getServerGui(id, (EntityPlayer)playerMP, world, obj.getPos());
            playerMP.field_71070_bA.field_75152_c = window;
            playerMP.field_71070_bA.func_75132_a((IContainerListener)playerMP);
        }

        @SideOnly(value=Side.CLIENT)
        public static GuiScreen getGui(int handler, int id, EntityPlayer player, World world, Coord4D obj) {
            return (GuiScreen)handlers.get(handler).getClientGui(id, player, world, obj.getPos());
        }

        public void toBytes(ByteBuf dataStream) {
            this.coord4D.write(dataStream);
            dataStream.writeInt(this.guiHandler);
            dataStream.writeInt(this.guiId);
            dataStream.writeInt(this.windowId);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = Coord4D.read(dataStream);
            this.guiHandler = dataStream.readInt();
            this.guiId = dataStream.readInt();
            this.windowId = dataStream.readInt();
        }
    }
}

