/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalInfuser
extends TileEntityNoisyElectricBlock
implements IGasHandler,
ITubeConnection,
IRedstoneControl,
ISustainedData,
IUpgradeTile,
Upgrade.IUpgradeInfoHandler,
ITankManager,
ISecurityTile {
    public GasTank leftTank = new GasTank(10000);
    public GasTank rightTank = new GasTank(10000);
    public GasTank centerTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public int updateDelay;
    public int gasOutput = 256;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public final double BASE_ENERGY_USAGE;
    public double energyPerTick = this.BASE_ENERGY_USAGE = MekanismConfig.usage.chemicalInfuserUsage;
    public ChemicalInfuserRecipe cachedRecipe;
    public double clientEnergyUsed;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 4);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityChemicalInfuser() {
        super("machine.cheminfuser", "ChemicalInfuser", BlockStateMachine.MachineType.CHEMICAL_INFUSER.baseEnergy);
        this.inventory = new ItemStack[5];
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            ChemicalInfuserRecipe recipe;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(3, this);
            if (this.inventory[0] != null && (this.leftTank.getGas() == null || this.leftTank.getStored() < this.leftTank.getMaxGas())) {
                this.leftTank.receive(GasTransmission.removeGas(this.inventory[0], this.leftTank.getGasType(), this.leftTank.getNeeded()), true);
            }
            if (this.inventory[1] != null && (this.rightTank.getGas() == null || this.rightTank.getStored() < this.rightTank.getMaxGas())) {
                this.rightTank.receive(GasTransmission.removeGas(this.inventory[1], this.rightTank.getGasType(), this.rightTank.getNeeded()), true);
            }
            if (this.inventory[2] != null && this.centerTank.getGas() != null) {
                this.centerTank.draw(GasTransmission.addGas(this.inventory[2], this.centerTank.getGas()), true);
            }
            if (this.canOperate(recipe = this.getRecipe()) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                int operations = this.operate(recipe);
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.centerTank.getGas() != null) {
                GasStack toSend = new GasStack(this.centerTank.getGas().getGas(), Math.min(this.centerTank.getStored(), this.gasOutput));
                TileEntity tileEntity = Coord4D.get(this).offset(this.facing).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(this.facing.func_176734_d(), this.centerTank.getGas().getGas())) {
                    this.centerTank.draw(((IGasHandler)tileEntity).receiveGas(this.facing.func_176734_d(), toSend, true), true);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public int getUpgradedUsage(ChemicalInfuserRecipe recipe) {
        int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        if (this.leftTank.getGasType() == ((ChemicalPairInput)recipe.recipeInput).leftGas.getGas()) {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
        } else {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
        }
        possibleProcess = Math.min(this.centerTank.getNeeded() / ((GasOutput)recipe.recipeOutput).output.amount, possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return possibleProcess;
    }

    public ChemicalPairInput getInput() {
        return new ChemicalPairInput(this.leftTank.getGas(), this.rightTank.getGas());
    }

    public ChemicalInfuserRecipe getRecipe() {
        ChemicalPairInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ChemicalPairInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalInfuserRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public boolean canOperate(ChemicalInfuserRecipe recipe) {
        return recipe != null && recipe.canOperate(this.leftTank, this.rightTank, this.centerTank);
    }

    public int operate(ChemicalInfuserRecipe recipe) {
        int operations = this.getUpgradedUsage(recipe);
        recipe.operate(this.leftTank, this.rightTank, this.centerTank, operations);
        this.func_70296_d();
        return operations;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.clientEnergyUsed = dataStream.readDouble();
            if (dataStream.readBoolean()) {
                this.leftTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.leftTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.rightTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.rightTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.centerTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.centerTank.setGas(null);
            }
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.clientEnergyUsed);
        if (this.leftTank.getGas() != null) {
            data.add(true);
            data.add(this.leftTank.getGas().getGas().getID());
            data.add(this.leftTank.getStored());
        } else {
            data.add(false);
        }
        if (this.rightTank.getGas() != null) {
            data.add(true);
            data.add(this.rightTank.getGas().getGas().getID());
            data.add(this.rightTank.getStored());
        } else {
            data.add(false);
        }
        if (this.centerTank.getGas() != null) {
            data.add(true);
            data.add(this.centerTank.getGas().getGas().getID());
            data.add(this.centerTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.centerTank.read(nbtTags.func_74775_l("centerTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("centerTank", (NBTBase)this.centerTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public GasTank getTank(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank;
        }
        if (side == this.facing) {
            return this.centerTank;
        }
        return null;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing) || side == this.facing;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) != this.centerTank && this.getTank(side).canReceive(type);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.getTank(side).receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.getTank(side).draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) == this.centerTank && this.getTank(side).canDraw(type);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 3 && ChargeUtils.canBeDischarged(itemstack);
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0 || slotID == 2) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, null);
        }
        if (slotID == 1) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return new int[]{0};
        }
        if (side == this.facing) {
            return new int[]{1};
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return new int[]{2};
        }
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return new int[3];
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.leftTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "leftTank", this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "rightTank", this.rightTank.getGas().write(new NBTTagCompound()));
        }
        if (this.centerTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "centerTank", this.centerTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.leftTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "rightTank")));
        this.centerTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "centerTank")));
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.energyPerTick = MekanismUtils.getBaseEnergyPerTick(this, this.BASE_ENERGY_USAGE);
            }
        }
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.leftTank, this.rightTank, this.centerTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

