/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.foamfix.FoamFixModelDeduplicate;
import pl.asie.foamfix.FoamFixModelRegistryDuplicateWipe;
import pl.asie.foamfix.util.Deduplicator;
import pl.asie.foamfix.util.PretendPackageMap;

@Mod(modid="foamfix", name="FoamFix", version="0.3.1", clientSideOnly=true, acceptedMinecraftVersions="[1.10.2]")
public class FoamFix {
    public static final IBakedModel DUMMY_MODEL = new IBakedModel(){
        private final ItemOverrideList itemOverrideList = ItemOverrideList.field_188022_a;

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_147117_R().getTextureExtry(TextureMap.field_174945_f.toString());
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return this.itemOverrideList;
        }
    };
    public static Deduplicator deduplicator = new Deduplicator();
    public static Configuration config;
    public static Logger logger;
    public static int stage;
    public static boolean lwWeakenResourceCache;
    public static boolean lwDummyPackageManifestMap;
    public static boolean mcDeduplicate;
    public static boolean mcCleanRedundantModelRegistry;

    private void optimizeLaunchWrapper() {
        LaunchClassLoader loader = (LaunchClassLoader)this.getClass().getClassLoader();
        Field resourceCacheField = ReflectionHelper.findField(LaunchClassLoader.class, (String[])new String[]{"resourceCache"});
        Field packageManifestsField = ReflectionHelper.findField(LaunchClassLoader.class, (String[])new String[]{"packageManifests"});
        if (lwWeakenResourceCache) {
            logger.info("Weakening LaunchWrapper resource cache...");
            try {
                Map oldResourceCache = (Map)resourceCacheField.get(loader);
                ConcurrentMap newResourceCache = CacheBuilder.newBuilder().weakValues().build().asMap();
                newResourceCache.putAll(oldResourceCache);
                resourceCacheField.set(loader, newResourceCache);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (lwDummyPackageManifestMap) {
            logger.info("Dummying out LaunchWrapper's unused package manifests...");
            try {
                packageManifestsField.set(loader, new PretendPackageMap());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = LogManager.getLogger((String)"foamfix");
        stage = 0;
        config = new Configuration(event.getSuggestedConfigurationFile());
        lwDummyPackageManifestMap = config.getBoolean("dummyPackageManifestMap", "launchwrapper", true, "Dummy out LaunchWrapper's unused package manifest map. This will only break things if some other mod reflects into the LaunchClassLoader to get the private map, which as far as I know is not the case.");
        lwWeakenResourceCache = config.getBoolean("weakenResourceCache", "launchwrapper", true, "Weaken LaunchWrapper's byte[] resource cache to make it cleanuppable by the GC. Safe.");
        mcDeduplicate = config.getBoolean("deduplicate", "general", true, "Enable deduplication of redundant objects in memory.");
        mcCleanRedundantModelRegistry = config.getBoolean("clearDuplicateModelRegistry", "general", true, "Clears the baked models generated in the first pass *before* entering the second pass, instead of *after*. While this doesn't reduce memory usage in-game, it does reduce it noticeably during loading.");
        config.save();
        if (!mcDeduplicate) {
            deduplicator = null;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        stage = 1;
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new FoamFixModelDeduplicate());
        if (mcCleanRedundantModelRegistry) {
            MinecraftForge.EVENT_BUS.register((Object)new FoamFixModelRegistryDuplicateWipe());
        }
        this.optimizeLaunchWrapper();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (deduplicator != null) {
            FoamFix.deduplicator.successfuls = 0;
        }
        stage = 2;
    }
}

