/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.util;

import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;

public final class HashingStrategies {
    public static final HashingStrategy<byte[]> BYTE_ARRAY = new ByteArray();
    public static final HashingStrategy<float[]> FLOAT_ARRAY = new FloatArray();
    public static final HashingStrategy<float[][]> FLOAT_ARRAY_ARRAY = new FloatArrayArray();
    public static final HashingStrategy<float[][][]> FLOAT_ARRAY_ARRAY_ARRAY = new FloatArrayArrayArray();
    public static final HashingStrategy<int[]> INT_ARRAY = new IntArray();
    public static final HashingStrategy GENERIC = new ObjectStrategy();
    public static final HashingStrategy IDENTITY = new IdentityHashingStrategy();
    public static final HashingStrategy<ItemCameraTransforms> ITEM_CAMERA_TRANSFORMS = new ItemCameraTransformsStrategy();

    private static final class FloatArrayArrayArray
    implements HashingStrategy<float[][][]> {
        private FloatArrayArrayArray() {
        }

        public int computeHashCode(float[][][] object) {
            return Arrays.deepHashCode((Object[])object);
        }

        public boolean equals(float[][][] o1, float[][][] o2) {
            return Arrays.deepEquals((Object[])o1, (Object[])o2);
        }
    }

    private static final class FloatArrayArray
    implements HashingStrategy<float[][]> {
        private FloatArrayArray() {
        }

        public int computeHashCode(float[][] object) {
            return Arrays.deepHashCode((Object[])object);
        }

        public boolean equals(float[][] o1, float[][] o2) {
            return Arrays.deepEquals((Object[])o1, (Object[])o2);
        }
    }

    private static final class FloatArray
    implements HashingStrategy<float[]> {
        private FloatArray() {
        }

        public int computeHashCode(float[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(float[] o1, float[] o2) {
            return Arrays.equals(o1, o2);
        }
    }

    private static final class IntArray
    implements HashingStrategy<int[]> {
        private IntArray() {
        }

        public int computeHashCode(int[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(int[] o1, int[] o2) {
            return Arrays.equals(o1, o2);
        }
    }

    private static final class ByteArray
    implements HashingStrategy<byte[]> {
        private ByteArray() {
        }

        public int computeHashCode(byte[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(byte[] o1, byte[] o2) {
            return Arrays.equals(o1, o2);
        }
    }

    private static final class ObjectStrategy
    implements HashingStrategy {
        private ObjectStrategy() {
        }

        public int computeHashCode(Object object) {
            return Objects.hashCode(object);
        }

        public boolean equals(Object o1, Object o2) {
            return Objects.equals(o1, o2);
        }
    }

    private static final class ItemCameraTransformsStrategy
    implements HashingStrategy<ItemCameraTransforms> {
        private ItemCameraTransformsStrategy() {
        }

        public int computeHashCode(ItemCameraTransforms object) {
            return Objects.hash(object.field_188038_m, object.field_188039_n, object.field_181700_p, object.field_181699_o, object.field_178354_e, object.field_178353_d, object.field_188036_k, object.field_188037_l);
        }

        public boolean equals(ItemCameraTransforms o1, ItemCameraTransforms o2) {
            if (o1 == null) {
                return o1 == o2;
            }
            return Objects.equals(o1.field_188038_m, o2.field_188038_m) && Objects.equals(o1.field_188039_n, o2.field_188039_n) && Objects.equals(o1.field_181700_p, o2.field_181700_p) && Objects.equals(o1.field_181699_o, o2.field_181699_o) && Objects.equals(o1.field_178354_e, o2.field_178354_e) && Objects.equals(o1.field_178353_d, o2.field_178353_d) && Objects.equals(o1.field_188036_k, o2.field_188036_k) && Objects.equals(o1.field_188037_l, o2.field_188037_l);
        }
    }
}

