/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.client.multipart;

import java.util.Map;
import mcmultipart.block.TileCoverable;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.client.multipart.IFastMSRPart;
import mcmultipart.client.multipart.ModelMultipartContainer;
import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.client.multipart.MultipartSpecialRenderer;
import mcmultipart.client.multipart.MultipartStateMapper;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipart2;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;

public final class MultipartContainerSpecialRenderer {
    private static final EnumFacing[] ALL_ENUM_FACING = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST, null};

    public static boolean renderMultipartContainerAt(IMultipartContainer container, double x, double y, double z, float partialTicks, int destroyStage, TileEntityRendererDispatcher rendererDispatcher) {
        MultipartSpecialRenderer<IMultipart> renderer;
        if (destroyStage >= 0) {
            VertexBufferConsumer consumer = new VertexBufferConsumer(Tessellator.func_178181_a().func_178180_c());
            MultipartContainerSpecialRenderer.startBreaking(rendererDispatcher);
            RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && mop.func_178782_a() != null && mop.func_178782_a().equals((Object)container.getPosIn()) && !(mop instanceof PartMOP)) {
                MultipartContainerSpecialRenderer.renderBreaking(((PartMOP)mop).partHit, (IVertexConsumer)consumer, x, y, z, partialTicks, destroyStage, rendererDispatcher);
            } else {
                for (IMultipart iMultipart : container.getParts()) {
                    MultipartContainerSpecialRenderer.renderBreaking(iMultipart, (IVertexConsumer)consumer, x, y, z, partialTicks, destroyStage, rendererDispatcher);
                }
            }
            MultipartContainerSpecialRenderer.finishBreaking();
            return true;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        rendererDispatcher.field_147553_e.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (IMultipart iMultipart : container.getParts()) {
            renderer = MultipartRegistryClient.getSpecialRenderer(iMultipart);
            if (renderer == null || !renderer.shouldRenderInPass(iMultipart, MinecraftForgeClient.getRenderPass()) || !(iMultipart instanceof IFastMSRPart) || !((IFastMSRPart)iMultipart).hasFastRenderer()) continue;
            renderer.setRendererDispatcher(rendererDispatcher);
            renderer.renderMultipartFast(iMultipart, x, y, z, partialTicks, destroyStage, buffer);
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        for (IMultipart iMultipart : container.getParts()) {
            renderer = MultipartRegistryClient.getSpecialRenderer(iMultipart);
            if (renderer == null || !renderer.shouldRenderInPass(iMultipart, MinecraftForgeClient.getRenderPass()) || iMultipart instanceof IFastMSRPart && ((IFastMSRPart)iMultipart).hasFastRenderer()) continue;
            renderer.setRendererDispatcher(rendererDispatcher);
            renderer.renderMultipartAt(iMultipart, x, y, z, partialTicks, destroyStage);
        }
        return false;
    }

    public static boolean renderMultipartContainerFast(IMultipartContainer container, double x, double y, double z, float partialTicks, int destroyStage, TileEntityRendererDispatcher rendererDispatcher, VertexBuffer buffer) {
        for (IMultipart iMultipart : container.getParts()) {
            MultipartSpecialRenderer<IMultipart> renderer = MultipartRegistryClient.getSpecialRenderer(iMultipart);
            if (renderer == null || !renderer.shouldRenderInPass(iMultipart, MinecraftForgeClient.getRenderPass())) continue;
            renderer.setRendererDispatcher(rendererDispatcher);
            renderer.renderMultipartFast(iMultipart, x, y, z, partialTicks, destroyStage, buffer);
        }
        return false;
    }

    private static void startBreaking(TileEntityRendererDispatcher rendererDispatcher) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
    }

    private static void startTessellating(double x, double y, double z) {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181703_c);
        Tessellator.func_178181_a().func_178180_c().func_178969_c(x, y, z);
        Tessellator.func_178181_a().func_178180_c().func_78914_f();
    }

    private static void renderBreaking(IMultipart part, IVertexConsumer consumer, double x, double y, double z, float partialTicks, int destroyStage, TileEntityRendererDispatcher rendererDispatcher) {
        MultipartSpecialRenderer<IMultipart> renderer = MultipartRegistryClient.getSpecialRenderer(part);
        if (renderer != null && renderer.canRenderBreaking(part)) {
            renderer.setRendererDispatcher(rendererDispatcher);
            renderer.renderMultipartAt(part, x, y, z, partialTicks, destroyStage);
        } else if (MinecraftForgeClient.getRenderPass() == 1) {
            IBakedModel model;
            IBlockState state;
            ResourceLocation path = part.getModelPath();
            IBlockState iBlockState = state = part instanceof IMultipart2 ? ((IMultipart2)part).getActualState(MultipartRegistry.getDefaultState(part).func_177621_b(), (IBlockAccess)part.getWorld(), part.getPos()) : part.getActualState(MultipartRegistry.getDefaultState(part).func_177621_b());
            if (part instanceof IMultipart2 && ((IMultipart2)part).shouldBreakingUseExtendedState()) {
                state = part instanceof IMultipart2 ? ((IMultipart2)part).getExtendedState(state, (IBlockAccess)part.getWorld(), part.getPos()) : part.getExtendedState(state);
            }
            IBakedModel iBakedModel = model = path == null ? null : Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(new ModelResourceLocation(path, MultipartStateMapper.instance.func_178131_a((Map<IProperty<?>, Comparable<?>>)state.func_177228_b())));
            if (model != null) {
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!part.canRenderInLayer(layer)) continue;
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    IBakedModel layerModel = new SimpleBakedModel.Builder(state, model, Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/destroy_stage_" + destroyStage), part.getPos()).func_177645_b();
                    rendererDispatcher.field_147553_e.func_110577_a(TextureMap.field_110575_b);
                    MultipartContainerSpecialRenderer.startTessellating(x, y, z);
                    consumer = new VertexBufferConsumer(Tessellator.func_178181_a().func_178180_c());
                    MultipartContainerSpecialRenderer.renderBreaking(state, layerModel, consumer);
                    MultipartContainerSpecialRenderer.finishTessellating();
                }
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
            }
        }
    }

    private static void renderBreaking(IBlockState state, IBakedModel model, IVertexConsumer consumer) {
        for (EnumFacing side : ALL_ENUM_FACING) {
            for (BakedQuad quad : model.func_188616_a(state, side, 0L)) {
                quad.pipe(consumer);
            }
        }
    }

    private static void finishTessellating() {
        Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
    }

    private static void finishBreaking() {
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static class TileCoverableSpecialRenderer<T extends TileCoverable>
    extends TileEntitySpecialRenderer<T> {
        public void renderTileEntityAt(T te, double x, double y, double z, float partialTicks, int destroyStage) {
            if (destroyStage >= 0) {
                if (MinecraftForgeClient.getRenderPass() != 1) {
                    return;
                }
                RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
                if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && mop.func_178782_a() != null && mop.func_178782_a().equals((Object)((TileCoverable)te).getPosIn()) && !(mop instanceof PartMOP)) {
                    VertexBufferConsumer consumer = new VertexBufferConsumer(Tessellator.func_178181_a().func_178180_c());
                    MultipartContainerSpecialRenderer.startBreaking(this.field_147501_a);
                    if (this.canRenderBreaking()) {
                        this.renderTileEntityAtDefault(te, x, y, z, partialTicks, destroyStage);
                    } else {
                        IBlockState state = ((TileCoverable)te).getWorldIn().func_180495_p(((TileCoverable)te).getPosIn());
                        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(te.func_145838_q().func_176221_a(state, (IBlockAccess)((TileCoverable)te).getWorldIn(), ((TileCoverable)te).getPosIn()));
                        if (model != null && model instanceof ModelMultipartContainer) {
                            model = ((ModelMultipartContainer)model).model;
                        }
                        if (model != null) {
                            model = new SimpleBakedModel.Builder(state, model, Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/destroy_stage_" + destroyStage), ((TileCoverable)te).getPosIn()).func_177645_b();
                            MultipartContainerSpecialRenderer.startTessellating(x, y, z);
                            MultipartContainerSpecialRenderer.renderBreaking(state, model, (IVertexConsumer)consumer);
                            MultipartContainerSpecialRenderer.finishTessellating();
                        }
                    }
                    MultipartContainerSpecialRenderer.finishBreaking();
                    return;
                }
            }
            if (MultipartContainerSpecialRenderer.renderMultipartContainerAt(((TileCoverable)te).getMicroblockContainer(), x, y, z, partialTicks, destroyStage, this.field_147501_a)) {
                return;
            }
            this.renderTileEntityAtDefault(te, x, y, z, partialTicks, destroyStage);
        }

        public void renderTileEntityAtDefault(T te, double x, double y, double z, float partialTicks, int destroyStage) {
        }

        public void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
            if (MultipartContainerSpecialRenderer.renderMultipartContainerFast(((TileCoverable)te).getMicroblockContainer(), x, y, z, partialTicks, destroyStage, this.field_147501_a, buffer)) {
                return;
            }
            this.renderTileEntityFastDefault(te, x, y, z, partialTicks, destroyStage, buffer);
        }

        public void renderTileEntityFastDefault(T te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
        }

        public boolean canRenderBreaking() {
            return false;
        }
    }

    public static final class TileMultipartSpecialRenderer
    extends TileEntitySpecialRenderer<TileMultipartContainer> {
        public void renderTileEntityAt(TileMultipartContainer te, double x, double y, double z, float partialTicks, int destroyStage) {
            MultipartContainerSpecialRenderer.renderMultipartContainerAt(te, x, y, z, partialTicks, destroyStage, this.field_147501_a);
        }

        public void renderTileEntityFast(TileMultipartContainer te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
            MultipartContainerSpecialRenderer.renderMultipartContainerFast(te, x, y, z, partialTicks, destroyStage, this.field_147501_a, buffer);
        }
    }
}

