/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.item;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import mcmultipart.item.IItemMultipartFactory;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.network.MessageWrappedPartPlacement;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PartPlacementWrapper {
    private static final Map<String, PartPlacementWrapper> wrappers = new HashMap<String, PartPlacementWrapper>();
    protected final Predicate<ItemStack> match;
    protected final IItemMultipartFactory factory;
    private String identifier;

    public static PartPlacementWrapper getWrapper(String handler) {
        return wrappers.get(handler);
    }

    public PartPlacementWrapper(Predicate<ItemStack> match, IItemMultipartFactory factory) {
        this.match = match;
        this.factory = factory;
    }

    public PartPlacementWrapper(final ItemStack match, IItemMultipartFactory factory) {
        this(new Predicate<ItemStack>(){

            public boolean apply(ItemStack input) {
                return input.func_77969_a(match);
            }
        }, factory);
    }

    public void register(String identifier) {
        this.identifier = identifier;
        wrappers.put(this.identifier, this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected boolean place(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        IMultipart part = this.factory.createPart(world, pos, side, hit, stack, player);
        if (part == null) {
            return false;
        }
        if (MultipartHelper.canAddPart(world, pos, part)) {
            if (!world.field_72995_K) {
                MultipartHelper.addPart(world, pos, part);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.consumeItem(stack);
            }
            this.playPlacementSound(world, pos, stack, player);
            return true;
        }
        return false;
    }

    protected boolean placeDefault(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        Block placedBlock = Block.func_149634_a((Item)stack.func_77973_b());
        if (placedBlock == null) {
            throw new IllegalStateException("For non-ItemBlocks you need to write your own default placement handler!");
        }
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            return false;
        }
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        if (world.func_175716_a(placedBlock, pos, false, side, (Entity)null, stack)) {
            if (world.field_72995_K) {
                return true;
            }
            int i = stack.func_77973_b().func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = placedBlock.func_180642_a(world, pos, side, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c, i, (EntityLivingBase)player);
            if (((ItemBlock)stack.func_77973_b()).placeBlockAt(stack, player, world, pos, side, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c, iblockstate1)) {
                this.playPlacementSound(world, pos, stack, player);
                if (!player.field_71075_bZ.field_75098_d) {
                    this.consumeItem(stack);
                }
            }
            return true;
        }
        return false;
    }

    protected void consumeItem(ItemStack stack) {
        --stack.field_77994_a;
    }

    protected void playPlacementSound(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        SoundType sound;
        Block placedBlock = Block.func_149634_a((Item)stack.func_77973_b());
        if (placedBlock != null) {
            world.func_184133_a(player, pos, placedBlock.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, (placedBlock.func_185467_w().func_185843_a() + 1.0f) / 2.0f, placedBlock.func_185467_w().func_185847_b() * 0.8f);
        }
        if ((sound = this.getPlacementSound(stack)) != null) {
            world.func_184133_a(player, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
        }
    }

    protected SoundType getPlacementSound(ItemStack stack) {
        return SoundType.field_185853_f;
    }

    protected boolean isValidPlacement(World world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EnumHand hand = event.getHand();
        if (hand == null) {
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184586_b(hand);
        if (stack == null || !this.match.apply((Object)stack)) {
            return;
        }
        event.setCanceled(true);
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumFacing side = event.getFace();
        EntityPlayer player = event.getEntityPlayer();
        RayTraceResult mop = world.func_72933_a(RayTraceUtils.getStart(player), RayTraceUtils.getEnd(player));
        Vec3d hit = mop.field_72307_f.func_178788_d(new Vec3d((Vec3i)mop.func_178782_a()));
        if (this.doPlace(world, pos, side, hit, stack, player)) {
            player.func_184609_a(hand);
            if (world.field_72995_K) {
                new MessageWrappedPartPlacement(this.identifier, hand).send();
            }
        }
    }

    public boolean doPlace(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        if (this.doPlaceAt(world, pos, side, hit, stack, player)) {
            return true;
        }
        pos = pos.func_177972_a(side);
        return this.doPlaceAt(world, pos, side, hit, stack, player);
    }

    private boolean doPlaceAt(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos) && this.placeDefault(world, pos, side, hit, stack, player)) {
            return true;
        }
        return this.isValidPlacement(world, pos, side) && this.place(world, pos, side, hit, stack, player);
    }
}

