/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CapeBufferDownload
extends Thread {
    public String username;
    public String staticCapeUrl;
    public ResourceLocation resourceLocation;
    public ThreadDownloadImageData capeImage;
    boolean downloaded = false;

    public CapeBufferDownload(String name, String url) {
        this.username = name;
        this.staticCapeUrl = url;
        this.setDaemon(true);
        this.setName("Cape Download Thread");
    }

    @Override
    public void run() {
        try {
            this.download();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download() {
        try {
            this.resourceLocation = new ResourceLocation("mekanism/" + StringUtils.func_76338_a((String)this.username));
            this.capeImage = this.downloadCape();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.downloaded = true;
    }

    public ThreadDownloadImageData getImage() {
        return this.capeImage;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ThreadDownloadImageData downloadCape() {
        try {
            File capeFile = new File(this.resourceLocation.func_110623_a() + ".png");
            if (capeFile.exists()) {
                capeFile.delete();
            }
            TextureManager manager = Minecraft.func_71410_x().func_110434_K();
            ThreadDownloadImageData data = new ThreadDownloadImageData(capeFile, this.staticCapeUrl, null, null);
            manager.func_110579_a(this.resourceLocation, (ITextureObject)data);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

