/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.List;
import mekanism.api.MekanismConfig;
import mekanism.api.util.ListUtils;
import mekanism.api.util.UnitDisplayUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.common.inventory.container.ContainerThermalEvaporationController;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiThermalEvaporationController
extends GuiMekanism {
    public TileEntityThermalEvaporationController tileEntity;

    public GuiThermalEvaporationController(InventoryPlayer inventory, TileEntityThermalEvaporationController tentity) {
        super(tentity, new ContainerThermalEvaporationController(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiFluidGauge(new GuiFluidGauge.IFluidInfoHandler(){

            @Override
            public FluidTank getTank() {
                return GuiThermalEvaporationController.this.tileEntity.inputTank;
            }
        }, GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermalEvaporationController.png"), 6, 13));
        this.guiElements.add(new GuiFluidGauge(new GuiFluidGauge.IFluidInfoHandler(){

            @Override
            public FluidTank getTank() {
                return GuiThermalEvaporationController.this.tileEntity.outputTank;
            }
        }, GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermalEvaporationController.png"), 152, 13));
        this.guiElements.add(new GuiHeatInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.general.tempUnit.ordinal()];
                String environment = UnitDisplayUtils.getDisplayShort((double)GuiThermalEvaporationController.this.tileEntity.totalLoss * unit.intervalSize, false, unit);
                return ListUtils.asList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermalEvaporationController.png")));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(this.getStruct(), 50, 21, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.height") + ": " + this.tileEntity.height, 50, 30, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.temp") + ": " + this.getTemp(), 50, 39, 52480);
        this.renderScaledText(LangUtils.localize("gui.production") + ": " + (double)Math.round((double)this.tileEntity.lastGain * 100.0) / 100.0 + " mB/t", 50, 48, 52480, 76);
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(this.tileEntity.inputTank.getFluid() != null ? LangUtils.localizeFluidStack(this.tileEntity.inputTank.getFluid()) + ": " + this.tileEntity.inputTank.getFluidAmount() : LangUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 153 && xAxis <= 169 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(this.tileEntity.outputTank.getFluid() != null ? LangUtils.localizeFluidStack(this.tileEntity.outputTank.getFluid()) + ": " + this.tileEntity.outputTank.getFluidAmount() : LangUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 49 && xAxis <= 127 && yAxis >= 64 && yAxis <= 72) {
            this.func_146279_a(this.getTemp(), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    private String getStruct() {
        if (this.tileEntity.structured) {
            return LangUtils.localize("gui.formed");
        }
        if (this.tileEntity.controllerConflict) {
            return LangUtils.localize("gui.conflict");
        }
        return LangUtils.localize("gui.incomplete");
    }

    private String getTemp() {
        float temp = this.tileEntity.getTemperature();
        return MekanismUtils.getTemperatureDisplay(temp, UnitDisplayUtils.TemperatureUnit.AMBIENT);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermalEvaporationController.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int displayInt = this.tileEntity.getScaledTempLevel(78);
        this.func_73729_b(guiWidth + 49, guiHeight + 64, 176, 59, displayInt, 8);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }
}

