/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectedParser {
    private String context = null;
    private static final MatchBlock[] NO_MATCH_BLOCKS = new MatchBlock[0];

    public ConnectedParser(String context) {
        this.context = context;
    }

    public String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    public String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public MatchBlock[] parseMatchBlocks(String propMatchBlocks) {
        if (propMatchBlocks == null) {
            return null;
        }
        ArrayList<MatchBlock> list = new ArrayList<MatchBlock>();
        String[] blockStrs = Config.tokenize(propMatchBlocks, " ");
        for (int i = 0; i < blockStrs.length; ++i) {
            String blockStr = blockStrs[i];
            MatchBlock[] mbs = this.parseMatchBlock(blockStr);
            if (mbs == null) {
                return NO_MATCH_BLOCKS;
            }
            list.addAll(Arrays.asList(mbs));
        }
        MatchBlock[] mbs = list.toArray(new MatchBlock[list.size()]);
        return mbs;
    }

    public atl parseBlockState(String str, atl def) {
        MatchBlock[] mbs = this.parseMatchBlock(str);
        if (mbs == null) {
            return def;
        }
        if (mbs.length != 1) {
            return def;
        }
        MatchBlock mb = mbs[0];
        int blockId = mb.getBlockId();
        alu block = alu.b((int)blockId);
        return block.t();
    }

    public MatchBlock[] parseMatchBlock(String blockStr) {
        if (blockStr == null) {
            return null;
        }
        if ((blockStr = blockStr.trim()).length() <= 0) {
            return null;
        }
        String[] parts = Config.tokenize(blockStr, ":");
        String domain = "minecraft";
        int blockIndex = 0;
        if (parts.length > 1 && this.isFullBlockName(parts)) {
            domain = parts[0];
            blockIndex = 1;
        } else {
            domain = "minecraft";
            blockIndex = 0;
        }
        String blockPart = parts[blockIndex];
        String[] params = Arrays.copyOfRange(parts, blockIndex + 1, parts.length);
        alu[] blocks = this.parseBlockPart(domain, blockPart);
        if (blocks == null) {
            return null;
        }
        MatchBlock[] datas = new MatchBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            MatchBlock bd;
            alu block = blocks[i];
            int blockId = alu.a((alu)block);
            int[] metadatas = null;
            if (params.length > 0 && (metadatas = this.parseBlockMetadatas(block, params)) == null) {
                return null;
            }
            datas[i] = bd = new MatchBlock(blockId, metadatas);
        }
        return datas;
    }

    public boolean isFullBlockName(String[] parts) {
        if (parts.length < 2) {
            return false;
        }
        String part1 = parts[1];
        if (part1.length() < 1) {
            return false;
        }
        if (this.startsWithDigit(part1)) {
            return false;
        }
        return !part1.contains("=");
    }

    public boolean startsWithDigit(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        char ch = str.charAt(0);
        return Character.isDigit(ch);
    }

    public alu[] parseBlockPart(String domain, String blockPart) {
        if (this.startsWithDigit(blockPart)) {
            int[] ids = this.parseIntList(blockPart);
            if (ids == null) {
                return null;
            }
            alu[] blocks = new alu[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                int id = ids[i];
                alu block = alu.b((int)id);
                if (block == null) {
                    this.warn("Block not found for id: " + id);
                    return null;
                }
                blocks[i] = block;
            }
            return blocks;
        }
        String fullName = domain + ":" + blockPart;
        alu block = alu.b((String)fullName);
        if (block == null) {
            this.warn("Block not found for name: " + fullName);
            return null;
        }
        alu[] blocks = new alu[]{block};
        return blocks;
    }

    public int[] parseBlockMetadatas(alu block, String[] params) {
        if (params.length <= 0) {
            return null;
        }
        String param0 = params[0];
        if (this.startsWithDigit(param0)) {
            int[] mds = this.parseIntList(param0);
            return mds;
        }
        atl stateDefault = block.t();
        Collection properties = stateDefault.t();
        HashMap<aub, List<Comparable>> mapPropValues = new HashMap<aub, List<Comparable>>();
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (param.length() <= 0) continue;
            String[] parts = Config.tokenize(param, "=");
            if (parts.length != 2) {
                this.warn("Invalid block property: " + param);
                return null;
            }
            String key = parts[0];
            String valStr = parts[1];
            aub prop = ConnectedProperties.getProperty(key, properties);
            if (prop == null) {
                this.warn("Property not found: " + key + ", block: " + block);
                return null;
            }
            ArrayList<Comparable> list = (ArrayList<Comparable>)mapPropValues.get(key);
            if (list == null) {
                list = new ArrayList<Comparable>();
                mapPropValues.put(prop, list);
            }
            String[] vals = Config.tokenize(valStr, ",");
            for (int v = 0; v < vals.length; ++v) {
                String val = vals[v];
                Comparable propVal = ConnectedParser.parsePropertyValue(prop, val);
                if (propVal == null) {
                    this.warn("Property value not found: " + val + ", property: " + key + ", block: " + block);
                    return null;
                }
                list.add(propVal);
            }
        }
        if (mapPropValues.isEmpty()) {
            return null;
        }
        ArrayList<Integer> listMetadatas = new ArrayList<Integer>();
        for (int i = 0; i < 16; ++i) {
            int md = i;
            try {
                atl bs = this.getStateFromMeta(block, md);
                if (!this.matchState(bs, mapPropValues)) continue;
                listMetadatas.add(md);
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (listMetadatas.size() == 16) {
            return null;
        }
        int[] metadatas = new int[listMetadatas.size()];
        for (int i = 0; i < metadatas.length; ++i) {
            metadatas[i] = (Integer)listMetadatas.get(i);
        }
        return metadatas;
    }

    private atl getStateFromMeta(alu block, int md) {
        try {
            atl bs = block.a(md);
            if (block == alv.cF && md > 7) {
                atl bsLow = block.a(md & 7);
                bs = bs.a((aub)amy.a, bsLow.c((aub)amy.a));
            }
            return bs;
        }
        catch (IllegalArgumentException e) {
            return block.t();
        }
    }

    public static Comparable parsePropertyValue(aub prop, String valStr) {
        Class valueClass = prop.b();
        Comparable valueObj = ConnectedParser.parseValue(valStr, valueClass);
        if (valueObj == null) {
            Collection propertyValues = prop.c();
            valueObj = ConnectedParser.getPropertyValue(valStr, propertyValues);
        }
        return valueObj;
    }

    public static Comparable getPropertyValue(String value, Collection propertyValues) {
        for (Comparable obj : propertyValues) {
            if (!ConnectedParser.getValueName(obj).equals(value)) continue;
            return obj;
        }
        return null;
    }

    private static Object getValueName(Comparable obj) {
        if (obj instanceof ox) {
            ox iss = (ox)obj;
            return iss.m();
        }
        return obj.toString();
    }

    public static Comparable parseValue(String str, Class cls) {
        if (cls == String.class) {
            return str;
        }
        if (cls == Boolean.class) {
            return Boolean.valueOf(str);
        }
        if (cls == Float.class) {
            return Float.valueOf(str);
        }
        if (cls == Double.class) {
            return Double.valueOf(str);
        }
        if (cls == Integer.class) {
            return Integer.valueOf(str);
        }
        if (cls == Long.class) {
            return Long.valueOf(str);
        }
        return null;
    }

    public boolean matchState(atl bs, Map<aub, List<Comparable>> mapPropValues) {
        Set<aub> keys = mapPropValues.keySet();
        for (aub prop : keys) {
            List<Comparable> vals = mapPropValues.get(prop);
            Comparable bsVal = bs.c(prop);
            if (bsVal == null) {
                return false;
            }
            if (vals.contains(bsVal)) continue;
            return false;
        }
        return true;
    }

    public akf[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        boolean negative = false;
        if (str.startsWith("!")) {
            negative = true;
            str = str.substring(1);
        }
        String[] biomeNames = Config.tokenize(str, " ");
        ArrayList list = new ArrayList();
        for (int i = 0; i < biomeNames.length; ++i) {
            String biomeName = biomeNames[i];
            akf biome = this.findBiome(biomeName);
            if (biome == null) {
                this.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        if (negative) {
            ArrayList listAllBiomes = Lists.newArrayList((Iterator)akf.q.iterator());
            listAllBiomes.removeAll(list);
            list = listAllBiomes;
        }
        akf[] biomeArr = list.toArray(new akf[list.size()]);
        return biomeArr;
    }

    public akf findBiome(String biomeName) {
        if ((biomeName = biomeName.toLowerCase()).equals("nether")) {
            return akk.j;
        }
        Set biomeIds = akf.q.c();
        for (kq loc : biomeIds) {
            String name;
            akf biome = (akf)akf.q.c((Object)loc);
            if (biome == null || !(name = biome.l().replace(" ", "").toLowerCase()).equals(biomeName)) continue;
            return biome;
        }
        return null;
    }

    public int parseInt(String str) {
        if (str == null) {
            return -1;
        }
        int num = Config.parseInt(str, -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
        }
        return num;
    }

    public int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt(str, -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int[] parseIntList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize(str, " ,");
        for (int i = 0; i < intStrs.length; ++i) {
            String intStr = intStrs[i];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize(intStr, "-");
                if (subStrs.length != 2) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min < 0 || max < 0 || min > max) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n = min; n <= max; ++n) {
                    list.add(n);
                }
                continue;
            }
            int val = Config.parseInt(intStr, -1);
            if (val < 0) {
                this.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (Integer)list.get(i);
        }
        return ints;
    }

    public boolean[] parseFaces(String str, boolean[] defVal) {
        if (str == null) {
            return defVal;
        }
        EnumSet<cv> setFaces = EnumSet.allOf(cv.class);
        String[] faceStrs = Config.tokenize(str, " ,");
        for (int i = 0; i < faceStrs.length; ++i) {
            String faceStr = faceStrs[i];
            if (faceStr.equals("sides")) {
                setFaces.add(cv.c);
                setFaces.add(cv.d);
                setFaces.add(cv.e);
                setFaces.add(cv.f);
                continue;
            }
            if (faceStr.equals("all")) {
                setFaces.addAll(Arrays.asList(cv.n));
                continue;
            }
            cv face = this.parseFace(faceStr);
            if (face == null) continue;
            setFaces.add(face);
        }
        boolean[] faces = new boolean[cv.n.length];
        for (int i = 0; i < faces.length; ++i) {
            faces[i] = setFaces.contains(cv.n[i]);
        }
        return faces;
    }

    public cv parseFace(String str) {
        if ((str = str.toLowerCase()).equals("bottom") || str.equals("down")) {
            return cv.a;
        }
        if (str.equals("top") || str.equals("up")) {
            return cv.b;
        }
        if (str.equals("north")) {
            return cv.c;
        }
        if (str.equals("south")) {
            return cv.d;
        }
        if (str.equals("east")) {
            return cv.f;
        }
        if (str.equals("west")) {
            return cv.e;
        }
        Config.warn("Unknown face: " + str);
        return null;
    }

    public void dbg(String str) {
        Config.dbg("" + this.context + ": " + str);
    }

    public void warn(String str) {
        Config.warn("" + this.context + ": " + str);
    }

    public RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize(str, " ,");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            RangeInt ri2 = this.parseRangeInt(part);
            if (ri2 == null) {
                return null;
            }
            list.addRange(ri2);
        }
        return list;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(45) >= 0) {
            String[] parts = Config.tokenize(str, "-");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt(parts[0], -1);
            int max = Config.parseInt(parts[1], -1);
            if (min < 0 || max < 0) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt(str, -1);
        if (val < 0) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }

    public static boolean parseBoolean(String str) {
        if (str == null) {
            return false;
        }
        return str.toLowerCase().equals("true");
    }

    public static int parseColor(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static int parseColor4(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = (int)(Long.parseLong(str, 16) & 0xFFFFFFFFFFFFFFFFL);
            return val;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public ajk parseBlockRenderLayer(String str, ajk def) {
        if (str == null) {
            return def;
        }
        str = str.toLowerCase().trim();
        ajk[] layers = ajk.values();
        for (int i = 0; i < layers.length; ++i) {
            ajk layer = layers[i];
            if (!str.equals(layer.name().toLowerCase())) continue;
            return layer;
        }
        return def;
    }
}

