/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;

public class RandomMobs {
    private static Map locationProperties = new HashMap();
    private static bqm renderGlobal = null;
    private static boolean initialized = false;
    private static Random random = new Random();
    private static boolean working = false;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_MCPATCHER_MOB = "mcpatcher/mob/";
    private static final String[] DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};

    public static void entityLoaded(sn entity, ajs world) {
        int id;
        if (!(entity instanceof sx)) {
            return;
        }
        if (world == null) {
            return;
        }
        sx el = (sx)entity;
        el.spawnPosition = el.c();
        el.spawnBiome = world.b(el.spawnPosition);
        lw ws = Config.getWorldServer();
        if (ws == null) {
            return;
        }
        sn es = ws.a(entity.O());
        if (!(es instanceof sx)) {
            return;
        }
        sx els = (sx)es;
        UUID uuid = els.be();
        long uuidLow = uuid.getLeastSignificantBits();
        el.randomMobsId = id = (int)(uuidLow & Integer.MAX_VALUE);
    }

    public static void worldChanged(ajs oldWorld, ajs newWorld) {
        if (newWorld != null) {
            List entityList = newWorld.J();
            for (int e = 0; e < entityList.size(); ++e) {
                sn entity = (sn)entityList.get(e);
                RandomMobs.entityLoaded(entity, newWorld);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static kq getTextureLocation(kq loc) {
        if (working) {
            return loc;
        }
        try {
            working = true;
            if (!initialized) {
                RandomMobs.initialize();
            }
            if (renderGlobal == null) {
                kq kq2 = loc;
                return kq2;
            }
            sn entity = RandomMobs.renderGlobal.renderedEntity;
            if (!(entity instanceof sx)) {
                kq kq3 = loc;
                return kq3;
            }
            sx entityLiving = (sx)entity;
            String name = loc.a();
            if (!name.startsWith(PREFIX_TEXTURES_ENTITY)) {
                kq kq4 = loc;
                return kq4;
            }
            RandomMobsProperties props = RandomMobs.getProperties(loc);
            if (props == null) {
                kq kq5 = loc;
                return kq5;
            }
            kq kq6 = props.getTextureLocation(loc, entityLiving);
            return kq6;
        }
        finally {
            working = false;
        }
    }

    private static RandomMobsProperties getProperties(kq loc) {
        String name = loc.a();
        RandomMobsProperties props = (RandomMobsProperties)locationProperties.get(name);
        if (props == null) {
            props = RandomMobs.makeProperties(loc);
            locationProperties.put(name, props);
        }
        return props;
    }

    private static RandomMobsProperties makeProperties(kq loc) {
        RandomMobsProperties props;
        String path = loc.a();
        kq propLoc = RandomMobs.getPropertyLocation(loc);
        if (propLoc != null && (props = RandomMobs.parseProperties(propLoc, loc)) != null) {
            return props;
        }
        kq[] variants = RandomMobs.getTextureVariants(loc);
        return new RandomMobsProperties(path, variants);
    }

    private static RandomMobsProperties parseProperties(kq propLoc, kq resLoc) {
        try {
            String path = propLoc.a();
            Config.dbg("RandomMobs: " + resLoc.a() + ", variants: " + path);
            InputStream in = Config.getResourceStream(propLoc);
            if (in == null) {
                Config.warn("RandomMobs properties not found: " + path);
                return null;
            }
            Properties props = new Properties();
            props.load(in);
            in.close();
            RandomMobsProperties rmp = new RandomMobsProperties(props, path, resLoc);
            if (!rmp.isValid(path)) {
                return null;
            }
            return rmp;
        }
        catch (FileNotFoundException e) {
            Config.warn("RandomMobs file not found: " + resLoc.a());
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static kq getPropertyLocation(kq loc) {
        String pathProps;
        kq locProps;
        kq locMcp = RandomMobs.getMcpatcherLocation(loc);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        String path = locMcp.a();
        String pathBase = path;
        if (pathBase.endsWith(SUFFIX_PNG)) {
            pathBase = pathBase.substring(0, pathBase.length() - SUFFIX_PNG.length());
        }
        if (Config.hasResource(locProps = new kq(domain, pathProps = pathBase + SUFFIX_PROPERTIES))) {
            return locProps;
        }
        String pathParent = RandomMobs.getParentPath(pathBase);
        if (pathParent == null) {
            return null;
        }
        kq locParentProps = new kq(domain, pathParent + SUFFIX_PROPERTIES);
        if (Config.hasResource(locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    public static kq getMcpatcherLocation(kq loc) {
        String path = loc.a();
        if (!path.startsWith(PREFIX_TEXTURES_ENTITY)) {
            return null;
        }
        String pathMcp = PREFIX_MCPATCHER_MOB + path.substring(PREFIX_TEXTURES_ENTITY.length());
        return new kq(loc.b(), pathMcp);
    }

    public static kq getLocationIndexed(kq loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String pathNew = prefix + index + suffix;
        kq locNew = new kq(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentPath(String path) {
        for (int i = 0; i < DEPENDANT_SUFFIXES.length; ++i) {
            String suffix = DEPENDANT_SUFFIXES[i];
            if (!path.endsWith(suffix)) continue;
            String pathParent = path.substring(0, path.length() - suffix.length());
            return pathParent;
        }
        return null;
    }

    private static kq[] getTextureVariants(kq loc) {
        ArrayList<kq> list = new ArrayList<kq>();
        list.add(loc);
        kq locMcp = RandomMobs.getMcpatcherLocation(loc);
        if (locMcp == null) {
            return null;
        }
        for (int i = 1; i < list.size() + 10; ++i) {
            int index = i + 1;
            kq locIndex = RandomMobs.getLocationIndexed(locMcp, index);
            if (!Config.hasResource(locIndex)) continue;
            list.add(locIndex);
        }
        if (list.size() <= 1) {
            return null;
        }
        kq[] locs = list.toArray(new kq[list.size()]);
        Config.dbg("RandomMobs: " + loc.a() + ", variants: " + locs.length);
        return locs;
    }

    public static void resetTextures() {
        locationProperties.clear();
        if (Config.isRandomMobs()) {
            RandomMobs.initialize();
        }
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        if (renderGlobal == null) {
            return;
        }
        initialized = true;
        ArrayList<String> list = new ArrayList<String>();
        list.add("bat");
        list.add("blaze");
        list.add("cat/black");
        list.add("cat/ocelot");
        list.add("cat/red");
        list.add("cat/siamese");
        list.add("chicken");
        list.add("cow/cow");
        list.add("cow/mooshroom");
        list.add("creeper/creeper");
        list.add("enderman/enderman");
        list.add("enderman/enderman_eyes");
        list.add("ghast/ghast");
        list.add("ghast/ghast_shooting");
        list.add("iron_golem");
        list.add("pig/pig");
        list.add("sheep/sheep");
        list.add("sheep/sheep_fur");
        list.add("silverfish");
        list.add("skeleton/skeleton");
        list.add("skeleton/wither_skeleton");
        list.add("slime/slime");
        list.add("slime/magmacube");
        list.add("snowman");
        list.add("spider/cave_spider");
        list.add("spider/spider");
        list.add("spider_eyes");
        list.add("squid");
        list.add("villager/villager");
        list.add("villager/butcher");
        list.add("villager/farmer");
        list.add("villager/librarian");
        list.add("villager/priest");
        list.add("villager/smith");
        list.add("wither/wither");
        list.add("wither/wither_armor");
        list.add("wither/wither_invulnerable");
        list.add("wolf/wolf");
        list.add("wolf/wolf_angry");
        list.add("wolf/wolf_collar");
        list.add("wolf/wolf_tame");
        list.add("zombie_pigman");
        list.add("zombie/zombie");
        list.add("zombie/zombie_villager");
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            String tex = PREFIX_TEXTURES_ENTITY + name + SUFFIX_PNG;
            kq texLoc = new kq(tex);
            if (!Config.hasResource(texLoc)) {
                Config.warn("Not found: " + texLoc);
            }
            RandomMobs.getProperties(texLoc);
        }
    }
}

