/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.util;

import com.google.common.collect.ImmutableSet;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import org.lwjgl.util.vector.Vector3f;

public final class HashingStrategies {
    public static final HashingStrategy<byte[]> BYTE_ARRAY = new ByteArray();
    public static final HashingStrategy<float[]> FLOAT_ARRAY = new FloatArray();
    public static final HashingStrategy<float[][]> FLOAT_ARRAY_ARRAY = new FloatArrayArray();
    public static final HashingStrategy<int[]> INT_ARRAY = new IntArray();
    public static final HashingStrategy GENERIC = new ObjectStrategy();
    public static final HashingStrategy IDENTITY = new IdentityHashingStrategy();
    public static final HashingStrategy<ItemCameraTransforms> ITEM_CAMERA_TRANSFORMS = new ItemCameraTransformsStrategy();
    public static final HashingStrategy<ItemTransformVec3f> ITEM_TRANSFORM_VEC3F = new ItemTransformVecStrategy();

    private static final class FloatArrayArray
    implements HashingStrategy<float[][]> {
        private FloatArrayArray() {
        }

        public int computeHashCode(float[][] object) {
            int hash = 1;
            for (float[] anObject : object) {
                hash = hash * 31 + Arrays.hashCode(anObject);
            }
            return hash;
        }

        public boolean equals(float[][] o1, float[][] o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (o1.length != o2.length) {
                return false;
            }
            for (int i = 0; i < o1.length; ++i) {
                if (Arrays.equals(o1[i], o2[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static final class FloatArray
    implements HashingStrategy<float[]> {
        private FloatArray() {
        }

        public int computeHashCode(float[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(float[] o1, float[] o2) {
            return Arrays.equals(o1, o2);
        }
    }

    private static final class IntArray
    implements HashingStrategy<int[]> {
        private IntArray() {
        }

        public int computeHashCode(int[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(int[] o1, int[] o2) {
            return Arrays.equals(o1, o2);
        }
    }

    private static final class ByteArray
    implements HashingStrategy<byte[]> {
        private ByteArray() {
        }

        public int computeHashCode(byte[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(byte[] o1, byte[] o2) {
            return Arrays.equals(o1, o2);
        }
    }

    private static final class ObjectStrategy
    implements HashingStrategy {
        private ObjectStrategy() {
        }

        public int computeHashCode(Object object) {
            return Objects.hashCode(object);
        }

        public boolean equals(Object o1, Object o2) {
            return Objects.equals(o1, o2);
        }
    }

    private static final class ItemTransformVecStrategy
    implements HashingStrategy<ItemTransformVec3f> {
        private ItemTransformVecStrategy() {
        }

        public int computeHashCode(ItemTransformVec3f transform) {
            int hash = 1;
            for (Vector3f vector : ImmutableSet.of((Object)transform.field_178364_b, (Object)transform.field_178363_d, (Object)transform.field_178365_c)) {
                hash = ((hash * 31 + Float.floatToIntBits(vector.getX())) * 31 + Float.floatToIntBits(vector.getY())) * 31 + Float.floatToIntBits(vector.getZ());
            }
            return hash;
        }

        public boolean equals(ItemTransformVec3f o1, ItemTransformVec3f o2) {
            return Objects.equals(o1, o2);
        }
    }

    private static final class ItemCameraTransformsStrategy
    implements HashingStrategy<ItemCameraTransforms> {
        private ItemCameraTransformsStrategy() {
        }

        public int computeHashCode(ItemCameraTransforms object) {
            int hash = 1;
            for (ItemTransformVec3f transform : ImmutableSet.of((Object)object.field_188038_m, (Object)object.field_188039_n, (Object)object.field_181700_p, (Object)object.field_181699_o, (Object)object.field_178354_e, (Object)object.field_178353_d, (Object[])new ItemTransformVec3f[]{object.field_188036_k, object.field_188037_l})) {
                for (Vector3f vector : ImmutableSet.of((Object)transform.field_178364_b, (Object)transform.field_178363_d, (Object)transform.field_178365_c)) {
                    hash = ((hash * 31 + Float.floatToIntBits(vector.getX())) * 31 + Float.floatToIntBits(vector.getY())) * 31 + Float.floatToIntBits(vector.getZ());
                }
            }
            return hash;
        }

        public boolean equals(ItemCameraTransforms o1, ItemCameraTransforms o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return Objects.equals(o1.field_188038_m, o2.field_188038_m) && Objects.equals(o1.field_188039_n, o2.field_188039_n) && Objects.equals(o1.field_181700_p, o2.field_181700_p) && Objects.equals(o1.field_181699_o, o2.field_181699_o) && Objects.equals(o1.field_178354_e, o2.field_178354_e) && Objects.equals(o1.field_178353_d, o2.field_178353_d) && Objects.equals(o1.field_188036_k, o2.field_188036_k) && Objects.equals(o1.field_188037_l, o2.field_188037_l);
        }
    }
}

