/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.BiFunction;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.foamfix.coremod.patches.BlockPosPatch;
import pl.asie.foamfix.coremod.patches.ClassGetSimpleNamePatch;
import pl.asie.foamfix.coremod.patches.EntityDataManagerPatch;
import pl.asie.foamfix.coremod.patches.FastAirLookupPatch;
import pl.asie.foamfix.coremod.patches.ReturnIfBooleanTruePatch;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.patchy.Patchy;
import pl.asie.patchy.TransformerHandler;
import pl.asie.patchy.handlers.TransformerHandlerByteArray;
import pl.asie.patchy.handlers.TransformerHandlerClassNode;
import pl.asie.patchy.handlers.TransformerHandlerClassVisitor;
import pl.asie.patchy.helpers.ConstructorReplacingTransformer;

public class FoamFixTransformer
implements IClassTransformer {
    private static BiFunction<ClassVisitor, Remapper, ClassVisitor> REMAPPER_CREATOR;
    private static final Patchy patchy;

    public static ClassNode spliceClasses(ClassNode data, String className, String ... methods) {
        try {
            byte[] dataSplice = ((LaunchClassLoader)FoamFixTransformer.class.getClassLoader()).getClassBytes(className);
            return FoamFixTransformer.spliceClasses(data, dataSplice, className, methods);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassNode spliceClasses(ClassNode nodeData, byte[] dataSplice, String className, String ... methods) {
        int j;
        boolean added;
        MethodNode mn;
        int i;
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found! This is a FoamFix bug!");
        }
        HashSet methodSet = Sets.newHashSet((Object[])methods);
        ArrayList methodList = Lists.newArrayList((Object[])methods);
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept(REMAPPER_CREATOR.apply((ClassVisitor)nodeSplice, remapper), 8);
        for (String s : nodeSplice.interfaces) {
            if (!s.contains("IFoamFix")) continue;
            nodeData.interfaces.add(s);
            System.out.println("Added INTERFACE: " + s);
        }
        for (i = 0; i < nodeSplice.methods.size(); ++i) {
            if (!methodSet.contains(((MethodNode)nodeSplice.methods.get((int)i)).name)) continue;
            mn = (MethodNode)nodeSplice.methods.get(i);
            added = false;
            for (j = 0; j < nodeData.methods.size(); ++j) {
                if (!((MethodNode)nodeData.methods.get((int)j)).name.equals(mn.name) || !((MethodNode)nodeData.methods.get((int)j)).desc.equals(mn.desc)) continue;
                MethodNode oldMn = (MethodNode)nodeData.methods.get(j);
                System.out.println("Spliced in METHOD: " + targetClassName + "." + mn.name);
                nodeData.methods.set(j, mn);
                oldMn.name = (String)methodList.get(methodList.indexOf(oldMn.name) & 0xFFFFFFFE) + "_foamfix_old";
                nodeData.methods.add(oldMn);
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added METHOD: " + targetClassName + "." + mn.name);
            nodeData.methods.add(mn);
            added = true;
        }
        for (i = 0; i < nodeSplice.fields.size(); ++i) {
            if (!methodSet.contains(((FieldNode)nodeSplice.fields.get((int)i)).name)) continue;
            mn = (FieldNode)nodeSplice.fields.get(i);
            added = false;
            for (j = 0; j < nodeData.fields.size(); ++j) {
                if (!((FieldNode)nodeData.fields.get((int)j)).name.equals(mn.name) || !((FieldNode)nodeData.fields.get((int)j)).desc.equals(mn.desc)) continue;
                System.out.println("Spliced in FIELD: " + targetClassName + "." + mn.name);
                nodeData.fields.set(j, mn);
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added FIELD: " + targetClassName + "." + mn.name);
            nodeData.fields.add(mn);
            added = true;
        }
        return nodeData;
    }

    public static ClassNode replaceClasses(ClassNode data, String className) {
        try {
            byte[] dataSplice = ((LaunchClassLoader)FoamFixTransformer.class.getClassLoader()).getClassBytes(className);
            return FoamFixTransformer.replaceClasses(data, dataSplice, className);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassNode replaceClasses(ClassNode nodeData, byte[] dataSplice, String className) {
        System.out.println("replacing " + nodeData.name + " with " + className);
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found! This is a FoamFix bug!");
        }
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept(REMAPPER_CREATOR.apply((ClassVisitor)nodeSplice, remapper), 8);
        return nodeSplice;
    }

    public static void init() {
        patchy.registerHandler(byte[].class, new TransformerHandlerByteArray(patchy));
        patchy.registerHandler(ClassNode.class, new TransformerHandlerClassNode(patchy));
        patchy.registerHandler(ClassVisitor.class, new TransformerHandlerClassVisitor(patchy));
        TransformerHandler<byte[]> handler = patchy.getHandler(byte[].class);
        TransformerHandler<ClassNode> handlerCN = patchy.getHandler(ClassNode.class);
        TransformerHandler<ClassVisitor> handlerCV = patchy.getHandler(ClassVisitor.class);
        if (FoamFixShared.config.geSmallPropertyStorage) {
            patchy.addTransformerId("smallPropertyStorage_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.common.FoamyBlockStateContainer", "createState", "createState"), "net.minecraft.block.state.BlockStateContainer");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.common.FoamyExtendedBlockStateContainer", "createState", "createState"), "net.minecraftforge.common.property.ExtendedBlockState");
        }
        if (FoamFixShared.config.twImmediateLightingUpdates) {
            patchy.addTransformerId("immediateLightingUpdates_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.client.RenderGlobalImmediateInject", "notifyLightSet", "func_174959_b"), "net.minecraft.client.renderer.RenderGlobal");
        }
        if (FoamFixShared.config.clDynamicItemModels) {
            patchy.addTransformerId("dynamicItemModels_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.client.FoamFixDynamicItemModels", "bake", "bake"), "net.minecraftforge.client.model.ItemLayerModel");
        }
        if (FoamFixShared.config.clParallelModelBaking) {
            patchy.addTransformerId("parallelModelBaking_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.client.ModelBakeryParallelInject", "setupModelRegistry", "func_177570_a"), "net.minecraftforge.client.model.ModelLoader");
        }
        if (FoamFixShared.config.clFasterVertexLighter) {
            patchy.addTransformerId("fasterVertexLighter_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.client.BlockInfoInject", "getRawB", "getRawB", "getRawS", "getRawS", "updateRawBS", "updateRawBS"), "net.minecraftforge.client.model.pipeline.BlockInfo");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.client.VertexLighterFlatInject", "setParent", "setParent", "updateLightmap", "updateLightmap", "getVertexFormatWithNormal", "getVertexFormatWithNormal", "updateBlockInfo", "updateBlockInfo"), "net.minecraftforge.client.model.pipeline.VertexLighterFlat");
        }
        if (FoamFixShared.config.geReplaceSimpleName) {
            patchy.addTransformerId("replaceSimpleName_v1");
            handlerCV.add(new ClassGetSimpleNamePatch("updateEntities", "func_72939_s"), "net.minecraft.world.World");
        }
        if (FoamFixShared.config.geBlockPosPatch) {
            patchy.addTransformerId("blockPosPatch_v1");
            handlerCN.add(BlockPosPatch::patchVec3i, "net.minecraft.util.math.Vec3i");
            handlerCV.add(BlockPosPatch::patchOtherClass, new String[0]);
        }
        if (FoamFixShared.config.geFasterEntityLookup) {
            patchy.addTransformerId("fasterClassInheritanceMultiMap_v1");
            handlerCV.add(new ConstructorReplacingTransformer("net.minecraft.util.ClassInheritanceMultiMap", "pl.asie.foamfix.coremod.common.FoamyClassInheritanceMultiMap", "<init>"), "net.minecraft.world.chunk.Chunk");
        }
        if (FoamFixShared.config.geFasterAirLookup) {
            patchy.addTransformerId("fasterAirLookup_v1");
            handlerCN.add(new FastAirLookupPatch(), "net.minecraft.item.ItemStack");
        }
        if (FoamFixShared.config.geFasterPropertyComparisons) {
            patchy.addTransformerId("fasterPropertyComparisons_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.PropertyFasterComparisonsInject$Bool", "equals", "equals", "hashCode", "hashCode"), "net.minecraft.block.properties.PropertyBool");
            for (String s : new String[]{"net.minecraft.block.properties.PropertyInteger", "net.minecraft.block.properties.PropertyEnum"}) {
                handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.CachingHashCodeInject", "hashCode", "hashCode", "foamfix_hashCode", "foamfix_hashCode", "foamfix_hashCode_calced", "foamfix_hashCode_calced"), s);
            }
        }
        if (FoamFixShared.config.geFasterEntityDataManager) {
            patchy.addTransformerId("fasterEntityDataManager_v1");
            handlerCN.add(new EntityDataManagerPatch(), "net.minecraft.network.datasync.EntityDataManager");
        }
        patchy.addTransformerId("disableTextureAnimations_v1");
        handlerCN.add(new ReturnIfBooleanTruePatch("clDisableTextureAnimations", "updateAnimations", "func_94248_c"), "net.minecraft.client.renderer.texture.TextureMap");
    }

    public byte[] transform(String name, String transformedName, byte[] dataOrig) {
        return patchy.transform(name, transformedName, dataOrig);
    }

    static {
        try {
            Class.forName("org.objectweb.asm.commons.ClassRemapper");
            REMAPPER_CREATOR = ClassRemapper::new;
        }
        catch (ClassNotFoundException e) {
            REMAPPER_CREATOR = RemappingClassAdapter::new;
        }
        patchy = new Patchy();
    }
}

